/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.ArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;

class ObjectArrayFieldVariable
extends AbstractObjectVariable
implements Field {
    private final ArrayReference array;
    private int index;
    private int maxIndexLog;
    private String declaredType;

    ObjectArrayFieldVariable(JPDADebuggerImpl jPDADebuggerImpl, ObjectReference objectReference, String string, ArrayReference arrayReference, int n, int n2, String string2) {
        super(jPDADebuggerImpl, objectReference, string2 + '.' + n + (objectReference instanceof ObjectReference ? "^" : ""));
        this.index = n;
        this.maxIndexLog = ArrayFieldVariable.log10(n2);
        this.declaredType = string;
        this.array = arrayReference;
    }

    public String getName() {
        return ArrayFieldVariable.getName(this.maxIndexLog, this.index);
    }

    public String getClassName() {
        return this.getType();
    }

    public JPDAClassType getDeclaringClass() {
        try {
            return new JPDAClassTypeImpl(this.getDebugger(), (ReferenceType)ValueWrapper.type(this.array));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw internalExceptionWrapper.getCause();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            throw vMDisconnectedExceptionWrapper.getCause();
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw objectCollectedExceptionWrapper.getCause();
        }
    }

    public boolean isStatic() {
        return false;
    }

    public String getDeclaredType() {
        return this.declaredType;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            ArrayReferenceWrapper.setValue(this.array, this.index, value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)internalExceptionWrapper.getCause());
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)objectCollectedExceptionWrapper.getCause());
        }
    }

    public ObjectArrayFieldVariable clone() {
        ObjectArrayFieldVariable objectArrayFieldVariable = new ObjectArrayFieldVariable(this.getDebugger(), (ObjectReference)this.getJDIValue(), this.getDeclaredType(), this.array, this.index, 0, this.getID());
        objectArrayFieldVariable.maxIndexLog = this.maxIndexLog;
        return objectArrayFieldVariable;
    }

    public String toString() {
        return "ObjectArrayFieldVariable " + this.getName();
    }
}

