/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InterfaceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.ClassVariableImpl;
import org.netbeans.modules.debugger.jpda.models.FieldVariable;
import org.netbeans.modules.debugger.jpda.models.ObjectFieldVariable;
import org.netbeans.modules.debugger.jpda.models.SuperVariable;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDAClassTypeImpl
implements JPDAClassType {
    private static final Logger loggerValue = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    private JPDADebuggerImpl debugger;
    private ReferenceType classType;

    public JPDAClassTypeImpl(JPDADebuggerImpl jPDADebuggerImpl, ReferenceType referenceType) {
        this.debugger = jPDADebuggerImpl;
        this.classType = referenceType;
    }

    public ReferenceType getType() {
        return this.classType;
    }

    public String getName() {
        return this.classType.name();
    }

    public String getSourceName() throws AbsentInformationException {
        return this.classType.sourceName();
    }

    public ClassVariable classObject() {
        ClassObjectReference classObjectReference;
        try {
            classObjectReference = ReferenceTypeWrapper.classObject(this.classType);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            classObjectReference = null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            classObjectReference = null;
        }
        catch (UnsupportedOperationExceptionWrapper unsupportedOperationExceptionWrapper) {
            classObjectReference = null;
        }
        return new ClassVariableImpl(this.debugger, classObjectReference, "");
    }

    public ObjectVariable getClassLoader() {
        ClassLoaderReference classLoaderReference;
        try {
            classLoaderReference = ReferenceTypeWrapper.classLoader(this.classType);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            classLoaderReference = null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            classLoaderReference = null;
        }
        return new AbstractObjectVariable(this.debugger, classLoaderReference, "Loader " + this.getName());
    }

    public SuperVariable getSuperClass() {
        if (this.classType instanceof ClassType) {
            try {
                return new SuperVariable(this.debugger, null, ClassTypeWrapper.superclass((ClassType)this.classType), this.getName());
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return null;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return null;
            }
        }
        return null;
    }

    public List<JPDAClassType> getSubClasses() {
        List<ReferenceType> list;
        if (this.classType instanceof ClassType && (list = ClassTypeWrapper.subclasses0((ClassType)this.classType)).size() > 0) {
            ArrayList<JPDAClassTypeImpl> arrayList = new ArrayList<JPDAClassTypeImpl>(list.size());
            for (ClassType classType : list) {
                arrayList.add(new JPDAClassTypeImpl(this.debugger, classType));
            }
            return Collections.unmodifiableList(arrayList);
        }
        if (this.classType instanceof InterfaceType) {
            list = InterfaceTypeWrapper.subinterfaces0((InterfaceType)this.classType);
            List<ClassType> list2 = InterfaceTypeWrapper.implementors0((InterfaceType)this.classType);
            int n = list.size();
            int n2 = list2.size();
            if (n > 0 || n2 > 0) {
                ArrayList<JPDAClassTypeImpl> arrayList = new ArrayList<JPDAClassTypeImpl>(n + n2);
                for (InterfaceType referenceType : list) {
                    arrayList.add(new JPDAClassTypeImpl(this.debugger, referenceType));
                }
                for (ClassType classType : list2) {
                    arrayList.add(new JPDAClassTypeImpl(this.debugger, classType));
                }
                return Collections.unmodifiableList(arrayList);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isInstanceOf(String string) {
        List<ReferenceType> list;
        try {
            list = VirtualMachineWrapper.classesByName(MirrorWrapper.virtualMachine(this.classType), string);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        for (ReferenceType referenceType : list) {
            if (!EvaluatorVisitor.instanceOf(this.classType, referenceType)) continue;
            return true;
        }
        return false;
    }

    public List<org.netbeans.api.debugger.jpda.Field> staticFields() {
        List<Field> list;
        try {
            list = ReferenceTypeWrapper.allFields0(this.classType);
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            return Collections.emptyList();
        }
        ArrayList<org.netbeans.api.debugger.jpda.Field> arrayList = new ArrayList<org.netbeans.api.debugger.jpda.Field>();
        for (int i = 0; i < list.size(); ++i) {
            Value value = null;
            Field field = list.get(i);
            try {
                if (!TypeComponentWrapper.isStatic(field)) continue;
                if (loggerValue.isLoggable(Level.FINE)) {
                    loggerValue.fine("STARTED : " + this.classType + ".getValue(" + field + ")");
                }
                value = ReferenceTypeWrapper.getValue(this.classType, field);
                if (loggerValue.isLoggable(Level.FINE)) {
                    loggerValue.fine("FINISHED: " + this.classType + ".getValue(" + field + ") = " + value);
                }
                if (value instanceof PrimitiveValue) {
                    arrayList.add(new FieldVariable(this.debugger, (PrimitiveValue)value, field, "", null));
                    continue;
                }
                arrayList.add(new ObjectFieldVariable(this.debugger, (ObjectReference)value, field, "", null));
                continue;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                continue;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return Collections.emptyList();
            }
        }
        return arrayList;
    }

    public long getInstanceCount() {
        if (JPDAUtils.IS_JDK_16) {
            try {
                long[] lArray = VirtualMachineWrapper.instanceCounts(MirrorWrapper.virtualMachine(this.classType), Collections.singletonList(this.classType));
                return lArray[0];
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return 0L;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return 0L;
            }
        }
        return 0L;
    }

    public List<ObjectVariable> getInstances(long l) {
        if (JPDAUtils.IS_JDK_16) {
            List<ObjectReference> list;
            try {
                list = ReferenceTypeWrapper.instances(this.classType, l);
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return Collections.emptyList();
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return Collections.emptyList();
            }
            return new AbstractList<ObjectVariable>(){

                @Override
                public ObjectVariable get(int n) {
                    ObjectReference objectReference = (ObjectReference)list.get(n);
                    return new AbstractObjectVariable(JPDAClassTypeImpl.this.debugger, objectReference, JPDAClassTypeImpl.this.classType.name() + " instance " + n);
                }

                @Override
                public int size() {
                    return list.size();
                }
            };
        }
        return Collections.emptyList();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JPDAClassTypeImpl)) {
            return false;
        }
        return ((Object)this.classType).equals(((JPDAClassTypeImpl)object).classType);
    }

    public int hashCode() {
        return ((Object)this.classType).hashCode() + 1000;
    }
}

