/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.FieldWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;

class FieldVariable
extends AbstractVariable
implements org.netbeans.api.debugger.jpda.Field {
    protected Field field;
    private ObjectReference objectReference;

    FieldVariable(JPDADebuggerImpl jPDADebuggerImpl, PrimitiveValue primitiveValue, Field field, String string, ObjectReference objectReference) {
        super(jPDADebuggerImpl, primitiveValue, FieldVariable.getID(string, field));
        this.field = field;
        this.objectReference = objectReference;
    }

    private static String getID(String string, Field field) {
        try {
            return string + '.' + TypeComponentWrapper.name(field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return string + '.' + internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return string + ".0";
        }
    }

    public String getName() {
        try {
            return TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public String getClassName() {
        try {
            return ReferenceTypeWrapper.name(TypeComponentWrapper.declaringType(this.field));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public JPDAClassType getDeclaringClass() {
        try {
            return new JPDAClassTypeImpl(this.getDebugger(), (ReferenceType)ValueWrapper.type(this.objectReference));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw internalExceptionWrapper.getCause();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            throw vMDisconnectedExceptionWrapper.getCause();
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw objectCollectedExceptionWrapper.getCause();
        }
    }

    public String getDeclaredType() {
        try {
            return FieldWrapper.typeName(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public boolean isStatic() {
        return TypeComponentWrapper.isStatic0(this.field);
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            boolean bl = false;
            if (this.objectReference != null) {
                ObjectReferenceWrapper.setValue(this.objectReference, this.field, value);
                bl = true;
            } else {
                ReferenceType referenceType = TypeComponentWrapper.declaringType(this.field);
                if (referenceType instanceof ClassType) {
                    ClassType classType = (ClassType)referenceType;
                    ClassTypeWrapper.setValue(classType, this.field, value);
                    bl = true;
                }
            }
            if (!bl) {
                throw new InvalidExpressionException(this.field.toString());
            }
        }
        catch (IllegalArgumentExceptionWrapper illegalArgumentExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)illegalArgumentExceptionWrapper.getCause());
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)internalExceptionWrapper);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)vMDisconnectedExceptionWrapper);
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)classNotPreparedExceptionWrapper);
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)objectCollectedExceptionWrapper);
        }
    }

    public FieldVariable clone() {
        String string;
        try {
            string = TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            string = internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            string = "0";
        }
        FieldVariable fieldVariable = new FieldVariable(this.getDebugger(), (PrimitiveValue)this.getJDIValue(), this.field, this.getID().substring(0, this.getID().length() - ("." + string + (this.getJDIValue() instanceof ObjectReference ? "^" : "")).length()), this.objectReference);
        return fieldVariable;
    }

    public String toString() {
        try {
            return "FieldVariable " + TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "Disconnected";
        }
    }
}

