/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectReferenceWrapper {
    private ObjectReferenceWrapper() {
    }

    public static void disableCollection(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            objectReference.disableCollection();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static void enableCollection(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            objectReference.enableCollection();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static int entryCount0(ObjectReference objectReference) throws IncompatibleThreadStateException {
        try {
            return objectReference.entryCount();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return 0;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return 0;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return 0;
        }
    }

    public static int entryCount(ObjectReference objectReference) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return objectReference.entryCount();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static boolean equals0(ObjectReference objectReference, Object object) {
        try {
            return ((Object)objectReference).equals(object);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return false;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return false;
        }
    }

    public static boolean equals(ObjectReference objectReference, Object object) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return ((Object)objectReference).equals(object);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static Value getValue(ObjectReference objectReference, Field field) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return objectReference.getValue(field);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static Map<Field, Value> getValues0(ObjectReference objectReference, List<? extends Field> list) {
        try {
            return objectReference.getValues(list);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return Collections.emptyMap();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return Collections.emptyMap();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return Collections.emptyMap();
        }
    }

    public static Map<Field, Value> getValues(ObjectReference objectReference, List<? extends Field> list) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return objectReference.getValues(list);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static int hashCode0(ObjectReference objectReference) {
        try {
            return ((Object)objectReference).hashCode();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return 0;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return 0;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return 0;
        }
    }

    public static int hashCode(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return ((Object)objectReference).hashCode();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static Value invokeMethod(ObjectReference objectReference, ThreadReference threadReference, Method method, List<? extends Value> list, int n) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            try {
                return objectReference.invokeMethod(threadReference, method, list, n);
            }
            catch (InternalException internalException) {
                try {
                    if (internalException.errorCode() == 502) {
                        InternalException internalException2 = (InternalException)Exceptions.attachLocalizedMessage((Throwable)internalException, (String)NbBundle.getMessage(JPDADebuggerImpl.class, (String)"JDWPError502"));
                        Exceptions.printStackTrace((Throwable)internalException2);
                        return null;
                    }
                    throw internalException;
                }
                catch (InternalException internalException3) {
                    JDIExceptionReporter.report(internalException3);
                    throw new InternalExceptionWrapper(internalException3);
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static boolean isCollected0(ObjectReference objectReference) {
        try {
            return objectReference.isCollected();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return false;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return false;
        }
    }

    public static boolean isCollected(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return objectReference.isCollected();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static ThreadReference owningThread(ObjectReference objectReference) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return objectReference.owningThread();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static ReferenceType referenceType(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return objectReference.referenceType();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static List<ObjectReference> referringObjects(ObjectReference objectReference, long l) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        try {
            return (List)ObjectReference.class.getMethod("referringObjects", Long.TYPE).invoke((Object)objectReference, l);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new IllegalStateException(securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof InternalException) {
                JDIExceptionReporter.report((InternalException)throwable);
                throw new InternalExceptionWrapper((InternalException)throwable);
            }
            if (throwable instanceof VMDisconnectedException) {
                throw new VMDisconnectedExceptionWrapper((VMDisconnectedException)throwable);
            }
            throw new IllegalStateException(throwable);
        }
    }

    public static List<ObjectReference> referringObjects0(ObjectReference objectReference, long l) {
        try {
            return (List)ObjectReference.class.getMethod("referringObjects", Long.TYPE).invoke((Object)objectReference, l);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new IllegalStateException(securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof InternalException) {
                JDIExceptionReporter.report((InternalException)throwable);
                return Collections.emptyList();
            }
            if (throwable instanceof VMDisconnectedException) {
                return Collections.emptyList();
            }
            throw new IllegalStateException(throwable);
        }
    }

    public static void setValue(ObjectReference objectReference, Field field, Value value) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalArgumentExceptionWrapper {
        try {
            objectReference.setValue(field, value);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentExceptionWrapper(illegalArgumentException);
        }
    }

    public static long uniqueID(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return objectReference.uniqueID();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }

    public static List<ThreadReference> waitingThreads0(ObjectReference objectReference) throws IncompatibleThreadStateException {
        try {
            return objectReference.waitingThreads();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return Collections.emptyList();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return Collections.emptyList();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return Collections.emptyList();
        }
    }

    public static List<ThreadReference> waitingThreads(ObjectReference objectReference) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return objectReference.waitingThreads();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new ObjectCollectedExceptionWrapper(objectCollectedException);
        }
    }
}

