/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException2;
import org.netbeans.modules.debugger.jpda.expr.Evaluator;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.expr.Expression2;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.Operators;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeEvaluator {
    private Expression2 expression;
    private EvaluationContext evaluationContext;
    private StackFrame frame;
    private VirtualMachine vm;
    private ThreadReference frameThread;
    private int frameIndex;
    private String currentPackage;
    private Operators operators;
    private static final Logger loggerMethod = Logger.getLogger("org.netbeans.modules.debugger.jpda.invokeMethod");

    TreeEvaluator(Expression2 expression2, EvaluationContext evaluationContext) {
        this.expression = expression2;
        this.evaluationContext = evaluationContext;
    }

    public Value evaluate() throws EvaluationException2, IncompatibleThreadStateException, InvalidExpressionException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        Object object;
        block22: {
            int n;
            String string;
            Object object2;
            this.frame = this.evaluationContext.getFrame();
            this.vm = MirrorWrapper.virtualMachine(this.evaluationContext.getFrame());
            this.frameThread = StackFrameWrapper.thread(this.frame);
            try {
                this.frameIndex = this.indexOf(ThreadReferenceWrapper.frames(this.frameThread), this.frame);
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                throw new InvalidExpressionException(NbBundle.getMessage(Evaluator.class, (String)"CTL_EvalError_collected"));
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                throw new InvalidExpressionException(illegalThreadStateExceptionWrapper.getCause().getLocalizedMessage());
            }
            if (this.frameIndex == -1) {
                throw new IncompatibleThreadStateException("Thread does not contain current frame");
            }
            this.currentPackage = ReferenceTypeWrapper.name(LocationWrapper.declaringType(StackFrameWrapper.location(this.evaluationContext.getFrame())));
            int n2 = this.currentPackage.lastIndexOf(46);
            this.currentPackage = n2 > 0 ? this.currentPackage.substring(0, n2 + 1) : "";
            this.operators = new Operators(this.vm);
            ObjectReference objectReference = this.evaluationContext.getContextVariable();
            if (objectReference != null) {
                object = objectReference.referenceType().name();
                object2 = SourcePath.convertClassNameToRelativePath((String)object);
                string = this.evaluationContext.getDebugger().getEngineContext().getURL((String)object2, true);
                n = EditorContextBridge.getContext().getFieldLineNumber(string, (String)object, null);
            } else {
                n = LocationWrapper.lineNumber(StackFrameWrapper.location(this.frame));
                string = this.evaluationContext.getDebugger().getEngineContext().getURL(this.frame, "Java");
            }
            object = null;
            object = EditorContextBridge.parseExpression(this.expression.getExpression(), string, n, new EvaluatorVisitor(this.expression), this.evaluationContext, this.evaluationContext.getDebugger().getEngineContext().getContext());
            if (!(object instanceof Value) && object != null) break block22;
            object2 = (Value)object;
            this.evaluationContext.enableCollectionOfObjects(object instanceof Value ? (Value)object : null);
            return object2;
        }
        try {
            try {
                throw new InvalidExpressionException(this.expression.getExpression());
            }
            catch (IllegalStateException illegalStateException) {
                Throwable throwable = illegalStateException.getCause();
                if (throwable instanceof IncompatibleThreadStateException) {
                    throw (IncompatibleThreadStateException)throwable;
                }
                if (throwable instanceof InvalidExpressionException) {
                    throw (InvalidExpressionException)throwable;
                }
                if (throwable instanceof ClassNotLoadedException) {
                    throw new InvalidExpressionException("Class " + ((ClassNotLoadedException)throwable).className() + " not loaded.");
                }
                throw illegalStateException;
            }
            catch (InternalException internalException) {
                if (Exceptions.findLocalizedMessage((Throwable)internalException) != null) {
                    throw new InvalidExpressionException(Exceptions.findLocalizedMessage((Throwable)internalException));
                }
                JDIExceptionReporter.report(internalException);
                throw new InvalidExpressionException(internalException.getLocalizedMessage());
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw new InvalidExpressionException(NbBundle.getMessage(Evaluator.class, (String)"CTL_EvalError_disconnected"));
            }
            catch (ObjectCollectedException objectCollectedException) {
                Exceptions.printStackTrace((Throwable)objectCollectedException);
                throw new InvalidExpressionException(NbBundle.getMessage(Evaluator.class, (String)"CTL_EvalError_collected"));
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw new InvalidExpressionException((Throwable)classNotPreparedException);
            }
            catch (NativeMethodException nativeMethodException) {
                throw new InvalidExpressionException(nativeMethodException.getLocalizedMessage());
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)invalidStackFrameException, (String)("During evaluation of '" + this.expression.getExpression() + "'")));
                throw new InvalidExpressionException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NoCurrentContext"));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new InvalidExpressionException(NbBundle.getMessage(Evaluator.class, (String)"CTL_UnsupportedOperationException"));
            }
        }
        catch (Throwable throwable) {
            this.evaluationContext.enableCollectionOfObjects(object instanceof Value ? (Value)object : null);
            throw throwable;
        }
    }

    private int indexOf(List<StackFrame> list, StackFrame stackFrame) {
        int n = list.size();
        Location location = stackFrame.location();
        for (int i = 0; i < n; ++i) {
            if (!((Object)location).equals(list.get(i).location())) continue;
            return i;
        }
        return -1;
    }

    public static Value invokeVirtual(ObjectReference objectReference, Method method, ThreadReference threadReference, List<Value> list, JPDADebuggerImpl jPDADebuggerImpl) throws InvalidExpressionException {
        try {
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("STARTED : " + objectReference + "." + method + " (" + list + ") in thread " + threadReference);
            }
            Value value = ObjectReferenceWrapper.invokeMethod(objectReference, threadReference, method, list, 1);
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("   return = " + value);
            }
            Value value2 = value;
            return value2;
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
            invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
            throw invalidExpressionException;
        }
        catch (InvocationException invocationException) {
            InvocationExceptionTranslated invocationExceptionTranslated = new InvocationExceptionTranslated(invocationException, jPDADebuggerImpl);
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)((Object)invocationExceptionTranslated));
            invalidExpressionException.initCause((Throwable)((Object)invocationExceptionTranslated));
            throw invalidExpressionException;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)unsupportedOperationException);
            invalidExpressionException.initCause((Throwable)unsupportedOperationException);
            throw invalidExpressionException;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw new InvalidExpressionException(internalExceptionWrapper.getLocalizedMessage());
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_collected"));
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            throw new InvalidExpressionException(NbBundle.getMessage(Evaluator.class, (String)"CTL_EvalError_disconnected"));
        }
        finally {
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("FINISHED: " + objectReference + "." + method + " (" + list + ") in thread " + threadReference);
            }
        }
    }
}

