/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import java.io.StringReader;
import java.util.Random;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.Evaluator;
import org.netbeans.modules.debugger.jpda.expr.JavaParser;
import org.netbeans.modules.debugger.jpda.expr.ParseException;
import org.netbeans.modules.debugger.jpda.expr.SimpleNode;

public class Expression {
    public static final String LANGUAGE_JAVA_1_4 = "1.4.0";
    public static final String LANGUAGE_JAVA_1_5 = "1.5.0";
    private static final String REPLACE_return = "return01234";
    private static final String REPLACE_class = "class01234";
    static final String RETURN_MACRO = "{return}";
    static final String CLASS_MACRO = "{class}";
    private String strExpression;
    private String language;
    private SimpleNode root;
    private String replace_return;
    private String replace_class;

    public Expression(String string, String string2) {
        this.strExpression = string;
        this.language = string2;
    }

    public static Expression parse(String string, String string2) throws ParseException {
        String string3 = REPLACE_return;
        while (string.indexOf(string3) >= 0) {
            string3 = "return" + new Random().nextLong();
        }
        String string4 = REPLACE_class;
        while (string.indexOf(string4) >= 0) {
            string4 = "class" + new Random().nextLong();
        }
        String string5 = Expression.replaceSpecialVar(string, RETURN_MACRO, string3);
        string5 = Expression.replaceSpecialVar(string5, CLASS_MACRO, string4);
        StringReader stringReader = new StringReader(string5);
        try {
            JavaParser javaParser = new JavaParser(stringReader);
            javaParser.setTargetJDK(string2);
            SimpleNode simpleNode = javaParser.Expression();
            Expression expression = new Expression(string, string2, simpleNode, string3, string4);
            return expression;
        }
        catch (Error error) {
            throw new ParseException(error.getMessage());
        }
        finally {
            stringReader.close();
        }
    }

    private static String replaceSpecialVar(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        while (n >= 0) {
            char c;
            boolean bl = n > 0 ? !Character.isJavaIdentifierStart(c = string.charAt(n - 1)) && !Character.isJavaIdentifierPart(c) && c != '.' : true;
            if (bl && n < string.length() - string2.length() && Character.isJavaIdentifierPart(c = string.charAt(n + string2.length()))) {
                bl = false;
            }
            if (bl) {
                string = string.substring(0, n) + string3 + string.substring(n + string2.length());
                n += string3.length();
            } else {
                n += string2.length();
            }
            n = string.indexOf(string2, n);
        }
        return string;
    }

    private Expression(String string, String string2, SimpleNode simpleNode, String string3, String string4) {
        this.strExpression = string;
        this.language = string2;
        this.root = simpleNode;
        this.replace_return = string3;
        this.replace_class = string4;
    }

    public Evaluator evaluator(EvaluationContext evaluationContext) {
        return new Evaluator(this, evaluationContext);
    }

    SimpleNode getRoot() {
        return this.root;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getExpression() {
        return this.strExpression;
    }

    String returnReplaced() {
        return this.replace_return;
    }

    String classReplaced() {
        return this.replace_class;
    }
}

