/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.WatchpointRequest;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ModificationWatchpointEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.WatchpointEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.WatchpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.NbBundle;

public class FieldBreakpointImpl
extends ClassBasedBreakpoint {
    private FieldBreakpoint breakpoint;

    public FieldBreakpointImpl(FieldBreakpoint fieldBreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super((JPDABreakpoint)fieldBreakpoint, jPDADebuggerImpl, session);
        this.breakpoint = fieldBreakpoint;
        this.set();
    }

    protected void setRequests() {
        boolean bl = (this.breakpoint.getBreakpointType() & 1) != 0;
        try {
            boolean bl2;
            if (bl && !VirtualMachineWrapper.canWatchFieldAccess(this.getVirtualMachine())) {
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoFieldAccess"));
                return;
            }
            boolean bl3 = bl2 = (this.breakpoint.getBreakpointType() & 2) != 0;
            if (bl2 && !VirtualMachineWrapper.canWatchFieldModification(this.getVirtualMachine())) {
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoFieldModification"));
                return;
            }
            this.setClassRequests(new String[]{this.breakpoint.getClassName()}, new String[0], 1);
            this.checkLoadedClasses(this.breakpoint.getClassName(), null);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    protected void classLoaded(ReferenceType referenceType) {
        try {
            WatchpointRequest watchpointRequest;
            Field field = ReferenceTypeWrapper.fieldByName(referenceType, this.breakpoint.getFieldName());
            if (field == null) {
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoField", (Object)ReferenceTypeWrapper.name(referenceType), (Object)this.breakpoint.getFieldName()));
                return;
            }
            if ((this.breakpoint.getBreakpointType() & 1) != 0) {
                watchpointRequest = EventRequestManagerWrapper.createAccessWatchpointRequest(this.getEventRequestManager(), field);
                this.setFilters(watchpointRequest);
                this.addEventRequest(watchpointRequest);
            }
            if ((this.breakpoint.getBreakpointType() & 2) != 0) {
                watchpointRequest = EventRequestManagerWrapper.createModificationWatchpointRequest(this.getEventRequestManager(), field);
                this.setFilters(watchpointRequest);
                this.addEventRequest(watchpointRequest);
            }
            this.setValidity(Breakpoint.VALIDITY.VALID, null);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    protected EventRequest createEventRequest(EventRequest eventRequest) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        if (eventRequest instanceof AccessWatchpointRequest) {
            Field field = WatchpointRequestWrapper.field((AccessWatchpointRequest)eventRequest);
            AccessWatchpointRequest accessWatchpointRequest = EventRequestManagerWrapper.createAccessWatchpointRequest(this.getEventRequestManager(), field);
            this.setFilters(accessWatchpointRequest);
            return accessWatchpointRequest;
        }
        if (eventRequest instanceof ModificationWatchpointRequest) {
            Field field = WatchpointRequestWrapper.field((ModificationWatchpointRequest)eventRequest);
            ModificationWatchpointRequest modificationWatchpointRequest = EventRequestManagerWrapper.createModificationWatchpointRequest(this.getEventRequestManager(), field);
            this.setFilters(modificationWatchpointRequest);
            return modificationWatchpointRequest;
        }
        return null;
    }

    private void setFilters(WatchpointRequest watchpointRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        JPDAThread[] jPDAThreadArray;
        JPDAThread[] jPDAThreadArray2 = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
        if (jPDAThreadArray2 != null && jPDAThreadArray2.length > 0) {
            jPDAThreadArray = jPDAThreadArray2;
            int n = jPDAThreadArray.length;
            for (int i = 0; i < n; ++i) {
                JPDAThread jPDAThread = jPDAThreadArray[i];
                WatchpointRequestWrapper.addThreadFilter(watchpointRequest, ((JPDAThreadImpl)jPDAThread).getThreadReference());
            }
        }
        if ((jPDAThreadArray = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
            for (JPDAThread jPDAThread : jPDAThreadArray) {
                WatchpointRequestWrapper.addInstanceFilter(watchpointRequest, (ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
            }
        }
    }

    public boolean processCondition(Event event) {
        ThreadReference threadReference;
        block5: {
            try {
                if (event instanceof ModificationWatchpointEvent) {
                    threadReference = LocatableEventWrapper.thread((ModificationWatchpointEvent)event);
                    break block5;
                }
                if (event instanceof AccessWatchpointEvent) {
                    threadReference = LocatableEventWrapper.thread((AccessWatchpointEvent)event);
                    break block5;
                }
                return true;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return true;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return false;
            }
        }
        return this.processCondition(event, this.breakpoint.getCondition(), threadReference, null);
    }

    public boolean exec(Event event) {
        try {
            if (event instanceof ModificationWatchpointEvent) {
                ModificationWatchpointEvent modificationWatchpointEvent = (ModificationWatchpointEvent)event;
                return this.perform(event, LocatableEventWrapper.thread(modificationWatchpointEvent), LocationWrapper.declaringType(LocatableWrapper.location(modificationWatchpointEvent)), ModificationWatchpointEventWrapper.valueToBe(modificationWatchpointEvent));
            }
            if (event instanceof AccessWatchpointEvent) {
                AccessWatchpointEvent accessWatchpointEvent = (AccessWatchpointEvent)event;
                return this.perform(event, LocatableEventWrapper.thread((WatchpointEvent)event), LocationWrapper.declaringType(LocatableWrapper.location((LocatableEvent)event)), WatchpointEventWrapper.valueCurrent(accessWatchpointEvent));
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        return super.exec(event);
    }
}

