/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassPrepareEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassUnloadEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.ClassPrepareRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.ClassUnloadRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public abstract class ClassBasedBreakpoint
extends BreakpointImpl {
    private String sourceRoot;
    private final Object SOURCE_ROOT_LOCK = new Object();
    private SourceRootsChangedListener srChListener;
    private PropertyChangeListener weakSrChListener;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");

    public ClassBasedBreakpoint(JPDABreakpoint jPDABreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super(jPDABreakpoint, null, jPDADebuggerImpl, session);
    }

    public ClassBasedBreakpoint(JPDABreakpoint jPDABreakpoint, BreakpointsReader breakpointsReader, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super(jPDABreakpoint, breakpointsReader, jPDADebuggerImpl, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSourceRoot(String string) {
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            this.sourceRoot = string;
            if (string != null && this.srChListener == null) {
                this.srChListener = new SourceRootsChangedListener();
                this.weakSrChListener = WeakListeners.propertyChange((PropertyChangeListener)this.srChListener, (Object)this.getDebugger().getEngineContext());
                this.getDebugger().getEngineContext().addPropertyChangeListener(this.weakSrChListener);
            } else if (string == null) {
                this.srChListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getSourceRoot() {
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            return this.sourceRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove() {
        super.remove();
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            if (this.srChListener != null) {
                this.getDebugger().getEngineContext().removePropertyChangeListener(this.weakSrChListener);
                this.srChListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEnabled() {
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            String string = this.getSourceRoot();
            if (string == null) {
                return true;
            }
            String[] stringArray = this.getDebugger().getEngineContext().getSourceRoots();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return true;
            }
            String[] stringArray2 = this.getDebugger().getEngineContext().getProjectSourceRoots();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!string.equals(stringArray2[i])) continue;
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(ClassBasedBreakpoint.class, (String)"MSG_DisabledSourceRoot", (Object)string));
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEnabled(String string, String[] stringArray) {
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            String string2;
            String string3 = this.getSourceRoot();
            if (string3 == null) {
                return true;
            }
            String string4 = this.getDebugger().getEngineContext().getURL(string, true);
            if (string4 == null) {
                ErrorManager.getDefault().log(16, "No URL found for source path " + string);
                return false;
            }
            stringArray[0] = string2 = this.getDebugger().getEngineContext().getSourceRoot(string4);
            return string3.equals(string2);
        }
    }

    protected void setClassRequests(String[] stringArray, String[] stringArray2, int n) {
        this.setClassRequests(stringArray, stringArray2, n, true);
    }

    protected void setClassRequests(String[] stringArray, String[] stringArray2, int n, boolean bl) {
        try {
            int n2;
            int n3;
            EventRequest eventRequest;
            if ((n & 1) != 0) {
                eventRequest = EventRequestManagerWrapper.createClassPrepareRequest(this.getEventRequestManager());
                n3 = stringArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    ClassPrepareRequestWrapper.addClassFilter(eventRequest, stringArray[n2]);
                    logger.fine("Set class load request: " + stringArray[n2]);
                }
                n3 = stringArray2.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    ClassPrepareRequestWrapper.addClassExclusionFilter(eventRequest, stringArray2[n2]);
                    logger.fine("Set class load exclusion request: " + stringArray2[n2]);
                }
                this.addEventRequest(eventRequest, bl);
            }
            if ((n & 2) != 0) {
                eventRequest = EventRequestManagerWrapper.createClassUnloadRequest(this.getEventRequestManager());
                n3 = stringArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    ClassUnloadRequestWrapper.addClassFilter((ClassUnloadRequest)eventRequest, stringArray[n2]);
                    logger.fine("Set class unload request: " + stringArray[n2]);
                }
                n3 = stringArray2.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    ClassUnloadRequestWrapper.addClassExclusionFilter((ClassUnloadRequest)eventRequest, stringArray2[n2]);
                    logger.fine("Set class unload exclusion request: " + stringArray2[n2]);
                }
                this.addEventRequest(eventRequest, false);
            }
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
    }

    protected boolean checkLoadedClasses(String string, String[] stringArray) {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        boolean bl = string.startsWith("*") || string.endsWith("*");
        logger.fine("Check loaded classes: " + string + ", will load all classes: " + bl);
        boolean bl2 = false;
        Iterator<ReferenceType> iterator = null;
        iterator = bl ? VirtualMachineWrapper.allClasses0(virtualMachine).iterator() : VirtualMachineWrapper.classesByName0(virtualMachine, string).iterator();
        while (iterator.hasNext()) {
            ReferenceType referenceType = iterator.next();
            if (iterator == null) continue;
            try {
                String string2 = ReferenceTypeWrapper.name(referenceType);
                if (!ClassBasedBreakpoint.match(string2, string)) continue;
                boolean bl3 = false;
                if (stringArray != null) {
                    for (String string3 : stringArray) {
                        if (!ClassBasedBreakpoint.match(string2, string3)) continue;
                        bl3 = true;
                        break;
                    }
                }
                if (bl3) continue;
                logger.fine(" Class loaded: " + referenceType);
                this.classLoaded(referenceType);
                bl2 = true;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {}
        }
        return bl2;
    }

    public boolean exec(Event event) {
        try {
            if (event instanceof ClassPrepareEvent) {
                logger.fine(" Class loaded: " + ClassPrepareEventWrapper.referenceType((ClassPrepareEvent)event));
                this.classLoaded(ClassPrepareEventWrapper.referenceType((ClassPrepareEvent)event));
            } else if (event instanceof ClassUnloadEvent) {
                logger.fine(" Class unloaded: " + ClassUnloadEventWrapper.className((ClassUnloadEvent)event));
                this.classUnloaded(ClassUnloadEventWrapper.className((ClassUnloadEvent)event));
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        return true;
    }

    public void removed(EventRequest eventRequest) {
    }

    protected void classLoaded(ReferenceType referenceType) {
    }

    protected void classUnloaded(String string) {
    }

    private class SourceRootsChangedListener
    implements PropertyChangeListener {
        private SourceRootsChangedListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("sourceRoots".equals(propertyChangeEvent.getPropertyName())) {
                ClassBasedBreakpoint.this.update();
            }
        }
    }
}

