/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.BreakpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RunIntoMethodActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener,
ActionsManagerListener {
    private JPDADebuggerImpl debugger;
    private ActionsManager lastActionsManager;

    public RunIntoMethodActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
        this.debugger.addPropertyChangeListener("state", this);
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        EditorContextBridge.getContext().removePropertyChangeListener((PropertyChangeListener)this);
    }

    static ActionsManager getCurrentActionsManager() {
        return DebuggerManager.getDebuggerManager().getCurrentEngine() == null ? DebuggerManager.getDebuggerManager().getActionsManager() : DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
    }

    private ActionsManager getActionsManager() {
        ActionsManager actionsManager = RunIntoMethodActionProvider.getCurrentActionsManager();
        if (actionsManager != this.lastActionsManager) {
            if (this.lastActionsManager != null) {
                this.lastActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            actionsManager.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            this.lastActionsManager = actionsManager;
        }
        return actionsManager;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, this.getActionsManager().isEnabled(ActionsManager.ACTION_CONTINUE) && this.debugger.getState() == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && EditorContextBridge.getContext().getCurrentURL().endsWith(".java"));
        if (this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_INTO_METHOD);
    }

    public void doAction(Object object) {
        List<ReferenceType> list;
        final String[] stringArray = new String[1];
        final String[] stringArray2 = new String[1];
        final int[] nArray = new int[1];
        final int[] nArray2 = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    EditorContext editorContext = EditorContextBridge.getContext();
                    stringArray[0] = editorContext.getSelectedMethodName();
                    nArray[0] = editorContext.getCurrentLineNumber();
                    nArray2[0] = EditorContextBridge.getCurrentOffset();
                    stringArray2[0] = editorContext.getCurrentURL();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
            return;
        }
        catch (InterruptedException interruptedException) {
            ErrorManager.getDefault().notify((Throwable)interruptedException);
            return;
        }
        final String string = stringArray[0];
        if (string.length() < 1) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(RunIntoMethodActionProvider.class, (String)"MSG_Put_cursor_on_some_method_call"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        final int n = nArray[0];
        final int n2 = nArray2[0];
        final String string2 = stringArray2[0];
        String string3 = this.debugger.getCurrentThread().getClassName();
        VirtualMachine virtualMachine = this.debugger.getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        try {
            list = VirtualMachineWrapper.classesByName(virtualMachine, string3);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return;
        }
        if (!list.isEmpty()) {
            this.doAction(string2, list.get(0), n, n2, string);
        } else {
            final ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = ClassLoadUnloadBreakpoint.create((String)string3, (boolean)false, (int)1);
            classLoadUnloadBreakpoint.setHidden(true);
            classLoadUnloadBreakpoint.setSuspend(0);
            classLoadUnloadBreakpoint.addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent jPDABreakpointEvent) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)classLoadUnloadBreakpoint);
                    RunIntoMethodActionProvider.this.doAction(string2, jPDABreakpointEvent.getReferenceType(), n, n2, string);
                }
            });
            try {
                Method method = JPDABreakpoint.class.getDeclaredMethod("setSession", JPDADebugger.class);
                method.setAccessible(true);
                method.invoke((Object)classLoadUnloadBreakpoint, new Object[]{this.debugger});
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)classLoadUnloadBreakpoint);
            RunIntoMethodActionProvider.resume(this.debugger);
        }
    }

    private static void resume(JPDADebugger jPDADebugger) {
        if (jPDADebugger.getSuspend() == 1) {
            jPDADebugger.getCurrentThread().resume();
        } else {
            Session session = ((JPDADebuggerImpl)jPDADebugger).getSession();
            session.getEngineForLanguage("Java").getActionsManager().doAction(ActionsManager.ACTION_CONTINUE);
        }
    }

    private void doAction(String string, ReferenceType referenceType, int n, int n2, String string2) {
        Object object;
        List<Object> list = Collections.emptyList();
        try {
            while (n > 0 && (list = ReferenceTypeWrapper.locationsOfLine(referenceType, n)).isEmpty()) {
                --n;
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return;
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
        }
        catch (AbsentInformationException absentInformationException) {
            ErrorManager.getDefault().notify(1, (Throwable)absentInformationException);
        }
        Logger.getLogger(RunIntoMethodActionProvider.class.getName()).fine("doAction(" + string + ", " + referenceType + ", " + n + ", " + string2 + ") locations = " + list);
        if (list.isEmpty()) {
            object = NbBundle.getMessage(RunIntoMethodActionProvider.class, (String)"MSG_RunIntoMeth_absentInfo", (Object)referenceType.name());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message(object);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        object = this.debugger.getExpressionPool().getExpressionAt((Location)list.get(0), string);
        Location location = null;
        if (object != null) {
            EditorContext.Operation[] operationArray = ((ExpressionPool.Expression)object).getOperations();
            for (int i = 0; i < operationArray.length; ++i) {
                EditorContext.Operation operation = operationArray[i];
                if (operation.getMethodStartPosition().getOffset() > n2 || n2 > operation.getMethodEndPosition().getOffset()) continue;
                location = ((ExpressionPool.Expression)object).getLocations()[i];
                break;
            }
        }
        if (location == null) {
            location = (Location)list.get(0);
        }
        RunIntoMethodActionProvider.doAction(this.debugger, string2, location, false);
    }

    static boolean doAction(final JPDADebuggerImpl jPDADebuggerImpl, final String string, Location location, boolean bl) {
        JPDAThreadImpl jPDAThreadImpl;
        boolean bl2;
        final VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        final int n = LocationWrapper.lineNumber0(location, "Java");
        CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)jPDADebuggerImpl.getCurrentCallStackFrame();
        if (callStackFrameImpl == null) {
            return false;
        }
        try {
            bl2 = LocationWrapper.equals(StackFrameWrapper.location(callStackFrameImpl.getStackFrame()), location);
            jPDAThreadImpl = (JPDAThreadImpl)callStackFrameImpl.getThread();
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        final boolean bl3 = bl;
        if (bl2) {
            RunIntoMethodActionProvider.traceLineForMethod(jPDADebuggerImpl, string, n, bl3);
        } else {
            final JPDAStep[] jPDAStepArray = new JPDAStep[]{null};
            try {
                final BreakpointRequest breakpointRequest = EventRequestManagerWrapper.createBreakpointRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), location);
                Executor executor = new Executor(){

                    public boolean exec(Event event) {
                        Logger.getLogger(RunIntoMethodActionProvider.class.getName()).fine("Calling location reached, tracing for " + string + "()");
                        if (jPDAStepArray[0] != null) {
                            ((JPDAStepImpl)jPDAStepArray[0]).cancel();
                        }
                        try {
                            EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), breakpointRequest);
                            jPDADebuggerImpl.getOperator().unregister(breakpointRequest);
                        }
                        catch (InternalExceptionWrapper internalExceptionWrapper) {
                        }
                        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                            return false;
                        }
                        RunIntoMethodActionProvider.traceLineForMethod(jPDADebuggerImpl, string, n, bl3);
                        return true;
                    }

                    public void removed(EventRequest eventRequest) {
                    }
                };
                jPDADebuggerImpl.getOperator().register(breakpointRequest, executor);
                BreakpointRequestWrapper.addThreadFilter(breakpointRequest, jPDAThreadImpl.getThreadReference());
                EventRequestWrapper.setSuspendPolicy(breakpointRequest, jPDADebuggerImpl.getSuspend());
                EventRequestWrapper.addCountFilter(breakpointRequest, 1);
                EventRequestWrapper.enable(breakpointRequest);
                if (bl) {
                    jPDAStepArray[0] = RunIntoMethodActionProvider.setBoundaryStepRequest(jPDADebuggerImpl, jPDAThreadImpl, breakpointRequest);
                }
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return false;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return false;
            }
        }
        RunIntoMethodActionProvider.resume(jPDADebuggerImpl);
        return true;
    }

    private static JPDAStep setBoundaryStepRequest(final JPDADebuggerImpl jPDADebuggerImpl, JPDAThread jPDAThread, final EventRequest eventRequest) {
        JPDAStep jPDAStep = jPDADebuggerImpl.createJPDAStep(-2, 2);
        jPDAStep.addPropertyChangeListener("exec", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
                if (virtualMachine != null) {
                    try {
                        jPDADebuggerImpl.getOperator().unregister(eventRequest);
                        EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), eventRequest);
                    }
                    catch (InternalExceptionWrapper internalExceptionWrapper) {
                    }
                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                        // empty catch block
                    }
                }
            }
        });
        jPDAStep.addStep(jPDAThread);
        return jPDAStep;
    }

    private static void traceLineForMethod(final JPDADebuggerImpl jPDADebuggerImpl, final String string, final int n, final boolean bl) {
        final int n2 = jPDADebuggerImpl.getCurrentThread().getStackDepth();
        final JPDAStep jPDAStep = jPDADebuggerImpl.createJPDAStep(-2, 1);
        jPDAStep.setHidden(true);
        jPDAStep.addPropertyChangeListener("exec", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                block12: {
                    if (Logger.getLogger(RunIntoMethodActionProvider.class.getName()).isLoggable(Level.FINE)) {
                        Logger.getLogger(RunIntoMethodActionProvider.class.getName()).fine("traceLineForMethod(" + string + ") step is at " + jPDADebuggerImpl.getCurrentThread().getClassName() + ":" + jPDADebuggerImpl.getCurrentThread().getMethodName());
                    }
                    JPDAThread jPDAThread = jPDADebuggerImpl.getCurrentThread();
                    int n3 = jPDAThread.getStackDepth();
                    Logger.getLogger(RunIntoMethodActionProvider.class.getName()).fine("  depth = " + n3 + ", target = " + n2);
                    if (n3 == n2) {
                        try {
                            if (jPDAThread.getCallStack()[0].getLineNumber("Java") != n) {
                                jPDAStep.setHidden(false);
                                break block12;
                            }
                            Logger.getLogger(RunIntoMethodActionProvider.class.getName()).fine("  back on the method invoaction line, setting additional step into.");
                            jPDAStep.setDepth(1);
                            jPDAStep.addStep(jPDADebuggerImpl.getCurrentThread());
                        }
                        catch (AbsentInformationException absentInformationException) {
                            ErrorManager.getDefault().notify(1, (Throwable)absentInformationException);
                            jPDAStep.setHidden(false);
                        }
                    } else if (jPDAThread.getMethodName().equals(string)) {
                        jPDAStep.setHidden(false);
                    } else if (jPDAThread.getMethodName().equals("<init>") && (jPDAThread.getClassName().endsWith("." + string) || jPDAThread.getClassName().equals(string))) {
                        jPDAStep.setHidden(false);
                    } else if (bl) {
                        jPDAStep.setHidden(false);
                    } else {
                        jPDAStep.setDepth(3);
                        jPDAStep.addStep(jPDADebuggerImpl.getCurrentThread());
                    }
                }
            }
        });
        jPDAStep.addStep(jPDADebuggerImpl.getCurrentThread());
    }

    public void actionPerformed(Object object) {
    }

    public void actionStateChanged(Object object, boolean bl) {
        if (ActionsManager.ACTION_CONTINUE == object) {
            this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, bl && this.debugger.getState() == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && EditorContextBridge.getContext().getCurrentURL().endsWith(".java"));
        }
    }
}

