/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class CheckDeadlocksAction
extends AbstractAction
implements Runnable {
    private EnableListener listener = new EnableListener(this);

    public CheckDeadlocksAction() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this.listener);
        this.putValue("Name", CheckDeadlocksAction.getDisplayName());
        this.checkEnabled();
    }

    public static String getDisplayName() {
        return NbBundle.getMessage(CheckDeadlocksAction.class, (String)"CTL_CheckDeadlocks");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return;
        }
        final JPDADebuggerImpl jPDADebuggerImpl = (JPDADebuggerImpl)((Object)debuggerEngine.lookupFirst(null, JPDADebugger.class));
        if (jPDADebuggerImpl == null) {
            return;
        }
        jPDADebuggerImpl.getRequestProcessor().post(new Runnable(){

            public void run() {
                CheckDeadlocksAction.checkForDeadlock(jPDADebuggerImpl);
            }
        });
    }

    public static void checkForDeadlock(JPDADebuggerImpl jPDADebuggerImpl) {
        if (jPDADebuggerImpl.getState() == 4) {
            return;
        }
        VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        try {
            Object objectCollectedExceptionWrapper;
            VirtualMachineWrapper.suspend(virtualMachine);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (ThreadReference object22 : VirtualMachineWrapper.allThreads(virtualMachine)) {
                try {
                    if (ThreadReferenceWrapper.suspendCount(object22) != 1) continue;
                    objectCollectedExceptionWrapper = jPDADebuggerImpl.getThread(object22);
                    ((JPDAThreadImpl)objectCollectedExceptionWrapper).notifySuspended();
                    arrayList.add(objectCollectedExceptionWrapper);
                }
                catch (ObjectCollectedExceptionWrapper illegalThreadStateExceptionWrapper) {
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {}
            }
            DeadlockDetector deadlockDetector = jPDADebuggerImpl.getThreadsCollector().getDeadlockDetector();
            Set set = deadlockDetector.getDeadlocks();
            if (set == null || set.size() == 0) {
                objectCollectedExceptionWrapper = NbBundle.getMessage(CheckDeadlocksAction.class, (String)"CTL_No_Deadlock");
                NotifyDescriptor.Message message = new NotifyDescriptor.Message(objectCollectedExceptionWrapper, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                for (JPDAThreadImpl jPDAThreadImpl : arrayList) {
                    jPDAThreadImpl.notifyToBeResumed();
                }
                VirtualMachineWrapper.resume(virtualMachine);
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    private synchronized boolean canBeEnabled() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return false;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        return jPDADebugger != null;
    }

    private void checkEnabled() {
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        this.setEnabled(this.canBeEnabled());
    }

    protected void finalize() throws Throwable {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this.listener);
    }

    private static class EnableListener
    extends DebuggerManagerAdapter {
        private Reference actionRef;

        public EnableListener(CheckDeadlocksAction checkDeadlocksAction) {
            this.actionRef = new WeakReference<CheckDeadlocksAction>(checkDeadlocksAction);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CheckDeadlocksAction checkDeadlocksAction = (CheckDeadlocksAction)this.actionRef.get();
            if (checkDeadlocksAction != null) {
                checkDeadlocksAction.checkEnabled();
            }
        }
    }
}

