/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorNumber;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorGaugeMaxValue
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final String INDEFINITE_TEXT = NbBundle.getMessage(PropertyEditorGaugeMaxValue.class, (String)"LBL_MAX_VALUE_INDEFINITE_TXT");
    private static final String INDEFINITE_NUM_TEXT = String.valueOf(-1);
    private CustomEditor customEditor;
    private JRadioButton radioButton;

    private PropertyEditorGaugeMaxValue() {
        super(NbBundle.getMessage(PropertyEditorGaugeMaxValue.class, (String)"LBL_GAUGE_MAX_VALUE_UCLABEL"));
    }

    public static final PropertyEditorGaugeMaxValue createInstance() {
        return new PropertyEditorGaugeMaxValue();
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorGaugeMaxValue.class, (String)"LBL_GAUGE_MAX_VALUE_STR"));
        this.customEditor = new CustomEditor();
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        if (propertyValue == null) {
            return INDEFINITE_TEXT;
        }
        int n = MidpTypes.getInteger(propertyValue);
        if (n == -1) {
            return INDEFINITE_TEXT;
        }
        return String.valueOf(n);
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue propertyValue) {
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.unsetForever(true);
        } else if (MidpTypes.getInteger(propertyValue) == -1) {
            this.customEditor.setForever(true);
        } else {
            this.customEditor.unsetForever(true);
            this.customEditor.setText(String.valueOf(propertyValue.getPrimitiveValue()));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String string) {
        if (string.length() <= 0) {
            return;
        }
        if (INDEFINITE_TEXT.equals(string) || INDEFINITE_NUM_TEXT.equals(string)) {
            if (this.component != null && this.component.get() != null) {
                final DesignComponent designComponent = (DesignComponent)this.component.get();
                designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        designComponent.writeProperty("value", MidpTypes.createIntegerValue(0));
                    }
                });
            }
            super.setValue((Object)MidpTypes.createIntegerValue(-1));
        } else {
            int n = 0;
            try {
                string = string.replaceAll("[^0-9\\-]+", "");
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            super.setValue((Object)MidpTypes.createIntegerValue(n));
        }
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    public Boolean canEditAsText() {
        if (!this.isCurrentValueAUserCodeType()) {
            PropertyValue propertyValue = (PropertyValue)super.getValue();
            if (propertyValue == null) {
                return false;
            }
            int n = MidpTypes.getInteger(propertyValue);
            return n != -1;
        }
        return false;
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener,
    DocumentListener,
    FocusListener {
        private JTextField textField;
        private JCheckBox foreverCheckBox;

        public CustomEditor() {
            PropertyEditorGaugeMaxValue.this.radioButton.addFocusListener(this);
            this.initComponents();
        }

        void cleanUp() {
            PropertyEditorGaugeMaxValue.this.radioButton.removeActionListener(this);
            this.textField = null;
            this.foreverCheckBox = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.textField = new JTextField();
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(this);
            this.textField.setPreferredSize(new Dimension(100, this.textField.getPreferredSize().height));
            this.add((Component)this.textField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.foreverCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.foreverCheckBox, (String)NbBundle.getMessage(PropertyEditorGaugeMaxValue.class, (String)"LBL_MAX_VALUE_INDEFINITE"));
            this.foreverCheckBox.addActionListener(this);
            this.foreverCheckBox.addFocusListener(this);
            this.add((Component)this.foreverCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void setText(String string) {
            this.textField.setText(string);
        }

        public String getText() {
            return this.textField.getText();
        }

        public void setForever(boolean bl) {
            this.setText(INDEFINITE_NUM_TEXT);
            this.textField.setEditable(false);
            if (bl) {
                this.foreverCheckBox.setSelected(true);
            }
        }

        public void unsetForever(boolean bl) {
            this.setText(null);
            this.textField.setEditable(true);
            if (bl) {
                this.foreverCheckBox.setSelected(false);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.foreverCheckBox.isSelected()) {
                this.setForever(false);
            } else {
                this.unsetForever(false);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorGaugeMaxValue.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorGaugeMaxValue.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void checkNumberStatus() {
            if (!Pattern.matches("[\\d\\-]+", this.textField.getText())) {
                PropertyEditorGaugeMaxValue.this.displayWarning(PropertyEditorNumber.NON_DIGITS_TEXT);
            } else {
                PropertyEditorGaugeMaxValue.this.clearErrorStatus();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == PropertyEditorGaugeMaxValue.this.radioButton || focusEvent.getSource() == this.textField || focusEvent.getSource() == this.foreverCheckBox) {
                this.checkNumberStatus();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            PropertyEditorGaugeMaxValue.this.clearErrorStatus();
        }
    }
}

