/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.sun.api.ExtendedClassLoader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public class ServerLocationManager {
    public static final int SJSAS_90 = 900;
    public static final int SJSAS_91 = 910;
    public static final int SJSAS_82 = 820;
    public static final int GF_V1 = 900;
    public static final int GF_V2 = 910;
    public static final int GF_V2point1 = 911;
    public static final String INSTALL_ROOT_PROP_NAME = "com.sun.aas.installRoot";
    private static final String JAR_BRIGDES_DEFINITION_LAYER = "/J2EE/SunAppServer/Bridge";
    private static Map serverLocationAndClassLoaderMap = Collections.synchronizedMap(new HashMap(2, 1.0f));
    private static Collection fileColl = new ArrayList();

    private static void updatePluginLoader(File file, ExtendedClassLoader extendedClassLoader) throws Exception {
        try {
            File file2 = file;
            if (null == file2 || !file2.exists()) {
                return;
            }
            String string = file2.getAbsolutePath();
            if (!ServerLocationManager.isGlassFish(file2)) {
                System.setProperty(INSTALL_ROOT_PROP_NAME, string);
            }
            FileObject fileObject = FileUtil.getConfigFile((String)JAR_BRIGDES_DEFINITION_LAYER);
            FileObject[] fileObjectArray = new FileObject[]{};
            if (fileObject != null) {
                fileObjectArray = fileObject.getChildren();
            }
            for (int i = 0; i < fileObjectArray.length; ++i) {
                String string2 = (String)fileObjectArray[i].getAttribute("jar.location");
                InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
                file2 = installedFileLocator.locate(string2, null, true);
                if (file2 != null) {
                    extendedClassLoader.addURL(file2);
                    ServerLocationManager.loadLocaleSpecificJars(file2, extendedClassLoader);
                    continue;
                }
                System.out.println("cannot locate file " + string2);
            }
            file2 = new File(string + "/lib/appserv-admin.jar");
            extendedClassLoader.addURL(file2);
            file2 = new File(string + "/lib/appserv-ext.jar");
            extendedClassLoader.addURL(file2);
            file2 = new File(string + "/lib/appserv-rt.jar");
            extendedClassLoader.addURL(file2);
            file2 = new File(string + "/lib/appserv-cmp.jar");
            extendedClassLoader.addURL(file2);
            file2 = new File(string + "/lib/commons-logging.jar");
            extendedClassLoader.addURL(file2);
            file2 = new File(string + "/lib/admin-cli.jar");
            extendedClassLoader.addURL(file2);
            file2 = new File(string + "/lib/common-laucher.jar");
            extendedClassLoader.addURL(file2);
            file2 = new File(string + "/lib/j2ee.jar");
            extendedClassLoader.addURL(file2);
            file2 = new File(string + "/lib/install/applications/jmsra/imqjmsra.jar");
            extendedClassLoader.addURL(file2);
            file2 = new File(string + "/lib/jaxrpc-api.jar");
            extendedClassLoader.addURL(file2);
            file2 = new File(string + "/lib/jaxrpc-impl.jar");
            extendedClassLoader.addURL(file2);
        }
        catch (Exception exception) {
            throw new Exception(exception.getLocalizedMessage());
        }
    }

    public static File getLatestPlatformLocation() {
        Iterator iterator = serverLocationAndClassLoaderMap.entrySet().iterator();
        File file = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            File file2 = new File(string);
            if (file == null) {
                file = file2;
            }
            if (!ServerLocationManager.isGlassFish(file2)) continue;
            file = file2;
        }
        return file;
    }

    public static ClassLoader getServerOnlyClassLoader(File file) {
        CacheData cacheData = (CacheData)serverLocationAndClassLoaderMap.get(file.getAbsolutePath());
        if (cacheData == null) {
            ServerLocationManager.getNetBeansAndServerClassLoader(file);
            cacheData = (CacheData)serverLocationAndClassLoaderMap.get(file.getAbsolutePath());
            if (cacheData == null) {
                return null;
            }
        }
        return cacheData.serverOnlyClassLoader;
    }

    public static synchronized DeploymentFactory getDeploymentFactory(File file) {
        CacheData cacheData = (CacheData)serverLocationAndClassLoaderMap.get(file.getAbsolutePath());
        if (cacheData == null) {
            ServerLocationManager.getNetBeansAndServerClassLoader(file);
            cacheData = (CacheData)serverLocationAndClassLoaderMap.get(file.getAbsolutePath());
            if (cacheData == null) {
                return null;
            }
        }
        return cacheData.deploymentFactory;
    }

    public static synchronized ClassLoader getNetBeansAndServerClassLoader(File file) {
        CacheData cacheData = (CacheData)serverLocationAndClassLoaderMap.get(file.getAbsolutePath());
        if (cacheData == null) {
            if (!ServerLocationManager.isGoodAppServerLocation(file)) {
                return null;
            }
            cacheData = new CacheData();
            serverLocationAndClassLoaderMap.put(file.getAbsolutePath(), cacheData);
        }
        if (cacheData.cachedClassLoader == null) {
            if (!ServerLocationManager.isGoodAppServerLocation(file)) {
                return null;
            }
            try {
                cacheData.cachedClassLoader = new ExtendedClassLoader(new Empty().getClass().getClassLoader());
                ServerLocationManager.updatePluginLoader(file, cacheData.cachedClassLoader);
                cacheData.deploymentFactory = (DeploymentFactory)cacheData.cachedClassLoader.loadClass("com.sun.enterprise.deployapi.SunDeploymentFactory").newInstance();
                cacheData.serverOnlyClassLoader = new ExtendedClassLoader();
                ServerLocationManager.updatePluginLoader(file, cacheData.serverOnlyClassLoader);
            }
            catch (Exception exception) {
                Logger.getLogger(ServerLocationManager.class.getName()).log(Level.FINER, null, exception);
            }
        }
        return cacheData.cachedClassLoader;
    }

    public static boolean isGlassFish(File file) {
        File file2 = new File(file.getAbsolutePath() + "/lib/dtds/sun-web-app_2_5-0.dtd");
        return file2.exists();
    }

    public static boolean isJavaDBPresent(File file) {
        File file2 = new File(file, "derby");
        if (!file2.exists()) {
            file2 = new File(file, "javadb");
        }
        return file2.exists();
    }

    public static boolean isGoodAppServerLocation(File file) {
        if (!(null != file && file.exists() && file.canRead() && file.isDirectory() && ServerLocationManager.hasRequiredChildren(file, fileColl))) {
            return false;
        }
        File file2 = new File(file.getAbsolutePath() + "/lib/appserv-rt.jar");
        if (!file2.exists()) {
            return false;
        }
        if (ServerLocationManager.isGlassFish(file)) {
            return true;
        }
        return true;
    }

    private static void loadLocaleSpecificJars(File file, ExtendedClassLoader extendedClassLoader) {
        File file2 = file.getParentFile();
        File file3 = new File(file2, "locale");
        if (file3.exists()) {
            File[] fileArray = file3.listFiles();
            String string = file.getName();
            string = ServerLocationManager.getFileNameWithoutExt(string);
            assert (string.length() > 0);
            for (int i = 0; i < fileArray.length; ++i) {
                File file4 = fileArray[i];
                String string2 = file4.getName();
                assert (string2.length() > 0);
                if (!string2.startsWith(string)) continue;
                try {
                    extendedClassLoader.addURL(file4);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception.getLocalizedMessage());
                }
            }
        }
    }

    private static String getFileNameWithoutExt(String string) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static boolean hasRequiredChildren(File file, Collection collection) {
        if (null == file) {
            return false;
        }
        String[] stringArray = file.list();
        if (null == stringArray) {
            return false;
        }
        if (null == collection) {
            return true;
        }
        List<String> list = Arrays.asList(stringArray);
        return list.containsAll(collection);
    }

    public static int getAppServerPlatformVersion(File file) {
        int n = 0;
        if (file != null && file.exists()) {
            File file2 = new File(file, "lib/dtds/sun-domain_1_1.dtd");
            File file3 = new File(file + "/lib/dtds/sun-domain_1_2.dtd");
            File file4 = new File(file + "/lib/dtds/sun-domain_1_3.dtd");
            File file5 = new File(file + "/lib/dtds/sun-ejb-jar_3_0-1.dtd");
            if (file5.exists()) {
                n = 911;
            } else if (file4.exists()) {
                n = 910;
            } else if (file3.exists()) {
                n = 900;
            } else if (file2.exists()) {
                n = 820;
            }
        }
        return n;
    }

    public static boolean hasUpdateCenter(File file) {
        return ServerLocationManager.getUpdateCenterLauncher(file) != null;
    }

    public static File getUpdateCenterLauncher(File file) {
        File file2;
        File file3 = null;
        if (file != null && file.exists() && (file2 = new File(file, "updatecenter/bin")).exists()) {
            File file4;
            String string = "updatetool";
            if (Utilities.isWindows()) {
                string = string + ".BAT";
            }
            file3 = (file4 = new File(file2, string)).exists() ? file4 : null;
        }
        return file3;
    }

    static {
        fileColl.add("bin");
        fileColl.add("lib");
        fileColl.add("config");
    }

    static class CacheData {
        public ExtendedClassLoader cachedClassLoader;
        public ExtendedClassLoader serverOnlyClassLoader;
        public DeploymentFactory deploymentFactory;
    }

    static class Empty {
        Empty() {
        }
    }
}

