/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.api.metadata.DBConnMetadataModelManager;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.sql.analyzer.FromClause;
import org.netbeans.modules.db.sql.analyzer.InsertStatement;
import org.netbeans.modules.db.sql.analyzer.InsertStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.analyzer.SelectStatement;
import org.netbeans.modules.db.sql.analyzer.SelectStatementAnalyzer;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionResultSet;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionEnv;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionItems;
import org.netbeans.modules.db.sql.editor.completion.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLCompletionQuery
extends AsyncCompletionQuery {
    private static final Logger LOGGER = Logger.getLogger(SQLCompletionQuery.class.getName());
    private final DatabaseConnection dbconn;
    private Metadata metadata;
    private SQLCompletionEnv env;
    private SQLIdentifiers.Quoter quoter;
    private SQLStatement statement;
    private FromClause fromClause;
    private int anchorOffset = -1;
    private int substitutionOffset = 0;
    private SQLCompletionItems items;

    public SQLCompletionQuery(DatabaseConnection databaseConnection) {
        this.dbconn = databaseConnection;
    }

    protected void query(CompletionResultSet completionResultSet, Document document, int n) {
        this.doQuery(SQLCompletionEnv.forDocument(document, n));
        if (this.items != null) {
            this.items.fill(completionResultSet);
        }
        if (this.anchorOffset != -1) {
            completionResultSet.setAnchorOffset(this.env.getStatementOffset() + this.anchorOffset);
        }
        completionResultSet.finish();
    }

    public void query(SQLCompletionResultSet sQLCompletionResultSet, SQLCompletionEnv sQLCompletionEnv) {
        this.doQuery(sQLCompletionEnv);
        if (this.items != null) {
            this.items.fill(sQLCompletionResultSet);
        }
        if (this.anchorOffset != -1) {
            sQLCompletionResultSet.setAnchorOffset(sQLCompletionEnv.getStatementOffset() + this.anchorOffset);
        }
    }

    private void doQuery(final SQLCompletionEnv sQLCompletionEnv) {
        try {
            DBConnMetadataModelManager.get((DatabaseConnection)this.dbconn).runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Connection connection = SQLCompletionQuery.this.dbconn.getJDBCConnection();
                    if (connection == null) {
                        return;
                    }
                    SQLIdentifiers.Quoter quoter = null;
                    try {
                        DatabaseMetaData databaseMetaData = connection.getMetaData();
                        quoter = SQLIdentifiers.createQuoter((DatabaseMetaData)databaseMetaData);
                    }
                    catch (SQLException sQLException) {
                        throw new RuntimeException(sQLException);
                    }
                    SQLCompletionQuery.this.doQuery(sQLCompletionEnv, metadata, quoter);
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            SQLCompletionQuery.reportError(metadataModelException);
        }
    }

    SQLCompletionItems doQuery(SQLCompletionEnv sQLCompletionEnv, Metadata metadata, SQLIdentifiers.Quoter quoter) {
        this.env = sQLCompletionEnv;
        this.metadata = metadata;
        this.quoter = quoter;
        this.anchorOffset = -1;
        this.substitutionOffset = 0;
        if (sQLCompletionEnv == null) {
            return null;
        }
        this.items = new SQLCompletionItems(quoter, sQLCompletionEnv.getSubstitutionHandler());
        SQLStatementKind sQLStatementKind = SQLStatementAnalyzer.analyzeKind(sQLCompletionEnv.getTokenSequence());
        if (sQLStatementKind == null) {
            return this.items;
        }
        switch (sQLStatementKind) {
            case SELECT: {
                this.statement = SelectStatementAnalyzer.analyze(sQLCompletionEnv.getTokenSequence(), quoter);
                if (this.statement == null) break;
                assert (this.statement.getKind() == SQLStatementKind.SELECT) : this.statement.getKind();
                this.completeSelect();
                break;
            }
            case INSERT: {
                this.statement = InsertStatementAnalyzer.analyze(sQLCompletionEnv.getTokenSequence(), quoter);
                if (this.statement == null) break;
                assert (this.statement.getKind() == SQLStatementKind.INSERT) : this.statement.getKind();
                this.completeInsert();
            }
        }
        return this.items;
    }

    private void completeSelect() {
        SelectStatement selectStatement = (SelectStatement)this.statement;
        SelectStatement.SelectContext selectContext = selectStatement.getContextAtOffset(this.env.getCaretOffset());
        if (selectContext == null) {
            return;
        }
        this.fromClause = selectStatement.getTablesInEffect(this.env.getCaretOffset());
        Identifier identifier = this.findIdentifier();
        if (identifier == null) {
            return;
        }
        this.anchorOffset = identifier.anchorOffset;
        this.substitutionOffset = identifier.substitutionOffset;
        switch (selectContext) {
            case SELECT: {
                this.insideSelect(identifier);
                break;
            }
            case FROM: {
                this.insideFrom(identifier);
                break;
            }
            case JOIN_CONDITION: {
                this.insideClauseAfterFrom(identifier);
                break;
            }
            default: {
                if (this.fromClause == null) break;
                this.insideClauseAfterFrom(identifier);
            }
        }
    }

    private void completeInsert() {
        InsertStatement insertStatement = (InsertStatement)this.statement;
        InsertStatement.InsertContext insertContext = insertStatement.getContextAtOffset(this.env.getCaretOffset());
        if (insertContext == null) {
            return;
        }
        Identifier identifier = this.findIdentifier();
        if (identifier == null) {
            return;
        }
        this.anchorOffset = identifier.anchorOffset;
        this.substitutionOffset = identifier.substitutionOffset;
        switch (insertContext) {
            case INSERT: {
                break;
            }
            case INTO: {
                this.insideFrom(identifier);
                break;
            }
            case COLUMNS: {
                this.insideColumns(identifier, insertStatement.getTable());
                break;
            }
        }
    }

    private void insideSelect(Identifier identifier) {
        if (identifier.fullyTypedIdent.isEmpty()) {
            this.completeSelectSimpleIdent(identifier.lastPrefix, identifier.quoted);
        } else {
            this.completeSelectQualIdent(identifier.fullyTypedIdent, identifier.lastPrefix, identifier.quoted);
        }
    }

    private void insideColumns(Identifier identifier, QualIdent qualIdent) {
        if (identifier.fullyTypedIdent.isEmpty()) {
            if (qualIdent == null) {
                this.completeColumnWithTableIfSimpleIdent(identifier.lastPrefix, identifier.quoted);
            } else {
                this.items.addColumns(this.resolveTable(qualIdent), identifier.lastPrefix, identifier.quoted, this.substitutionOffset);
            }
        } else if (qualIdent == null) {
            this.completeColumnWithTableIfQualIdent(identifier.fullyTypedIdent, identifier.lastPrefix, identifier.quoted);
        } else {
            this.items.addColumns(this.resolveTable(qualIdent), identifier.lastPrefix, identifier.quoted, this.substitutionOffset);
        }
    }

    private void insideFrom(Identifier identifier) {
        if (identifier.fullyTypedIdent.isEmpty()) {
            this.completeFromSimpleIdent(identifier.lastPrefix, identifier.quoted);
        } else if (identifier.fullyTypedIdent.isSimple()) {
            this.completeFromQualIdent(identifier.fullyTypedIdent, identifier.lastPrefix, identifier.quoted);
        }
    }

    private void insideClauseAfterFrom(Identifier identifier) {
        if (identifier.fullyTypedIdent.isEmpty()) {
            this.completeSimpleIdentBasedOnFromClause(identifier.lastPrefix, identifier.quoted);
        } else {
            this.completeQualIdentBasedOnFromClause(identifier.fullyTypedIdent, identifier.lastPrefix, identifier.quoted);
        }
    }

    private void completeSelectSimpleIdent(String string, boolean bl) {
        if (this.fromClause != null) {
            this.completeSimpleIdentBasedOnFromClause(string, bl);
        } else {
            Schema schema = this.metadata.getDefaultSchema();
            if (schema != null) {
                if (string != null) {
                    for (Table table : schema.getTables()) {
                        this.items.addColumns(table, string, bl, this.substitutionOffset);
                    }
                }
                this.items.addTables(schema, null, string, bl, this.substitutionOffset);
            }
            Catalog catalog = this.metadata.getDefaultCatalog();
            this.items.addSchemas(catalog, null, string, bl, this.substitutionOffset);
            this.items.addCatalogs(this.metadata, null, string, bl, this.substitutionOffset);
        }
    }

    private void completeColumnWithTableIfSimpleIdent(String string, boolean bl) {
        Schema schema = this.metadata.getDefaultSchema();
        if (schema != null) {
            if (string != null) {
                for (Table table : schema.getTables()) {
                    this.items.addColumnsWithTableName(table, null, string, bl, this.substitutionOffset - 1);
                }
            } else {
                this.items.addTablesAtInsertInto(schema, null, null, string, bl, this.substitutionOffset - 1);
            }
        }
        Catalog catalog = this.metadata.getDefaultCatalog();
        this.items.addSchemas(catalog, null, string, bl, this.substitutionOffset);
        this.items.addCatalogs(this.metadata, null, string, bl, this.substitutionOffset);
    }

    private void completeColumnWithTableIfQualIdent(QualIdent qualIdent, String string, boolean bl) {
        Catalog catalog;
        Schema schema;
        Table table = this.resolveTable(qualIdent);
        if (table != null) {
            this.items.addColumnsWithTableName(table, qualIdent, string, bl, this.substitutionOffset - 1);
        }
        if ((schema = this.resolveSchema(qualIdent)) != null) {
            this.items.addTablesAtInsertInto(schema, qualIdent, null, string, bl, this.substitutionOffset - 1);
        }
        if ((catalog = this.resolveCatalog(qualIdent)) != null) {
            this.completeCatalog(catalog, string, bl);
        }
    }

    private void completeSelectQualIdent(QualIdent qualIdent, String string, boolean bl) {
        if (this.fromClause != null) {
            this.completeQualIdentBasedOnFromClause(qualIdent, string, bl);
        } else {
            Catalog catalog;
            Schema schema;
            Table table = this.resolveTable(qualIdent);
            if (table != null) {
                this.items.addColumns(table, string, bl, this.substitutionOffset);
            }
            if ((schema = this.resolveSchema(qualIdent)) != null) {
                this.items.addTables(schema, null, string, bl, this.substitutionOffset);
            }
            if ((catalog = this.resolveCatalog(qualIdent)) != null) {
                this.completeCatalog(catalog, string, bl);
            }
        }
    }

    private void completeFromSimpleIdent(String string, boolean bl) {
        Schema schema = this.metadata.getDefaultSchema();
        if (schema != null) {
            this.items.addTables(schema, null, string, bl, this.substitutionOffset);
        }
        Catalog catalog = this.metadata.getDefaultCatalog();
        this.items.addSchemas(catalog, null, string, bl, this.substitutionOffset);
        this.items.addCatalogs(this.metadata, null, string, bl, this.substitutionOffset);
    }

    private void completeFromQualIdent(QualIdent qualIdent, String string, boolean bl) {
        Catalog catalog;
        Schema schema = this.resolveSchema(qualIdent);
        if (schema != null) {
            this.items.addTables(schema, null, string, bl, this.substitutionOffset);
        }
        if ((catalog = this.resolveCatalog(qualIdent)) != null) {
            this.completeCatalog(catalog, string, bl);
        }
    }

    private void completeSimpleIdentBasedOnFromClause(String string, boolean bl) {
        Table table3;
        Object object;
        assert (this.fromClause != null);
        Set<QualIdent> set = this.fromClause.getUnaliasedTableNames();
        Set<Table> set2 = this.resolveTables(set);
        TreeSet<QualIdent> treeSet = new TreeSet<QualIdent>(set);
        LinkedHashSet<Table> linkedHashSet = new LinkedHashSet<Table>(set2);
        Map<String, QualIdent> map = this.fromClause.getAliasedTableNames();
        for (Map.Entry<String, QualIdent> object22 : map.entrySet()) {
            QualIdent qualIdent = object22.getValue();
            treeSet.add(qualIdent);
            object = this.resolveTable(qualIdent);
            if (object == null) continue;
            linkedHashSet.add((Table)object);
        }
        TreeMap<String, QualIdent> treeMap = new TreeMap<String, QualIdent>(map);
        this.items.addAliases((Map<String, QualIdent>)treeMap, string, bl, this.substitutionOffset);
        for (Table table2 : linkedHashSet) {
            this.items.addColumns(table2, string, bl, this.substitutionOffset);
        }
        Schema schema = this.metadata.getDefaultSchema();
        if (schema != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Table table3 : set2) {
                if (!table3.getParent().isDefault()) continue;
                hashSet.add(table3.getName());
            }
            this.items.addTables(schema, hashSet, string, bl, this.substitutionOffset);
        }
        HashSet<String> hashSet = new HashSet<String>();
        object = new HashSet();
        for (Table table4 : set2) {
            Schema schema2 = table4.getParent();
            Catalog catalog = schema2.getParent();
            if (!schema2.isDefault() && !schema2.isSynthetic() && catalog.isDefault()) {
                hashSet.add(schema2.getName());
            }
            if (catalog.isDefault()) continue;
            object.add(catalog.getName());
        }
        table3 = this.metadata.getDefaultCatalog();
        this.items.addSchemas((Catalog)table3, hashSet, string, bl, this.substitutionOffset);
        this.items.addCatalogs(this.metadata, (Set<String>)object, string, bl, this.substitutionOffset);
    }

    private void completeQualIdentBasedOnFromClause(QualIdent qualIdent, String string, boolean bl) {
        Catalog catalog;
        Object object;
        assert (this.fromClause != null);
        Set<Table> set = this.resolveTables(this.fromClause.getUnaliasedTableNames());
        Table table = this.resolveTable(qualIdent);
        if (table == null || !set.contains(table)) {
            table = null;
            if (qualIdent.isSimple() && (object = this.fromClause.getTableNameByAlias(qualIdent.getSimpleName())) != null) {
                table = this.resolveTable((QualIdent)object);
            }
        }
        if (table != null) {
            this.items.addColumns(table, string, bl, this.substitutionOffset);
        }
        if ((object = this.resolveSchema(qualIdent)) != null) {
            catalog = new HashSet();
            for (Table object2 : set) {
                if (!object2.getParent().equals(object)) continue;
                catalog.add(object2.getName());
            }
            this.items.addTables((Schema)object, (Set<String>)catalog, string, bl, this.substitutionOffset);
        }
        if ((catalog = this.resolveCatalog(qualIdent)) != null) {
            HashSet hashSet = new HashSet();
            HashSet<String> hashSet2 = new HashSet<String>();
            for (Table table2 : set) {
                object = table2.getParent();
                if (!object.getParent().equals(catalog)) continue;
                if (!object.isSynthetic()) {
                    hashSet2.add(object.getName());
                    continue;
                }
                hashSet.add(table2.getName());
            }
            this.items.addSchemas(catalog, hashSet2, string, bl, this.substitutionOffset);
            this.items.addTables(catalog.getSyntheticSchema(), hashSet, string, bl, this.substitutionOffset);
        }
    }

    private void completeCatalog(Catalog catalog, String string, boolean bl) {
        this.items.addSchemas(catalog, null, string, bl, this.substitutionOffset);
        Schema schema = catalog.getSyntheticSchema();
        if (schema != null) {
            this.items.addTables(schema, null, string, bl, this.substitutionOffset);
        }
    }

    private Catalog resolveCatalog(QualIdent qualIdent) {
        if (qualIdent.isSimple()) {
            return this.metadata.getCatalog(qualIdent.getSimpleName());
        }
        return null;
    }

    private Schema resolveSchema(QualIdent qualIdent) {
        Schema schema = null;
        switch (qualIdent.size()) {
            case 1: {
                Catalog catalog = this.metadata.getDefaultCatalog();
                schema = catalog.getSchema(qualIdent.getSimpleName());
                break;
            }
            case 2: {
                Catalog catalog = this.metadata.getCatalog(qualIdent.getFirstQualifier());
                if (catalog == null) break;
                schema = catalog.getSchema(qualIdent.getSimpleName());
            }
        }
        return schema;
    }

    private Table resolveTable(QualIdent qualIdent) {
        Table table = null;
        switch (qualIdent.size()) {
            case 1: {
                Schema schema = this.metadata.getDefaultSchema();
                if (schema == null) break;
                return schema.getTable(qualIdent.getSimpleName());
            }
            case 2: {
                Catalog catalog = this.metadata.getDefaultCatalog();
                Schema schema = catalog.getSchema(qualIdent.getFirstQualifier());
                if (schema != null) {
                    table = schema.getTable(qualIdent.getSimpleName());
                }
                if (table != null || (catalog = this.metadata.getCatalog(qualIdent.getFirstQualifier())) == null || (schema = catalog.getSyntheticSchema()) == null) break;
                table = schema.getTable(qualIdent.getSimpleName());
                break;
            }
            case 3: {
                Schema schema;
                Catalog catalog = this.metadata.getCatalog(qualIdent.getFirstQualifier());
                if (catalog == null || (schema = catalog.getSchema(qualIdent.getSecondQualifier())) == null) break;
                table = schema.getTable(qualIdent.getSimpleName());
            }
        }
        return table;
    }

    private Set<Table> resolveTables(Set<QualIdent> set) {
        LinkedHashSet<Table> linkedHashSet = new LinkedHashSet<Table>(set.size());
        for (QualIdent qualIdent : set) {
            Table table = this.resolveTable(qualIdent);
            if (table == null) continue;
            linkedHashSet.add(table);
        }
        return linkedHashSet;
    }

    private Identifier findIdentifier() {
        TokenSequence<SQLTokenId> tokenSequence = this.env.getTokenSequence();
        int n = this.env.getCaretOffset();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (tokenSequence.move(n) > 0 ? !tokenSequence.moveNext() && !tokenSequence.movePrevious() : !tokenSequence.movePrevious()) {
            return null;
        }
        switch ((SQLTokenId)tokenSequence.token().id()) {
            case LINE_COMMENT: 
            case BLOCK_COMMENT: 
            case INT_LITERAL: 
            case DOUBLE_LITERAL: 
            case STRING: 
            case INCOMPLETE_STRING: {
                return null;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        block8: do {
            switch ((SQLTokenId)tokenSequence.token().id()) {
                case DOT: {
                    if (arrayList.isEmpty()) {
                        n2 = n;
                        bl = true;
                    }
                    bl2 = true;
                    break;
                }
                case IDENTIFIER: 
                case KEYWORD: {
                    if (bl2 || arrayList.isEmpty()) {
                        if (arrayList.isEmpty() && n2 == -1) {
                            n2 = tokenSequence.offset();
                        }
                        bl2 = false;
                        int n3 = n - tokenSequence.offset();
                        String string = n3 > 0 && n3 < tokenSequence.token().length() ? ((Object)tokenSequence.token().text().subSequence(0, n3)).toString() : ((Object)tokenSequence.token().text()).toString();
                        arrayList.add(string);
                        break;
                    }
                    return null;
                }
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case WHITESPACE: {
                    if (!tokenSequence.movePrevious()) break block8;
                    if (tokenSequence.token().id() == SQLTokenId.IDENTIFIER) {
                        return null;
                    }
                    if (tokenSequence.token().id() != SQLTokenId.DOT) break block8;
                    tokenSequence.moveNext();
                    break;
                }
                default: {
                    break block8;
                }
            }
        } while (tokenSequence.movePrevious());
        Collections.reverse(arrayList);
        return this.createIdentifier(arrayList, bl, n2 >= 0 ? n2 : n);
    }

    private Identifier createIdentifier(List<String> list, boolean bl, int n) {
        String string = null;
        boolean bl2 = false;
        int n2 = n;
        if (list.isEmpty()) {
            if (bl) {
                return null;
            }
        } else {
            if (!bl) {
                String string2;
                string = list.remove(list.size() - 1);
                if (string.startsWith(string2 = this.quoter.getQuoteString())) {
                    if (string.endsWith(string2) && string.length() > string2.length()) {
                        return null;
                    }
                    int n3 = string.length();
                    string = this.quoter.unquote(string);
                    n += n3 - string.length();
                    bl2 = true;
                } else if (string.endsWith(string2)) {
                    return null;
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                String string3 = this.quoter.unquote(list.get(i));
                if (string3.length() == 0) {
                    return null;
                }
                list.set(i, string3);
            }
        }
        return new Identifier(new QualIdent(list), string, bl2, n, n2);
    }

    private static void reportError(MetadataModelException metadataModelException) {
        LOGGER.log(Level.INFO, null, metadataModelException);
        String string = metadataModelException.getMessage();
        String string2 = string != null ? NbBundle.getMessage(SQLCompletionQuery.class, (String)"MSG_Error", (Object)string) : NbBundle.getMessage(SQLCompletionQuery.class, (String)"MSG_ErrorNoMessage");
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
    }

    private static final class Identifier {
        final QualIdent fullyTypedIdent;
        final String lastPrefix;
        final boolean quoted;
        final int anchorOffset;
        final int substitutionOffset;

        private Identifier(QualIdent qualIdent, String string, boolean bl, int n, int n2) {
            this.fullyTypedIdent = qualIdent;
            this.lastPrefix = string;
            this.quoted = bl;
            this.anchorOffset = n;
            this.substitutionOffset = n2;
        }
    }
}

