/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.db.api.sql.execute.SQLScript;
import org.netbeans.modules.db.api.sql.execute.SQLScriptStatement;
import org.netbeans.modules.db.sql.editor.api.completion.SubstitutionHandler;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLCompletionEnv {
    private final String statement;
    private final int statementOffset;
    private final int caretOffset;
    private final SubstitutionHandler substitutionHandler;
    private final TokenSequence<SQLTokenId> seq;

    public static SQLCompletionEnv forDocument(Document document, int n) {
        String string = SQLCompletionEnv.getDocumentText(document);
        if (string != null) {
            return SQLCompletionEnv.forScript(string, n);
        }
        return null;
    }

    public static SQLCompletionEnv forStatement(String string, int n, SubstitutionHandler substitutionHandler) {
        return new SQLCompletionEnv(string, 0, n, substitutionHandler);
    }

    static SQLCompletionEnv forScript(String string, int n) {
        SQLScriptStatement sQLScriptStatement = SQLScript.create((String)string).getStatementAtOffset(n);
        if (sQLScriptStatement != null) {
            return new SQLCompletionEnv(sQLScriptStatement.getText(), sQLScriptStatement.getStartOffset(), n - sQLScriptStatement.getStartOffset(), new ScriptSubstitutionHandler(sQLScriptStatement.getStartOffset()));
        }
        return null;
    }

    private SQLCompletionEnv(String string, int n, int n2, SubstitutionHandler substitutionHandler) {
        this.statement = string;
        this.statementOffset = n;
        this.caretOffset = n2;
        this.substitutionHandler = substitutionHandler;
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, SQLTokenId.language());
        this.seq = tokenHierarchy.tokenSequence(SQLTokenId.language());
    }

    public String getStatement() {
        return this.statement;
    }

    public int getStatementOffset() {
        return this.statementOffset;
    }

    public SubstitutionHandler getSubstitutionHandler() {
        return this.substitutionHandler;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public TokenSequence<SQLTokenId> getTokenSequence() {
        return this.seq;
    }

    private static String getDocumentText(final Document document) {
        final String[] stringArray = new String[]{null};
        document.render(new Runnable(){

            public void run() {
                try {
                    stringArray[0] = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return stringArray[0];
    }

    private static final class ScriptSubstitutionHandler
    implements SubstitutionHandler {
        private final int statementOffset;

        public ScriptSubstitutionHandler(int n) {
            this.statementOffset = n;
        }

        public void substituteText(JTextComponent jTextComponent, final int n, final String string) {
            final int n2 = jTextComponent.getSelectionEnd();
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            baseDocument.runAtomicAsUser(new Runnable(){

                public void run() {
                    int n3 = ScriptSubstitutionHandler.this.statementOffset + n;
                    try {
                        baseDocument.remove(n3, n2 - n3);
                        baseDocument.insertString(n3, string, null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

