/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.InsertStatement;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.editor.completion.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertStatementAnalyzer {
    private final TokenSequence<SQLTokenId> seq;
    private final boolean detectKind;
    private final SQLIdentifiers.Quoter quoter;
    private final List<String> columns = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();
    private QualIdent table = null;
    private final SortedMap<Integer, InsertStatement.InsertContext> offset2Context = new TreeMap<Integer, InsertStatement.InsertContext>();
    private int startOffset;
    private State state = State.START;

    public static InsertStatement analyze(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter) {
        InsertStatementAnalyzer insertStatementAnalyzer = InsertStatementAnalyzer.doParse(tokenSequence, quoter, false);
        if (insertStatementAnalyzer == null || !insertStatementAnalyzer.state.isAfter(State.START)) {
            return null;
        }
        return new InsertStatement(SQLStatementKind.INSERT, insertStatementAnalyzer.startOffset, tokenSequence.offset() + tokenSequence.token().length(), insertStatementAnalyzer.getTable(), Collections.unmodifiableList(insertStatementAnalyzer.columns), Collections.unmodifiableList(insertStatementAnalyzer.values), insertStatementAnalyzer.offset2Context);
    }

    private static InsertStatementAnalyzer doParse(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter, boolean bl) {
        tokenSequence.moveStart();
        if (!tokenSequence.moveNext()) {
            return null;
        }
        InsertStatementAnalyzer insertStatementAnalyzer = new InsertStatementAnalyzer(tokenSequence, quoter, bl);
        insertStatementAnalyzer.parse();
        return insertStatementAnalyzer;
    }

    private InsertStatementAnalyzer(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter, boolean bl) {
        this.seq = tokenSequence;
        this.quoter = quoter;
        this.detectKind = bl;
    }

    private void parse() {
        this.startOffset = this.seq.offset();
        block20: do {
            switch (this.state) {
                case START: {
                    if (!SQLStatementAnalyzer.isKeyword("INSERT", this.seq)) break;
                    this.moveToState(State.INSERT);
                    if (!this.detectKind) break;
                    return;
                }
                case INSERT: {
                    if (!SQLStatementAnalyzer.isKeyword("INTO", this.seq)) break;
                    this.moveToState(State.INTO);
                    if (!this.detectKind) break;
                    return;
                }
                case INTO: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            this.table = this.parseIntoTable();
                            break;
                        }
                        case LPAREN: {
                            this.moveToState(State.COLUMNS);
                            break;
                        }
                        case KEYWORD: {
                            if (!SQLStatementAnalyzer.isKeyword("VALUES", this.seq)) break;
                            this.moveToState(State.VALUES);
                        }
                    }
                    continue block20;
                }
                case COLUMNS: {
                    List<String> list;
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            list = this.analyzeChosenColumns();
                            if (list.isEmpty()) break;
                            this.columns.addAll(list);
                            break;
                        }
                        case KEYWORD: {
                            if (!SQLStatementAnalyzer.isKeyword("VALUES", this.seq)) break;
                            this.moveToState(State.VALUES);
                            break;
                        }
                        case RPAREN: {
                            this.moveToState(State.VALUES);
                        }
                    }
                    continue block20;
                }
                case VALUES: {
                    List<String> list;
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            list = this.analyzeChosenColumns();
                            if (list.isEmpty()) break;
                            this.values.addAll(list);
                        }
                    }
                    break;
                }
            }
        } while (this.nextToken());
    }

    private List<String> analyzeChosenColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getUnquotedIdentifier());
        block5: while (this.seq.moveNext()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case WHITESPACE: {
                    continue block5;
                }
                case COMMA: {
                    continue block5;
                }
                case RPAREN: {
                    this.moveToState(State.VALUES);
                    return arrayList;
                }
            }
            arrayList.add(this.getUnquotedIdentifier());
        }
        return arrayList;
    }

    private QualIdent parseIntoTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getUnquotedIdentifier());
        boolean bl = false;
        block4: while (this.nextToken()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case DOT: {
                    bl = true;
                    continue block4;
                }
                case IDENTIFIER: {
                    if (!bl) continue block4;
                    bl = false;
                    arrayList.add(this.getUnquotedIdentifier());
                    continue block4;
                }
            }
            this.seq.movePrevious();
            break;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (((String)iterator.next()).length() != 0) continue;
            iterator.remove();
        }
        if (!arrayList.isEmpty()) {
            return new QualIdent(arrayList);
        }
        return null;
    }

    private boolean nextToken() {
        boolean bl;
        block3: while (bl = this.seq.moveNext()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: {
                    continue block3;
                }
            }
            break;
        }
        return bl;
    }

    private QualIdent getTable() {
        return this.table;
    }

    private void moveToState(State state) {
        this.state = state;
        InsertStatement.InsertContext insertContext = state.getContext();
        if (insertContext != null) {
            this.offset2Context.put(this.seq.offset() + this.seq.token().length(), insertContext);
        }
    }

    private String getUnquotedIdentifier() {
        return this.quoter.unquote(((Object)this.seq.token().text()).toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        START(0, null),
        INSERT(1, InsertStatement.InsertContext.INSERT),
        INTO(2, InsertStatement.InsertContext.INTO),
        COLUMNS(3, InsertStatement.InsertContext.COLUMNS),
        VALUES(4, InsertStatement.InsertContext.VALUES);

        private final int order;
        private final InsertStatement.InsertContext context;

        private State(int n2, InsertStatement.InsertContext insertContext) {
            this.order = n2;
            this.context = insertContext;
        }

        public boolean isAfter(State state) {
            return this.order >= state.order;
        }

        public InsertStatement.InsertContext getContext() {
            return this.context;
        }
    }
}

