/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.modules.java.j2seplatform.libraries.VolumeContentModel;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.project.libraries.LibraryCustomizerContext;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class J2SEVolumeCustomizer
extends JPanel
implements Customizer {
    private String volumeType;
    private LibraryImplementation impl;
    private LibraryStorageArea area;
    private VolumeContentModel model;
    private Boolean allowRelativePaths = null;
    private static File lastFolder = null;
    private JButton addButton;
    private JList content;
    private JButton downButton;
    private JScrollPane jScrollPane1;
    private JLabel message;
    private JButton removeButton;
    private JButton upButton;
    private JButton addURLButton;

    J2SEVolumeCustomizer(String string) {
        this.volumeType = string;
        this.initComponents();
        this.postInitComponents();
        this.setName(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)("TXT_" + string)));
    }

    public void addNotify() {
        super.addNotify();
        this.addButton.requestFocus();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.addButton.setEnabled(bl);
        if (this.addURLButton != null) {
            this.addURLButton.setEnabled(bl);
        }
        int[] nArray = this.content.getSelectedIndices();
        this.removeButton.setEnabled(bl && nArray.length > 0);
        this.downButton.setEnabled(bl && nArray.length > 0 && nArray[nArray.length - 1] < this.model.getSize() - 1);
        this.upButton.setEnabled(bl && nArray.length > 0 && nArray[0] > 0);
    }

    private void postInitComponents() {
        this.content.setCellRenderer(new ContentRenderer());
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        if (this.volumeType.equals("classpath")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddClassPath"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddClassPath").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentClassPath"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentClassPath").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddClassPath"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentClassPath"));
        } else if (this.volumeType.equals("javadoc")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddJavadoc"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddJavadoc").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentJavadoc"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentJavadoc").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddJavadoc"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentJavadoc"));
        } else if (this.volumeType.equals("src")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddSources"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddSources").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentSources"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentSources").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddSources"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentSources"));
        }
        this.content.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int[] nArray = J2SEVolumeCustomizer.this.content.getSelectedIndices();
                J2SEVolumeCustomizer.this.removeButton.setEnabled(nArray.length > 0);
                J2SEVolumeCustomizer.this.downButton.setEnabled(nArray.length > 0 && nArray[nArray.length - 1] < J2SEVolumeCustomizer.this.model.getSize() - 1);
                J2SEVolumeCustomizer.this.upButton.setEnabled(nArray.length > 0 && nArray[0] > 0);
            }
        });
        this.content.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.content.getActionMap().put("delete", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                J2SEVolumeCustomizer.this.removeResource(null);
            }
        });
    }

    private void initComponents() {
        this.message = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.content = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("AD_J2SEVolumeCustomizer"));
        this.message.setLabelFor(this.content);
        Mnemonics.setLocalizedText((JLabel)this.message, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_ContentMessage"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 2, 6);
        this.add((Component)this.message, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.content);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_AddContent"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                J2SEVolumeCustomizer.this.addResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_RemoveContent"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                J2SEVolumeCustomizer.this.removeResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("AD_RemoveContent"));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_UpContent"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                J2SEVolumeCustomizer.this.upResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.add((Component)this.upButton, gridBagConstraints);
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("AD_UpContent"));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_DownContent"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                J2SEVolumeCustomizer.this.downResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.downButton, gridBagConstraints);
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("AD_DownContent"));
    }

    private void downResource(ActionEvent actionEvent) {
        int[] nArray = this.content.getSelectedIndices();
        if (nArray.length == 0 || nArray[0] < 0 || nArray[nArray.length - 1] >= this.model.getSize() - 1) {
            return;
        }
        this.model.moveDown(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray[i] + 1;
        }
        this.content.setSelectedIndices(nArray);
    }

    private void upResource(ActionEvent actionEvent) {
        int[] nArray = this.content.getSelectedIndices();
        if (nArray.length == 0 || nArray[0] <= 0) {
            return;
        }
        this.model.moveUp(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray[i] - 1;
        }
        this.content.setSelectedIndices(nArray);
    }

    private void removeResource(ActionEvent actionEvent) {
        int[] nArray = this.content.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        this.model.removeResources(nArray);
        if (nArray[nArray.length - 1] - nArray.length + 1 < this.model.getSize()) {
            this.content.setSelectedIndex(nArray[nArray.length - 1] - nArray.length + 1);
        } else if (nArray[0] >= 1) {
            this.content.setSelectedIndex(nArray[0] - 1);
        }
        if (this.volumeType.equals("classpath")) {
            this.impl.setContent("maven-pom", Collections.emptyList());
        }
    }

    private void addResource(ActionEvent actionEvent) {
        File file = null;
        File file2 = null;
        if (this.allowRelativePaths != null && this.allowRelativePaths.booleanValue()) {
            file = new File(URI.create(this.area.getLocation().toExternalForm())).getParentFile();
            file2 = new File(file, this.impl.getName());
        }
        FileChooser fileChooser = new FileChooser(file, file2);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
        fileChooser.setFileHidingEnabled(false);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (this.volumeType.equals("classpath")) {
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenClasses"));
            fileChooser.setFileSelectionMode(2);
            fileChooser.setFileFilter((FileFilter)new ArchiveFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Classpath"), new String[]{"ZIP", "JAR"}));
            fileChooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectCP"));
            fileChooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectCP").charAt(0));
        } else if (this.volumeType.equals("javadoc")) {
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenJavadoc"));
            fileChooser.setFileSelectionMode(2);
            fileChooser.setFileFilter((FileFilter)new ArchiveFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Javadoc"), new String[]{"ZIP", "JAR"}));
            fileChooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectJD"));
            fileChooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectJD").charAt(0));
        } else if (this.volumeType.equals("src")) {
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenSources"));
            fileChooser.setFileSelectionMode(2);
            fileChooser.setFileFilter((FileFilter)new ArchiveFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Sources"), new String[]{"ZIP", "JAR"}));
            fileChooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectSRC"));
            fileChooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectSRC").charAt(0));
        }
        if (lastFolder != null) {
            fileChooser.setCurrentDirectory(lastFolder);
        } else if (file != null) {
            fileChooser.setCurrentDirectory(file);
        }
        if (fileChooser.showOpenDialog((Component)this) == 0) {
            try {
                lastFolder = fileChooser.getCurrentDirectory();
                this.addFiles(fileChooser.getSelectedPaths(), this.area != null ? this.area.getLocation() : null, this.volumeType);
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void addFiles(String[] stringArray, URL uRL, String string) throws MalformedURLException, URISyntaxException {
        Object object;
        int n;
        int n2 = this.model.getSize();
        for (n = 0; n < stringArray.length; ++n) {
            Object object2;
            object = new File(stringArray[n]);
            URI uRI = LibrariesSupport.convertFilePathToURI((String)stringArray[n]);
            if (this.allowRelativePaths != null && this.allowRelativePaths.booleanValue()) {
                object2 = object;
                if (!((File)object).isAbsolute()) {
                    assert (this.area != null);
                    if (this.area != null) {
                        object2 = FileUtil.normalizeFile((File)new File(new File(URI.create(this.area.getLocation().toExternalForm())).getParentFile(), ((File)object).getPath()));
                    }
                }
                String string2 = this.checkFile((File)object2, string);
                if (FileUtil.isArchiveFile((URL)((File)object2).toURI().toURL())) {
                    uRI = LibrariesSupport.getArchiveRoot((URI)uRI);
                    if (string2 != null) {
                        assert (uRI.toString().endsWith("!/")) : uRI.toString();
                        uRI = URI.create(uRI.toString() + J2SEVolumeCustomizer.encodePath(string2));
                    }
                } else if (!uRI.toString().endsWith("/")) {
                    try {
                        uRI = new URI(uRI.toString() + "/");
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new AssertionError((Object)uRISyntaxException);
                    }
                }
                this.model.addResource(uRI);
                continue;
            }
            assert (((File)object).isAbsolute()) : ((File)object).getPath();
            object2 = this.checkFile((File)object, string);
            uRI = FileUtil.normalizeFile((File)object).toURI();
            if (FileUtil.isArchiveFile((URL)uRI.toURL())) {
                uRI = LibrariesSupport.getArchiveRoot((URI)uRI);
                if (object2 != null) {
                    assert (uRI.toString().endsWith("!/")) : uRI.toString();
                    uRI = URI.create(uRI.toString() + J2SEVolumeCustomizer.encodePath((String)object2));
                }
            } else if (!uRI.toString().endsWith("/")) {
                uRI = URI.create(uRI.toString() + "/");
            }
            this.model.addResource(uRI.toURL());
        }
        n = this.model.getSize() - 1;
        if (n2 <= n) {
            object = new int[n - n2 + 1];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = n2 + i;
            }
            this.content.setSelectedIndices((int[])object);
        }
        if (this.volumeType.equals("classpath") && this.impl != null) {
            this.impl.setContent("maven-pom", Collections.emptyList());
        }
    }

    static String encodePath(String string) throws URISyntaxException {
        return new URI(null, null, string, null).getRawPath();
    }

    private String checkFile(File file, String string) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (string.equals("javadoc")) {
            if (fileObject != null) {
                FileObject fileObject2;
                if (fileObject.isData()) {
                    fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
                }
                if ((fileObject2 = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)fileObject)) == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_InvalidJavadocRoot", (Object)file.getPath()), 0));
                    return null;
                }
                return FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2) + "/";
            }
        } else if (string.equals("src") && fileObject != null) {
            FileObject fileObject3;
            if (fileObject.isData()) {
                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
            }
            if ((fileObject3 = JavadocAndSourceRootDetection.findSourceRoot((FileObject)fileObject)) == null) {
                return null;
            }
            if (FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject)) {
                return null;
            }
            assert (fileObject.equals(fileObject3) || FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject3)) : fileObject.toString() + " is not parent of " + fileObject3;
            return FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject3) + "/";
        }
        return null;
    }

    public void setObject(Object object) {
        assert (object instanceof LibraryCustomizerContext) : object.getClass();
        LibraryCustomizerContext libraryCustomizerContext = (LibraryCustomizerContext)object;
        this.area = libraryCustomizerContext.getLibraryStorageArea();
        this.impl = libraryCustomizerContext.getLibraryImplementation();
        this.allowRelativePaths = libraryCustomizerContext.getLibraryImplementation2() != null;
        this.model = new VolumeContentModel(this.impl, this.area, this.volumeType);
        this.content.setModel(this.model);
        if (this.model.getSize() > 0) {
            this.content.setSelectedIndex(0);
        }
    }

    private static class ContentRenderer
    extends DefaultListCellRenderer {
        private ContentRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component;
            String string = null;
            Color color = null;
            String string2 = null;
            URI uRI = null;
            if (object instanceof URI) {
                uRI = (URI)object;
            } else if (object instanceof URL) {
                try {
                    uRI = ((URL)object).toURI();
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                }
            }
            if (uRI != null) {
                if (uRI.toString().contains("!/")) {
                    uRI = LibrariesSupport.getArchiveFile((URI)uRI);
                }
                boolean bl3 = false;
                VolumeContentModel volumeContentModel = (VolumeContentModel)jList.getModel();
                LibraryStorageArea libraryStorageArea = volumeContentModel.getArea();
                FileObject fileObject = LibrariesSupport.resolveLibraryEntryFileObject((URL)(libraryStorageArea != null ? libraryStorageArea.getLocation() : null), (URI)uRI);
                if (fileObject == null) {
                    bl3 = true;
                    if ("file".equals(uRI.getScheme())) {
                        string = LibrariesSupport.convertURIToFilePath((URI)uRI);
                        if (string.startsWith("${")) {
                            bl3 = false;
                        }
                    } else {
                        string = uRI.toString();
                    }
                } else if (uRI.isAbsolute()) {
                    string = FileUtil.getFileDisplayName((FileObject)fileObject);
                } else {
                    string = LibrariesSupport.convertURIToFilePath((URI)uRI);
                    string2 = FileUtil.getFileDisplayName((FileObject)fileObject);
                }
                if (bl3) {
                    color = new Color(164, 0, 0);
                    string2 = NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_BrokenFile");
                }
            }
            if ((component = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2)) instanceof JComponent) {
                if (color != null) {
                    ((JComponent)component).setForeground(color);
                }
                if (string2 != null) {
                    ((JComponent)component).setToolTipText(string2);
                } else {
                    ((JComponent)component).setToolTipText(null);
                }
            }
            return component;
        }
    }

    private static class ArchiveFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public ArchiveFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n <= 0 || n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(n + 1).toUpperCase();
            if (!this.extensions.contains(string2)) {
                return false;
            }
            try {
                return FileUtil.isArchiveFile((URL)file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
                return false;
            }
        }

        public String getDescription() {
            return this.description;
        }
    }
}

