/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.web.wizards.BaseWizardPanel;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.netbeans.modules.web.wizards.MappingEditor;
import org.netbeans.modules.web.wizards.MappingTable;
import org.netbeans.modules.web.wizards.ServletData;
import org.openide.util.NbBundle;

class MappingPanel
extends JPanel
implements ActionListener,
TableModelListener,
ListSelectionListener {
    private static final String ADD = "add";
    private static final String EDIT = "edit";
    private static final String REMOVE = "remove";
    private static final String UP = "up";
    private static final String DOWN = "down";
    private JLabel jLtableheader;
    private MappingTable table;
    private JButton jBnew;
    private JButton jBedit;
    private JButton jBdelete;
    private JButton jBdown;
    private JButton jBup;
    private JScrollPane scrollP;
    private ServletData deployData;
    private BaseWizardPanel parent;
    private boolean edited = false;
    private static final long serialVersionUID = 6540270797782597645L;

    public MappingPanel(ServletData servletData, BaseWizardPanel baseWizardPanel) {
        this.deployData = servletData;
        this.parent = baseWizardPanel;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 60);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(4, 20, 4, 60);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridheight = 6;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 0.9;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(4, 0, 4, 0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = -1;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.insets = new Insets(4, 0, 4, 0);
        this.jLtableheader = new JLabel(NbBundle.getMessage(MappingPanel.class, (String)"LBL_filter_mappings"));
        this.jLtableheader.setDisplayedMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_filter_mappings_mnemonic").charAt(0));
        this.jLtableheader.setLabelFor(this.table);
        this.add((Component)this.jLtableheader, gridBagConstraints);
        this.table = new MappingTable(this.deployData.getName(), this.deployData.getFilterMappings());
        this.jLtableheader.setLabelFor(this.table);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_desc"));
        this.table.getModel().addTableModelListener(this);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.scrollP = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.add((Component)this.scrollP, gridBagConstraints3);
        this.jBnew = new JButton();
        this.jBnew.setText(NbBundle.getMessage(MappingPanel.class, (String)"LBL_newdots"));
        this.jBnew.setMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_new_mnemonic").charAt(0));
        this.jBnew.addActionListener(this);
        this.jBnew.setActionCommand(ADD);
        this.jBnew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_new"));
        this.add((Component)this.jBnew, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        this.jBedit = new JButton();
        this.jBedit.setText(NbBundle.getMessage(MappingPanel.class, (String)"LBL_edit"));
        this.jBedit.setMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_edit_mnemonic").charAt(0));
        this.jBedit.addActionListener(this);
        this.jBedit.setActionCommand(EDIT);
        this.jBedit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_edit"));
        this.add((Component)this.jBedit, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        this.jBdelete = new JButton();
        this.jBdelete.setText(NbBundle.getMessage(MappingPanel.class, (String)"LBL_delete"));
        this.jBdelete.setMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_delete_mnemonic").charAt(0));
        this.jBdelete.addActionListener(this);
        this.jBdelete.setActionCommand(REMOVE);
        this.jBdelete.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_delete"));
        this.add((Component)this.jBdelete, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        this.jBup = new JButton();
        this.jBup.setText(NbBundle.getMessage(MappingPanel.class, (String)"LBL_move_up"));
        this.jBup.setMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_move_up_mnemonic").charAt(0));
        this.jBup.addActionListener(this);
        this.jBup.setActionCommand(UP);
        this.jBup.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_up"));
        this.add((Component)this.jBup, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        this.jBdown = new JButton();
        this.jBdown.setText(NbBundle.getMessage(MappingPanel.class, (String)"LBL_move_down"));
        this.jBdown.setMnemonic(NbBundle.getMessage(MappingPanel.class, (String)"LBL_move_down_mnemonic").charAt(0));
        this.jBdown.addActionListener(this);
        this.jBdown.setActionCommand(DOWN);
        this.jBdown.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingPanel.class, (String)"ACSD_filter_mappings_down"));
        this.add((Component)this.jBdown, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.fill = 1;
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, gridBagConstraints2);
        this.add((Component)new JPanel(), gridBagConstraints4);
    }

    void setData() {
        this.table.setFilterName(this.deployData.getName());
        if (!this.edited) {
            if (!this.deployData.makeEntry()) {
                this.setEnabled(false);
                return;
            }
            this.table.setRowSelectionInterval(0, 0);
            this.edited = true;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            if (actionEvent.getActionCommand() == ADD) {
                FilterMappingData filterMappingData = new FilterMappingData(this.deployData.getName());
                MappingEditor mappingEditor = new MappingEditor(filterMappingData, this.deployData.getServletNames());
                mappingEditor.showEditor();
                if (mappingEditor.isOK()) {
                    this.table.addRow(0, filterMappingData);
                }
            } else if (actionEvent.getActionCommand() == EDIT) {
                int n = this.table.getSelectedRow();
                FilterMappingData filterMappingData = this.table.getRow(n);
                FilterMappingData filterMappingData2 = (FilterMappingData)filterMappingData.clone();
                MappingEditor mappingEditor = new MappingEditor(filterMappingData2, this.deployData.getServletNames());
                mappingEditor.showEditor();
                if (mappingEditor.isOK()) {
                    this.table.setRow(n, filterMappingData2);
                }
            } else if (actionEvent.getActionCommand() == REMOVE) {
                int n = this.table.getSelectedRow();
                this.table.removeRow(n);
                this.table.clearSelection();
            } else if (actionEvent.getActionCommand() == UP) {
                int n = this.table.getSelectedRow();
                this.table.moveRowUp(n);
                this.table.setRowSelectionInterval(n - 1, n - 1);
            } else if (actionEvent.getActionCommand() == DOWN) {
                int n = this.table.getSelectedRow();
                this.table.moveRowDown(n);
                this.table.setRowSelectionInterval(n + 1, n + 1);
            }
        }
        this.edited = true;
        this.deployData.setFilterMappings(this.table.getFilterMappings());
        this.scrollP.revalidate();
        this.parent.fireChangeEvent();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.edited = true;
        this.deployData.setFilterMappings(this.table.getFilterMappings());
        this.parent.fireChangeEvent();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.setEnabled(this.deployData.makeEntry());
    }

    public void setEnabled(boolean bl) {
        this.jLtableheader.setEnabled(bl);
        this.jBnew.setEnabled(bl);
        if (!bl) {
            this.jBedit.setEnabled(false);
            this.jBdelete.setEnabled(false);
            this.jBup.setEnabled(false);
            this.jBdown.setEnabled(false);
            return;
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            this.jBdelete.setEnabled(false);
            this.jBedit.setEnabled(false);
            this.jBdown.setEnabled(false);
            this.jBup.setEnabled(false);
        } else {
            int n = listSelectionModel.getMinSelectionIndex();
            String string = (String)this.table.getValueAt(n, 0);
            boolean bl2 = string.equals(this.deployData.getName());
            this.jBdelete.setEnabled(bl2);
            this.jBedit.setEnabled(bl2);
            int n2 = this.table.getRowCount();
            if (n > 0) {
                this.jBup.setEnabled(true);
            } else {
                this.jBup.setEnabled(false);
            }
            if (n < n2 - 1) {
                this.jBdown.setEnabled(true);
            } else {
                this.jBdown.setEnabled(false);
            }
        }
    }
}

