/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.customizer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.prefs.Preferences;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.java.api.common.project.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.java.api.common.project.ui.customizer.AntArtifactItem;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class EditMediator
implements ActionListener,
ListSelectionListener {
    private static String[] DEFAULT_ANT_ARTIFACT_TYPES = new String[]{"jar", "folder"};
    public static final FileFilter JAR_ZIP_FILTER = new SimpleFileFilter(NbBundle.getMessage(EditMediator.class, (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"});
    private final ListComponent list;
    private final DefaultListModel listModel;
    private final ListSelectionModel selectionModel;
    private final ButtonModel addJar;
    private final ButtonModel addLibrary;
    private final ButtonModel addAntArtifact;
    private final ButtonModel remove;
    private final ButtonModel moveUp;
    private final ButtonModel moveDown;
    private final ButtonModel edit;
    private Document libraryPath;
    private ClassPathUiSupport.Callback callback;
    private AntProjectHelper helper;
    private ReferenceHelper refHelper;
    private Project project;
    private FileFilter filter;
    private String[] antArtifactTypes;
    private int fileSelectionMode;
    private static final String LAST_USED_CP_FOLDER = "lastUsedClassPathFolder";

    private EditMediator(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, ListComponent listComponent, ButtonModel buttonModel, ButtonModel buttonModel2, ButtonModel buttonModel3, ButtonModel buttonModel4, ButtonModel buttonModel5, ButtonModel buttonModel6, ButtonModel buttonModel7, Document document, ClassPathUiSupport.Callback callback, String[] stringArray, FileFilter fileFilter, int n) {
        this.list = listComponent;
        this.listModel = listComponent.getModel();
        this.selectionModel = listComponent.getSelectionModel();
        this.addJar = buttonModel;
        this.addLibrary = buttonModel2;
        this.addAntArtifact = buttonModel3;
        this.remove = buttonModel4;
        this.moveUp = buttonModel5;
        this.moveDown = buttonModel6;
        this.edit = buttonModel7;
        this.libraryPath = document;
        this.callback = callback;
        this.helper = antProjectHelper;
        this.refHelper = referenceHelper;
        this.project = project;
        this.filter = fileFilter;
        this.fileSelectionMode = n;
        this.antArtifactTypes = stringArray;
    }

    public static void register(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, ListComponent listComponent, ButtonModel buttonModel, ButtonModel buttonModel2, ButtonModel buttonModel3, ButtonModel buttonModel4, ButtonModel buttonModel5, ButtonModel buttonModel6, ButtonModel buttonModel7, Document document, ClassPathUiSupport.Callback callback) {
        EditMediator.register(project, antProjectHelper, referenceHelper, listComponent, buttonModel, buttonModel2, buttonModel3, buttonModel4, buttonModel5, buttonModel6, buttonModel7, document, callback, DEFAULT_ANT_ARTIFACT_TYPES, JAR_ZIP_FILTER, 2);
    }

    public static void register(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, ListComponent listComponent, ButtonModel buttonModel, ButtonModel buttonModel2, ButtonModel buttonModel3, ButtonModel buttonModel4, ButtonModel buttonModel5, ButtonModel buttonModel6, ButtonModel buttonModel7, Document document, ClassPathUiSupport.Callback callback, String[] stringArray, FileFilter fileFilter, int n) {
        EditMediator editMediator = new EditMediator(project, antProjectHelper, referenceHelper, listComponent, buttonModel, buttonModel2, buttonModel3, buttonModel4, buttonModel5, buttonModel6, buttonModel7, document, callback, stringArray, fileFilter, n);
        buttonModel.addActionListener(editMediator);
        buttonModel2.addActionListener(editMediator);
        buttonModel3.addActionListener(editMediator);
        buttonModel4.addActionListener(editMediator);
        buttonModel5.addActionListener(editMediator);
        buttonModel6.addActionListener(editMediator);
        buttonModel7.addActionListener(editMediator);
        editMediator.selectionModel.addListSelectionListener(editMediator);
        editMediator.valueChanged(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addJar) {
            FileChooser fileChooser = this.helper.isSharableProject() ? new FileChooser(this.helper, true) : new FileChooser(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), null);
            fileChooser.enableVariableBasedSelection(true);
            fileChooser.setFileHidingEnabled(false);
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
            fileChooser.setFileSelectionMode(this.fileSelectionMode);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle(NbBundle.getMessage(EditMediator.class, (String)"LBL_AddJar_DialogTitle"));
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setFileFilter(this.filter);
            File file = EditMediator.getLastUsedClassPathFolder();
            fileChooser.setCurrentDirectory(file);
            fileChooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditMediator.class, (String)"LBL_AddJar_DialogTitle"));
            int n = fileChooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(this.list.getComponent()));
            if (n == 0) {
                String[] stringArray;
                try {
                    stringArray = fileChooser.getSelectedPaths();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return;
                }
                File file2 = FileUtil.toFile((FileObject)this.helper.getProjectDirectory());
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : stringArray) {
                    File file3 = PropertyUtils.resolveFile((File)file2, (String)string);
                    FileObject fileObject = FileUtil.toFileObject((File)file3);
                    assert (fileObject != null) : file3;
                    if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                        try {
                            new JarFile(file3);
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this.list.getComponent()), NbBundle.getMessage(EditMediator.class, (String)"LBL_Corrupted_JAR", (Object)file3), NbBundle.getMessage(EditMediator.class, (String)"LBL_Corrupted_JAR_title"), 2);
                            continue;
                        }
                    }
                    arrayList.add(string);
                }
                stringArray = arrayList.toArray(new String[arrayList.size()]);
                int[] nArray = ClassPathUiSupport.addJarFiles(this.listModel, this.list.getSelectedIndices(), stringArray, file2, fileChooser.getSelectedPathVariables(), this.callback);
                this.list.setSelectedIndices(nArray);
                file = FileUtil.normalizeFile((File)fileChooser.getCurrentDirectory());
                EditMediator.setLastUsedClassPathFolder(file);
            }
        } else if (object == this.addLibrary) {
            Object object2;
            Serializable serializable;
            Object object3;
            LibraryManager libraryManager = null;
            boolean bl = false;
            try {
                object3 = this.libraryPath.getText(0, this.libraryPath.getLength());
                if (object3 != null && ((String)object3).length() > 0) {
                    serializable = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), (String)object3);
                    object2 = FileUtil.normalizeFile((File)serializable).toURI().toURL();
                    libraryManager = LibraryManager.forLocation((URL)object2);
                } else {
                    bl = true;
                }
            }
            catch (BadLocationException badLocationException) {
                bl = true;
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            if (libraryManager == null && bl) {
                libraryManager = LibraryManager.getDefault();
            }
            if (libraryManager == null) {
                return;
            }
            object3 = LibraryChooser.showDialog((LibraryManager)libraryManager, (LibraryChooser.Filter)EditMediator.createLibraryFilter(), (LibraryChooser.LibraryImportHandler)this.refHelper.getLibraryChooserImportHandler());
            if (object3 != null) {
                serializable = new HashSet();
                object2 = ClassPathUiSupport.addLibraries(this.listModel, this.list.getSelectedIndices(), object3.toArray(new Library[object3.size()]), (Set<Library>)((Object)serializable), this.callback);
                this.list.setSelectedIndices((int[])object2);
            }
        } else if (object == this.edit) {
            ClassPathUiSupport.edit(this.listModel, this.list.getSelectedIndices(), this.helper);
            if (this.list instanceof JListListComponent) {
                ((JListListComponent)this.list).list.repaint();
            } else if (this.list instanceof JTableListComponent) {
                ((JTableListComponent)this.list).table.repaint();
            } else assert (false) : "do not know how to handle " + this.list.getClass().getName();
        } else if (object == this.addAntArtifact) {
            AntArtifactItem[] antArtifactItemArray = AntArtifactChooser.showDialog(this.antArtifactTypes, this.project, this.list.getComponent().getParent());
            if (antArtifactItemArray != null) {
                int[] nArray = ClassPathUiSupport.addArtifacts(this.listModel, this.list.getSelectedIndices(), antArtifactItemArray, this.callback);
                this.list.setSelectedIndices(nArray);
            }
        } else if (object == this.remove) {
            int[] nArray = ClassPathUiSupport.remove(this.listModel, this.list.getSelectedIndices());
            this.list.setSelectedIndices(nArray);
        } else if (object == this.moveUp) {
            int[] nArray = ClassPathUiSupport.moveUp(this.listModel, this.list.getSelectedIndices());
            this.list.setSelectedIndices(nArray);
        } else if (object == this.moveDown) {
            int[] nArray = ClassPathUiSupport.moveDown(this.listModel, this.list.getSelectedIndices());
            this.list.setSelectedIndices(nArray);
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(EditMediator.class);
    }

    public static File getLastUsedClassPathFolder() {
        return new File(EditMediator.getPreferences().get(LAST_USED_CP_FOLDER, System.getProperty("user.home")));
    }

    public static void setLastUsedClassPathFolder(File file) {
        assert (file != null) : "ClassPath root can not be null";
        String string = file.getAbsolutePath();
        EditMediator.getPreferences().put(LAST_USED_CP_FOLDER, string);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = false;
        if (this.selectionModel.getMinSelectionIndex() != -1) {
            bl = true;
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMinSelectionIndex();
            for (int i = n; i <= n2; ++i) {
                ClassPathSupport.Item item;
                if (!this.selectionModel.isSelectedIndex(i) || (item = (ClassPathSupport.Item)this.listModel.get(i)).getType() != 3) continue;
                bl = false;
                break;
            }
        }
        this.edit.setEnabled(ClassPathUiSupport.canEdit(this.selectionModel, this.listModel));
        this.remove.setEnabled(bl);
        this.moveUp.setEnabled(ClassPathUiSupport.canMoveUp(this.selectionModel));
        this.moveDown.setEnabled(ClassPathUiSupport.canMoveDown(this.selectionModel, this.listModel.getSize()));
    }

    public static LibraryChooser.Filter createLibraryFilter() {
        return new LibraryChooser.Filter(){

            public boolean accept(Library library) {
                if ("javascript".equals(library.getType())) {
                    return false;
                }
                try {
                    library.getContent("classpath");
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }
        };
    }

    public static ListComponent createListComponent(JList jList) {
        return new JListListComponent(jList);
    }

    public static ListComponent createListComponent(JTable jTable, DefaultListModel defaultListModel) {
        return new JTableListComponent(jTable, defaultListModel);
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n <= 0 || n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(n + 1).toUpperCase();
            return this.extensions.contains(string2);
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static final class JTableListComponent
    implements ListComponent {
        private JTable table;
        private DefaultListModel model;

        public JTableListComponent(JTable jTable, DefaultListModel defaultListModel) {
            this.table = jTable;
            this.model = defaultListModel;
        }

        public Component getComponent() {
            return this.table;
        }

        public int[] getSelectedIndices() {
            return this.table.getSelectedRows();
        }

        public void setSelectedIndices(int[] nArray) {
            this.table.clearSelection();
            for (int i = 0; i < nArray.length; ++i) {
                this.table.addRowSelectionInterval(nArray[i], nArray[i]);
            }
        }

        public DefaultListModel getModel() {
            return this.model;
        }

        public ListSelectionModel getSelectionModel() {
            return this.table.getSelectionModel();
        }
    }

    private static final class JListListComponent
    implements ListComponent {
        private JList list;

        public JListListComponent(JList jList) {
            this.list = jList;
        }

        public Component getComponent() {
            return this.list;
        }

        public int[] getSelectedIndices() {
            return this.list.getSelectedIndices();
        }

        public void setSelectedIndices(int[] nArray) {
            this.list.setSelectedIndices(nArray);
        }

        public DefaultListModel getModel() {
            return (DefaultListModel)this.list.getModel();
        }

        public ListSelectionModel getSelectionModel() {
            return this.list.getSelectionModel();
        }
    }

    public static interface ListComponent {
        public Component getComponent();

        public int[] getSelectedIndices();

        public void setSelectedIndices(int[] var1);

        public DefaultListModel getModel();

        public ListSelectionModel getSelectionModel();
    }
}

