/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.internetexplorer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.web.client.tools.common.launcher.Launcher;
import org.netbeans.modules.web.client.tools.internetexplorer.Log;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class IEExtensionManager {
    private static final String MS_SCRIPT_DEBUGGER_URI = "http://www.microsoft.com/downloads/details.aspx?FamilyID=2f465be0-94fd-4569-b3c4-dffdf19ccd99";
    private static final String PDM_REGISTRY_KEY = "HKLM\\SOFTWARE\\Classes\\CLSID\\{78a51822-51f4-11d0-8f20-00805f2cd064}";
    private static final String MDM_REGISTRY_KEY = "HKLM\\SOFTWARE\\Classes\\CLSID\\{0C0A3666-30C9-11D0-8F20-00805F2CD064}";
    private static final String BHO_REGISTRY_KEY = "HKLM\\SOFTWARE\\Classes\\CLSID\\{25CE9541-A839-46B4-81C6-1FAE46AD2EDE}";
    private static final String BHO_PROC32_REGISTRY_KEY = "HKLM\\SOFTWARE\\Classes\\CLSID\\{25CE9541-A839-46B4-81C6-1FAE46AD2EDE}\\InprocServer32";
    private static final String REG_EXE = "reg.exe";
    private static final String REG_OPERATION = "query";
    private static final String REG_OPTION = "/ve";
    private static String REGSERVER_EXE = "regsvr32.exe";
    private static String REGSERVER_OPTION = "/s";
    private static final String BHO_RELATIVE_PATH = "native/NetBeansExtension.dll";
    private static final String MODULE_CODEBASE = "org.netbeans.modules.web.client.tools.internetexplorer";

    public static boolean checkRequiredComponents(HtmlBrowser.Factory factory) {
        block6: {
            try {
                while (!IEExtensionManager.queryRegistry(MDM_REGISTRY_KEY) || !IEExtensionManager.queryRegistry(PDM_REGISTRY_KEY)) {
                    IEExtensionManager.launchBrowser(factory, MS_SCRIPT_DEBUGGER_URI);
                    if (IEExtensionManager.displayScriptDebuggerInstallDialog()) continue;
                    return false;
                }
                File file = InstalledFileLocator.getDefault().locate(BHO_RELATIVE_PATH, MODULE_CODEBASE, false);
                String string = file.getCanonicalPath();
                if (!IEExtensionManager.queryForBHO(string)) {
                    if (IEExtensionManager.displayBHORegisterDialog()) {
                        if (IEExtensionManager.registerBHO(string)) {
                            return true;
                        }
                        IEExtensionManager.handleFailedRegistration();
                    }
                    break block6;
                }
                return true;
            }
            catch (IOException iOException) {
                Log.getLogger().log(Level.INFO, iOException.getLocalizedMessage());
            }
        }
        return false;
    }

    private static void handleFailedRegistration() {
        final String string = NbBundle.getMessage(IEExtensionManager.class, (String)"UNABLE_TO_REGISTER");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string2 = System.getProperty("os.name").toLowerCase();
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(string2 != null && string2.contains("vista") ? string + "\n" + NbBundle.getMessage(IEExtensionManager.class, (String)"UNABLE_TO_REGISTER_EXT") : string), 0));
            }
        });
    }

    private static boolean queryForBHO(String string) {
        String string2;
        return IEExtensionManager.queryRegistry(BHO_REGISTRY_KEY) && (string2 = IEExtensionManager.execute(new String[]{REG_EXE, REG_OPERATION, BHO_PROC32_REGISTRY_KEY, REG_OPTION})) != null && string2.contains(string);
    }

    private static boolean queryRegistry(String string) {
        return IEExtensionManager.execute(new String[]{REG_EXE, REG_OPERATION, string, REG_OPTION}) != null;
    }

    private static boolean registerBHO(String string) {
        return IEExtensionManager.execute(new String[]{REGSERVER_EXE, REGSERVER_OPTION, string}) != null;
    }

    private static String execute(String[] stringArray) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            String string = IEExtensionManager.readStream(process.getInputStream());
            if (process.waitFor() == 0) {
                return string;
            }
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.INFO, iOException.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {
            Log.getLogger().log(Level.INFO, interruptedException.getLocalizedMessage());
        }
        return null;
    }

    private static String readStream(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String string;
            do {
                if ((string = bufferedReader.readLine()) == null) continue;
                stringBuffer.append(string);
            } while (string != null);
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.INFO, iOException.getLocalizedMessage());
        }
        return stringBuffer.toString();
    }

    private static boolean displayScriptDebuggerInstallDialog() {
        String string = NbBundle.getMessage(IEExtensionManager.class, (String)"SCRIPT_DEBUGGER_INSTALL_TEXT");
        String string2 = NbBundle.getMessage(IEExtensionManager.class, (String)"SCRIPT_DEBUGGER_INSTALL_TITLE");
        return IEExtensionManager.displayConfirmationDialog(string, string2);
    }

    private static boolean displayBHORegisterDialog() {
        String string = NbBundle.getMessage(IEExtensionManager.class, (String)"BHO_REGISTER_TEXT");
        String string2 = NbBundle.getMessage(IEExtensionManager.class, (String)"BHO_REGISTER_TITLE");
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, string2, 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.OK_OPTION;
    }

    private static boolean displayConfirmationDialog(String string, String string2) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setColumns(65);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(UIManager.getColor("Panel.background"));
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)new JScrollPane(jTextArea), string2, 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.OK_OPTION;
    }

    protected static String getBrowserExecutable(HtmlBrowser.Factory factory) {
        if (factory != null) {
            try {
                Method method = factory.getClass().getMethod("getBrowserExecutable", new Class[0]);
                NbProcessDescriptor nbProcessDescriptor = (NbProcessDescriptor)method.invoke((Object)factory, new Object[0]);
                return nbProcessDescriptor.getProcessName();
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return "firefox";
    }

    private static void launchBrowser(HtmlBrowser.Factory factory, String string) throws IOException {
        Launcher.LaunchDescriptor launchDescriptor = new Launcher.LaunchDescriptor(IEExtensionManager.getBrowserExecutable(factory));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        launchDescriptor.setURI(arrayList);
        Launcher.launch((Launcher.LaunchDescriptor)launchDescriptor);
    }
}

