/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.project.api.Pair;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class URIMapper {
    private static final Logger LOGGER = Logger.getLogger(URIMapper.class.getName());

    URIMapper() {
    }

    abstract File toSourceFile(URI var1);

    abstract URI toWebServerURI(File var1, boolean var2);

    URI toWebServerURI(File file) {
        return this.toWebServerURI(file, true);
    }

    static MultiMapper createMultiMapper(URI uRI, FileObject fileObject, FileObject fileObject2, List<Pair<String, String>> list) {
        MultiMapper multiMapper = new MultiMapper();
        for (Pair<String, String> pair : list) {
            pair = URIMapper.encodedPathMappingPair(pair);
            String string = (String)pair.first;
            String string2 = (String)pair.second;
            if (string.length() <= 0 || string2.length() <= 0) continue;
            if (!string.startsWith("file:")) {
                string = !string.startsWith("/") ? "file:/" + string : "file:" + string;
            }
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            URI uRI2 = URI.create(string);
            File file = new File(string2);
            FileObject fileObject3 = FileUtil.toFileObject((File)file);
            if (fileObject3 == null || !fileObject3.isFolder()) continue;
            URIMapper uRIMapper = URIMapper.createBasedInstance(uRI2, file);
            multiMapper.addAsLastMapper(uRIMapper);
        }
        URIMapper uRIMapper = URIMapper.createDefaultMapper(uRI, fileObject, fileObject2);
        if (uRIMapper != null) {
            multiMapper.addAsLastMapper(uRIMapper);
        }
        multiMapper.addAsLastMapper(URIMapper.createOneToOne());
        return multiMapper;
    }

    static URIMapper createDefaultMapper(URI uRI, FileObject fileObject, FileObject fileObject2) {
        if (!"file".equals(uRI.getScheme())) {
            return null;
        }
        File file = new File(uRI);
        File file2 = FileUtil.toFile((FileObject)fileObject);
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        if (string != null) {
            if (file2.isDirectory() && !(file2 = new File(file2, file.getName())).exists()) {
                LOGGER.fine("No default path mapping: webServerURI: " + uRI.toString() + " sourceFile: " + file2.getAbsolutePath());
                return null;
            }
            if (!file2.equals(file)) {
                File file3 = FileUtil.toFile((FileObject)fileObject2);
                assert (file3 != null);
                URI[] uRIArray = URIMapper.findBases(uRI, file2, file3);
                if (uRIArray != null) {
                    URI uRI2 = uRIArray[0];
                    File file4 = new File(uRIArray[1]);
                    assert (uRI2 != null);
                    assert (file4 != null);
                    return new BaseMapper(uRI2, file4);
                }
            }
        }
        LOGGER.fine("No default path mapping: webServerURI: " + uRI.toString() + " sourceFile: " + file2.getAbsolutePath());
        return null;
    }

    static URIMapper createOneToOne() {
        return new URIMapper(){
            private Map<File, File> can2AbsFile = new HashMap<File, File>();

            File toSourceFile(URI uRI) {
                File file = new File(uRI);
                File file2 = this.can2AbsFile.get(file);
                return file2 != null ? file2 : file;
            }

            URI toWebServerURI(File file, boolean bl) {
                File file2 = null;
                try {
                    file2 = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                if (!file.equals(file2)) {
                    this.can2AbsFile.put(file2, file);
                    file = file2;
                }
                return URIMapper.toURI(file, bl);
            }
        };
    }

    static URIMapper createBasedInstance(URI uRI, File file) {
        return new BaseMapper(uRI, file);
    }

    private static URI[] findBases(URI uRI, File file, File file2) {
        String string2;
        File file3 = file;
        boolean bl = true;
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, uRI.getPath().split("/"));
        Collections.reverse(arrayList);
        for (String string2 : arrayList) {
            if (file3 == null || !string2.equals(file3.getName()) || file3.equals(file2)) break;
            bl = false;
            if (file3.equals(file2)) break;
            file3 = file3.getParentFile();
        }
        if (bl) {
            return null;
        }
        assert (file3.isDirectory());
        int n = uRI.getPath().length() - (file.getAbsolutePath().length() - file3.getAbsolutePath().length());
        string2 = uRI.getPath().substring(0, n);
        URI uRI2 = URIMapper.createURI(uRI.getScheme(), uRI.getHost(), string2, uRI.getFragment(), true, true);
        return new URI[]{uRI2, file3.toURI()};
    }

    private static URI createURI(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        if (bl2 && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        if (string2 == null && bl) {
            string2 = "";
        }
        try {
            return new URI(string, string2, string3, string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
            return null;
        }
    }

    private static URI toURI(File file, boolean bl) {
        URI uRI = file.toURI();
        return URIMapper.createURI(uRI.getScheme(), uRI.getHost(), uRI.getPath(), uRI.getFragment(), bl, file.exists() && file.isDirectory());
    }

    private static Pair<String, String> encodedPathMappingPair(Pair<String, String> pair) {
        String string = (String)pair.first;
        string = string.replace('\\', '/');
        String[] stringArray = string.split("/");
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl = false;
            if (i == 0 && string2.length() == 2 && string2.charAt(1) == ':') {
                bl = true;
            }
            if (!bl) {
                try {
                    string2 = URLEncoder.encode(string2, "UTF-8");
                    string2 = string2.replace("+", "%20");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Exceptions.printStackTrace((Throwable)unsupportedEncodingException);
                }
            }
            stringBuilder.append(string2);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append('/');
        }
        return Pair.of((Object)stringBuilder.toString(), (Object)pair.second);
    }

    static class MultiMapper
    extends URIMapper {
        private LinkedList<URIMapper> mappers = new LinkedList();

        MultiMapper() {
        }

        MultiMapper addAsFirstMapper(URIMapper uRIMapper) {
            this.mappers.addFirst(uRIMapper);
            return this;
        }

        MultiMapper addAsLastMapper(URIMapper uRIMapper) {
            this.mappers.addLast(uRIMapper);
            return this;
        }

        File toSourceFile(URI uRI) {
            if ("file".equals(uRI.getScheme())) {
                for (URIMapper uRIMapper : this.mappers) {
                    File file = uRIMapper.toSourceFile(uRI);
                    if (file == null) continue;
                    return file;
                }
            }
            return null;
        }

        URI toWebServerURI(File file, boolean bl) {
            for (URIMapper uRIMapper : this.mappers) {
                URI uRI = uRIMapper.toWebServerURI(file, bl);
                if (uRI == null) continue;
                return uRI;
            }
            return null;
        }
    }

    private static class BaseMapper
    extends URIMapper {
        private static final String FILE_SCHEME = "file";
        private URI baseWebServerURI;
        private URI baseSourceURI;
        private File baseSourceFolder;

        BaseMapper(URI uRI, File file) {
            if (!file.exists()) {
                throw new IllegalArgumentException();
            }
            if (!file.isDirectory()) {
                throw new IllegalArgumentException();
            }
            this.baseSourceFolder = file;
            this.baseWebServerURI = uRI;
            boolean bl = LOGGER.isLoggable(Level.FINE);
            if (bl) {
                if (!FILE_SCHEME.equals(uRI.getScheme())) {
                    LOGGER.fine("Unexpected scheme: " + uRI.toString());
                }
                if (uRI.getPath() == null) {
                    LOGGER.fine("URI.getPath() == null: " + uRI.toString());
                }
                if (uRI.getPath() == null) {
                    LOGGER.fine("URI.getPath() == null: " + uRI.toString());
                } else if (!uRI.getPath().endsWith("/")) {
                    LOGGER.fine("Not \"/\" at the end of URI.getPath(): " + uRI.toString());
                }
                if (!uRI.isAbsolute()) {
                    LOGGER.fine("URI not absolute: " + uRI.toString());
                }
            }
            assert (FILE_SCHEME.equals(uRI.getScheme()));
            assert (uRI.getPath() != null);
            assert (uRI.getPath().endsWith("/")) : uRI.getPath();
            assert (uRI.isAbsolute());
            this.baseSourceURI = file.toURI();
            assert (this.baseSourceURI.isAbsolute());
        }

        File toSourceFile(URI uRI) {
            URI uRI2 = this.baseWebServerURI.relativize(uRI);
            if (!uRI2.isAbsolute()) {
                assert (FILE_SCHEME.equals(uRI.getScheme()));
                return new File(this.baseSourceURI.resolve(uRI2));
            }
            return null;
        }

        URI toWebServerURI(File file, boolean bl) {
            if (file.equals(this.baseSourceFolder)) {
                return this.baseWebServerURI;
            }
            URI uRI = this.baseSourceURI.relativize(file.toURI());
            if (!uRI.isAbsolute()) {
                URI uRI2 = this.baseWebServerURI.resolve(uRI);
                uRI2 = URIMapper.createURI(uRI2.getScheme(), uRI2.getHost(), uRI2.getPath(), uRI2.getFragment(), true, false);
                return uRI2;
            }
            return null;
        }
    }
}

