/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.Nullable;
import org.netbeans.modules.db.metadata.model.api.SQLType;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCUtils;
import org.netbeans.modules.db.metadata.model.spi.ValueImplementation;

public class JDBCValue
extends ValueImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCValue.class.getName());
    private final String name;
    private final SQLType type;
    private final int length;
    private final int precision;
    private final short radix;
    private final short scale;
    private final Nullable nullable;

    public static JDBCValue createProcedureValue(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("COLUMN_NAME");
        SQLType sQLType = JDBCUtils.getSQLType(resultSet.getInt("DATA_TYPE"));
        int n = resultSet.getInt("LENGTH");
        int n2 = resultSet.getInt("PRECISION");
        short s = resultSet.getShort("SCALE");
        short s2 = resultSet.getShort("RADIX");
        Nullable nullable = JDBCUtils.getProcedureNullable(resultSet.getShort("NULLABLE"));
        return new JDBCValue(string, sQLType, n, n2, s2, s, nullable);
    }

    public static JDBCValue createTableColumnValue(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("COLUMN_NAME");
        SQLType sQLType = JDBCUtils.getSQLType(resultSet.getInt("DATA_TYPE"));
        int n = 0;
        int n2 = 0;
        if (JDBCUtils.isCharType(sQLType)) {
            n = resultSet.getInt("COLUMN_SIZE");
        } else {
            n2 = resultSet.getInt("COLUMN_SIZE");
        }
        short s = resultSet.getShort("DECIMAL_DIGITS");
        short s2 = resultSet.getShort("NUM_PREC_RADIX");
        Nullable nullable = JDBCUtils.getColumnNullable(resultSet.getShort("NULLABLE"));
        return new JDBCValue(string, sQLType, n, n2, s2, s, nullable);
    }

    public JDBCValue(String string, SQLType sQLType, int n, int n2, short s, short s2, Nullable nullable) {
        this.name = string;
        this.type = sQLType;
        this.length = n;
        this.precision = n2;
        this.radix = s;
        this.scale = s2;
        this.nullable = nullable;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public Nullable getNullable() {
        return this.nullable;
    }

    public int getPrecision() {
        return this.precision;
    }

    public short getRadix() {
        return this.radix;
    }

    public short getScale() {
        return this.scale;
    }

    public SQLType getType() {
        return this.type;
    }

    public String toString() {
        return "name=" + this.name + ", type=" + (Object)((Object)this.type) + ", length=" + this.getLength() + ", precision=" + this.getPrecision() + ", radix=" + this.getRadix() + ", scale=" + this.getScale() + ", nullable=" + (Object)((Object)this.nullable);
    }

    public MetadataElement getParent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

