/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.jaxws.impl;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.security.impl.policyconv.SCTokenWrapper;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.secconv.WSSCVersion;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.impl.PolicyResolver;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.jaxws.impl.PipeConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyResolverImpl
implements PolicyResolver {
    private WSDLBoundOperation cachedOperation = null;
    private HashMap<WSDLBoundOperation, SecurityPolicyHolder> inMessagePolicyMap = null;
    private HashMap<String, SecurityPolicyHolder> inProtocolPM = null;
    private AddressingVersion addVer = null;
    private RmVersion rmVer = null;
    private PipeConfiguration pipeConfig = null;
    private boolean isClient = false;
    private boolean isSCMessage = false;
    private String action = "";
    private WSTrustVersion wstVer = WSTrustVersion.WS_TRUST_10;
    private WSSCVersion wsscVer = WSSCVersion.WSSC_10;

    public PolicyResolverImpl(HashMap<WSDLBoundOperation, SecurityPolicyHolder> inMessagePolicyMap, HashMap<String, SecurityPolicyHolder> ip, WSDLBoundOperation cachedOperation, PipeConfiguration pipeConfig, AddressingVersion addVer, boolean isClient, RmVersion rmVer) {
        this.inMessagePolicyMap = inMessagePolicyMap;
        this.inProtocolPM = ip;
        this.cachedOperation = cachedOperation;
        this.pipeConfig = pipeConfig;
        this.addVer = addVer;
        this.isClient = isClient;
        this.rmVer = rmVer;
    }

    @Override
    public MessagePolicy resolvePolicy(ProcessingContext ctx) {
        Message msg = null;
        SOAPMessage soapMsg = null;
        if (ctx instanceof JAXBFilterProcessingContext) {
            msg = ((JAXBFilterProcessingContext)ctx).getJAXWSMessage();
        } else {
            soapMsg = ctx.getSOAPMessage();
            msg = Messages.create(soapMsg);
        }
        if (((ProcessingContextImpl)ctx).getSecurityPolicyVersion().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri)) {
            this.wstVer = WSTrustVersion.WS_TRUST_13;
            this.wsscVer = WSSCVersion.WSSC_13;
        }
        MessagePolicy mp = null;
        this.action = this.getAction(msg);
        if (this.isRMMessage()) {
            SecurityPolicyHolder holder = this.inProtocolPM.get("RM");
            return holder.getMessagePolicy();
        }
        if (this.isSCCancel()) {
            SecurityPolicyHolder holder = this.inProtocolPM.get("SC");
            if (WSSCVersion.WSSC_13.getNamespaceURI().equals(this.wsscVer.getNamespaceURI())) {
                holder = this.inProtocolPM.get("RM");
            }
            return holder.getMessagePolicy();
        }
        this.isSCMessage = this.isSCMessage();
        if (this.isSCMessage) {
            Token scToken = (Token)((Object)this.getInBoundSCP());
            return this.getInboundXWSBootstrapPolicy(scToken);
        }
        if (msg.isFault()) {
            if (soapMsg == null) {
                try {
                    soapMsg = msg.readAsSOAPMessage();
                }
                catch (SOAPException ex) {
                    // empty catch block
                }
            }
            mp = this.getInboundFaultPolicy(soapMsg);
        } else {
            mp = this.getInboundXWSSecurityPolicy(msg);
        }
        if (mp == null) {
            return new MessagePolicy();
        }
        return mp;
    }

    protected PolicyAssertion getInBoundSCP() {
        SecurityPolicyHolder sph = null;
        Collection<SecurityPolicyHolder> coll = this.inMessagePolicyMap.values();
        for (SecurityPolicyHolder ph : coll) {
            if (ph == null) continue;
            sph = ph;
            break;
        }
        if (sph == null) {
            return null;
        }
        List<PolicyAssertion> policies = sph.getSecureConversationTokens();
        if (!policies.isEmpty()) {
            return policies.get(0);
        }
        return null;
    }

    private MessagePolicy getInboundXWSSecurityPolicy(Message msg) {
        MessagePolicy mp = null;
        WSDLBoundOperation operation = null;
        if (this.cachedOperation != null) {
            operation = this.cachedOperation;
        } else {
            operation = msg.getOperation(this.pipeConfig.getWSDLPort());
            if (operation == null) {
                operation = this.getWSDLOpFromAction();
            }
        }
        SecurityPolicyHolder sph = this.inMessagePolicyMap.get(operation);
        if (sph == null && (this.isTrustMessage() || this.isSCMessage)) {
            operation = this.getWSDLOpFromAction();
            sph = this.inMessagePolicyMap.get(operation);
        }
        if (sph == null) {
            return null;
        }
        mp = sph.getMessagePolicy();
        return mp;
    }

    private MessagePolicy getInboundFaultPolicy(SOAPMessage msg) {
        if (this.cachedOperation != null) {
            WSDLOperation operation = this.cachedOperation.getOperation();
            try {
                SOAPBody body = msg.getSOAPBody();
                NodeList nodes = body.getElementsByTagName("detail");
                if (nodes.getLength() == 0) {
                    nodes = body.getElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Detail");
                }
                if (nodes.getLength() > 0) {
                    Node node = nodes.item(0);
                    Node faultNode = node.getFirstChild();
                    if (faultNode == null) {
                        return new MessagePolicy();
                    }
                    String uri = faultNode.getNamespaceURI();
                    QName faultDetail = null;
                    faultDetail = uri != null && uri.length() > 0 ? new QName(faultNode.getNamespaceURI(), faultNode.getNodeName()) : new QName(faultNode.getNodeName());
                    WSDLFault fault = operation.getFault(faultDetail);
                    SecurityPolicyHolder sph = this.inMessagePolicyMap.get(this.cachedOperation);
                    SecurityPolicyHolder faultPolicyHolder = sph.getFaultPolicy(fault);
                    MessagePolicy faultPolicy = faultPolicyHolder == null ? new MessagePolicy() : faultPolicyHolder.getMessagePolicy();
                    return faultPolicy;
                }
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
        return new MessagePolicy();
    }

    private boolean isTrustMessage() {
        return this.wstVer.getIssueRequestAction().equals(this.action) || this.wstVer.getIssueResponseAction().equals(this.action);
    }

    private boolean isRMMessage() {
        return this.rmVer.isRmAction(this.action);
    }

    private String getAction(Message msg) {
        if (this.addVer != null) {
            HeaderList hl = msg.getHeaders();
            String retVal = hl.getAction(this.addVer, this.pipeConfig.getBinding().getSOAPVersion());
            return retVal;
        }
        return "";
    }

    private MessagePolicy getInboundXWSBootstrapPolicy(Token scAssertion) {
        return ((SCTokenWrapper)scAssertion).getMessagePolicy();
    }

    private boolean isSCMessage() {
        return this.wsscVer.getSCTRequestAction().equals(this.action) || this.wsscVer.getSCTResponseAction().equals(this.action) || this.wsscVer.getSCTRenewRequestAction().equals(this.action) || this.wsscVer.getSCTRenewResponseAction().equals(this.action);
    }

    private boolean isSCCancel() {
        return this.wsscVer.getSCTCancelResponseAction().equals(this.action) || this.wsscVer.getSCTCancelRequestAction().equals(this.action);
    }

    private String getAction(WSDLOperation operation) {
        if (!this.isClient) {
            return operation.getInput().getAction();
        }
        return operation.getOutput().getAction();
    }

    private WSDLBoundOperation getWSDLOpFromAction() {
        Set<WSDLBoundOperation> keys = this.inMessagePolicyMap.keySet();
        for (WSDLBoundOperation wbo : keys) {
            WSDLOperation wo = wbo.getOperation();
            String confAction = this.getAction(wo);
            if (confAction == null || !confAction.equals(this.action)) continue;
            return wbo;
        }
        return null;
    }
}

