/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.dsig;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.core.SecurityToken;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.X509SecurityToken;
import com.sun.xml.wss.core.reference.DirectReference;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.core.reference.X509IssuerSerial;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.core.reference.X509ThumbPrintIdentifier;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.dsig.AttachmentData;
import com.sun.xml.wss.impl.dsig.WSSPolicyConsumerImpl;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.AssertionUtil;
import com.sun.xml.wss.saml.util.SAMLUtil;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DSigResolver
implements URIDereferencer {
    private static volatile DSigResolver resolver = null;
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");
    private String optNSClassName = "org.jcp.xml.dsig.internal.dom.DOMSubTreeData";
    private Class _nodeSetClass = null;
    private Constructor _constructor = null;
    private Boolean _false = false;

    private DSigResolver() {
        try {
            this._nodeSetClass = Class.forName(this.optNSClassName);
            this._constructor = this._nodeSetClass.getConstructor(Node.class, Boolean.TYPE);
        }
        catch (LinkageError le) {
            logger.log(Level.FINE, "Not able load JSR 105 RI specific NodeSetData class ", le);
        }
        catch (ClassNotFoundException cne) {
            logger.log(Level.FINE, "Not able load JSR 105 RI specific NodeSetData class ", cne);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static URIDereferencer getInstance() {
        if (resolver == null) {
            DSigResolver.init();
        }
        return resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (resolver != null) return;
        Class<DSigResolver> clazz = DSigResolver.class;
        synchronized (DSigResolver.class) {
            if (resolver != null) return;
            resolver = new DSigResolver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public Data dereference(URIReference uriRef, XMLCryptoContext context) throws URIReferenceException {
        block6: {
            String uri = null;
            try {
                if (uriRef instanceof DOMURIReference) {
                    DOMURIReference domRef = (DOMURIReference)uriRef;
                    Node node = domRef.getHere();
                    if (node.getNodeType() == 2) {
                        uri = uriRef.getURI();
                        return this.dereferenceURI(uri, context);
                    }
                    if (node.getNodeType() == 1 && "SecurityTokenReference".equals(node.getLocalName())) {
                        return this.derefSecurityTokenReference(node, context);
                    }
                    break block6;
                }
                uri = uriRef.getURI();
                return this.dereferenceURI(uri, context);
            }
            catch (XWSSecurityException ex) {
                if (logger.getLevel() == Level.FINEST) {
                    logger.log(Level.FINEST, "Error occurred while resolving" + uri, ex);
                }
                throw new URIReferenceException(ex.getMessage());
            }
        }
        return null;
    }

    Data dereferenceURI(String uri, XMLCryptoContext context) throws URIReferenceException, XWSSecurityException {
        FilterProcessingContext filterContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
        SecurableSoapMessage secureMsg = filterContext.getSecurableSoapMessage();
        if (uri == null || uri.equals("")) {
            SOAPMessage msg = filterContext.getSOAPMessage();
            SOAPPart doc = msg.getSOAPPart();
            if (this._constructor == null) {
                return this.convertToData((Node)doc, true);
            }
            try {
                return (Data)this._constructor.newInstance(doc, this._false);
            }
            catch (Exception ex) {
                return this.convertToData((Node)doc, true);
            }
        }
        if (uri.charAt(0) == '#') {
            return this.dereferenceFragment(SecurableSoapMessage.getIdFromFragmentRef(uri), context);
        }
        if (uri.startsWith("cid:") || uri.startsWith("attachmentRef:")) {
            return this.dereferenceAttachments(uri, context);
        }
        if (uri.startsWith("http")) {
            return this.dereferenceExternalResource(uri, context);
        }
        return this.dereferenceFragment(uri, context);
    }

    Data dereferenceExternalResource(final String uri, XMLCryptoContext context) throws URIReferenceException, XWSSecurityException {
        URIDereferencer resolver = WSSPolicyConsumerImpl.getInstance().getDefaultResolver();
        DOMURIReference uriRef = null;
        FilterProcessingContext filterContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
        SecurableSoapMessage secureMsg = filterContext.getSecurableSoapMessage();
        final Attr uriAttr = secureMsg.getSOAPMessage().getSOAPPart().createAttribute("uri");
        uriAttr.setNodeValue(uri);
        uriRef = new DOMURIReference(){

            public String getURI() {
                return uri;
            }

            public String getType() {
                return null;
            }

            public Node getHere() {
                return uriAttr;
            }
        };
        try {
            Data data = resolver.dereference(uriRef, context);
            return data;
        }
        catch (URIReferenceException ue) {
            logger.log(Level.SEVERE, "WSS1325.dsig.externaltarget", uri);
            throw ue;
        }
    }

    Data dereferenceAttachments(String uri, XMLCryptoContext context) throws URIReferenceException, XWSSecurityException {
        boolean sunAttachmentTransformProvider = true;
        FilterProcessingContext filterContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
        SecurableSoapMessage secureMsg = filterContext.getSecurableSoapMessage();
        AttachmentPart attachment = secureMsg.getAttachmentPart(uri);
        if (attachment == null) {
            throw new URIReferenceException("Attachment Resource with Identifier  " + uri + " was not found");
        }
        if (sunAttachmentTransformProvider) {
            AttachmentData attachData = new AttachmentData();
            attachData.setAttachmentPart(attachment);
            return attachData;
        }
        throw new UnsupportedOperationException("Not yet supported ");
    }

    Data dereferenceFragment(String uri, XMLCryptoContext context) throws URIReferenceException, XWSSecurityException {
        Object obj;
        FilterProcessingContext filterContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
        HashMap elementCache = filterContext.getElementCache();
        if (elementCache.size() > 0 && (obj = elementCache.get(uri)) != null) {
            if (this._constructor == null) {
                return this.convertToData((Element)obj, true);
            }
            try {
                return (Data)this._constructor.newInstance(obj, this._false);
            }
            catch (Exception ex) {
                return this.convertToData((Element)obj, true);
            }
        }
        SecurableSoapMessage secureMsg = filterContext.getSecurableSoapMessage();
        Element element = secureMsg.getElementById(uri);
        if (element == null) {
            throw new URIReferenceException("Resource with fragment Identifier  " + uri + " was not found");
        }
        if (this._constructor == null) {
            return this.convertToData(element, true);
        }
        try {
            return (Data)this._constructor.newInstance(element, this._false);
        }
        catch (Exception ex) {
            return this.convertToData(element, true);
        }
    }

    Data convertToData(final Node node, boolean xpathNodeSet) {
        final HashSet nodeSet = new HashSet();
        if (xpathNodeSet) {
            this.toNodeSet(node, nodeSet);
            return new NodeSetData(){

                public Iterator iterator() {
                    return nodeSet.iterator();
                }
            };
        }
        return new NodeSetData(){

            public Iterator iterator() {
                return Collections.singletonList(node).iterator();
            }
        };
    }

    void toNodeSet(Node rootNode, Set result) {
        if (rootNode == null) {
            return;
        }
        switch (rootNode.getNodeType()) {
            case 1: {
                result.add(rootNode);
                Element el = (Element)rootNode;
                if (el.hasAttributes()) {
                    NamedNodeMap nl = ((Element)rootNode).getAttributes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        result.add(nl.item(i));
                    }
                }
            }
            case 9: {
                for (Node r = rootNode.getFirstChild(); r != null; r = r.getNextSibling()) {
                    if (r.getNodeType() == 3) {
                        result.add(r);
                        while (r != null && r.getNodeType() == 3) {
                            r = r.getNextSibling();
                        }
                        if (r == null) {
                            return;
                        }
                    }
                    this.toNodeSet(r, result);
                }
                return;
            }
            case 8: {
                return;
            }
            case 10: {
                return;
            }
        }
        result.add(rootNode);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Data derefSecurityTokenReference(Node element, XMLCryptoContext context) throws XWSSecurityException, URIReferenceException {
        Element newElement;
        block29: {
            HashMap tokenCache;
            ReferenceElement refElement;
            SOAPPart soapDocument;
            FilterProcessingContext filterContext;
            SecurityToken secToken;
            block30: {
                String keyId;
                String valueType;
                SecurityTokenReference tokenRef;
                SecurableSoapMessage secureMessage;
                block31: {
                    block28: {
                        void var11_14;
                        secToken = null;
                        filterContext = (FilterProcessingContext)context.get("http://wss.sun.com#processingContext");
                        secureMessage = filterContext.getSecurableSoapMessage();
                        soapDocument = secureMessage.getSOAPPart();
                        SOAPElement soapElem = XMLUtil.convertToSoapElement((Document)soapDocument, (Element)element);
                        tokenRef = new SecurityTokenReference(soapElem);
                        refElement = tokenRef.getReference();
                        tokenCache = filterContext.getTokenCache();
                        Object var11_11 = null;
                        newElement = null;
                        if (!(refElement instanceof DirectReference)) break block28;
                        String uri = ((DirectReference)refElement).getURI();
                        String tokenId = uri.substring(1);
                        secToken = (SecurityToken)tokenCache.get(tokenId);
                        if (secToken == null) {
                            Element element2 = secureMessage.getElementById(tokenId);
                            if (element2 == null) {
                                throw new URIReferenceException("Could not locate token with following ID" + tokenId);
                            }
                        } else {
                            SOAPElement sOAPElement = secToken.getAsSoapElement();
                        }
                        newElement = (Element)element.getOwnerDocument().importNode((Node)var11_14, true);
                        break block29;
                    }
                    if (!(refElement instanceof KeyIdentifier)) break block30;
                    valueType = ((KeyIdentifier)refElement).getValueType();
                    keyId = ((KeyIdentifier)refElement).getReferenceValue();
                    if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(valueType) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3SubjectKeyIdentifier".equals(valueType)) {
                        X509Certificate cert = null;
                        Object token = tokenCache.get(keyId);
                        if (token instanceof X509SubjectKeyIdentifier && token != null) {
                            cert = ((X509SubjectKeyIdentifier)token).getCertificate();
                        }
                        if (cert == null) {
                            cert = filterContext.getSecurityEnvironment().getCertificate(filterContext.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(keyId));
                        }
                        secToken = new X509SecurityToken((Document)soapDocument, cert);
                        SOAPElement sOAPElement = secToken.getAsSoapElement();
                        newElement = sOAPElement;
                        try {
                            newElement.removeAttribute("EncodingType");
                        }
                        catch (DOMException de) {
                            throw new XWSSecurityRuntimeException(de.getMessage(), de);
                        }
                    }
                    if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(valueType)) {
                        X509Certificate cert = null;
                        Object token = tokenCache.get(keyId);
                        if (token instanceof X509ThumbPrintIdentifier && token != null) {
                            cert = ((X509ThumbPrintIdentifier)token).getCertificate();
                        }
                        if (cert == null) {
                            cert = filterContext.getSecurityEnvironment().getCertificate(filterContext.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(keyId), "Thumbprint");
                        }
                        secToken = new X509SecurityToken((Document)soapDocument, cert);
                        SOAPElement sOAPElement = secToken.getAsSoapElement();
                        newElement = sOAPElement;
                        try {
                            newElement.removeAttribute("EncodingType");
                        }
                        catch (DOMException de) {
                            throw new XWSSecurityRuntimeException(de.getMessage(), de);
                        }
                    }
                    if (!"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(valueType)) break block31;
                    newElement = null;
                    break block29;
                }
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType)) {
                    void var11_19;
                    if (tokenRef.getSamlAuthorityBinding() != null) {
                        Element element3 = filterContext.getSecurityEnvironment().locateSAMLAssertion(filterContext.getExtraneousProperties(), tokenRef.getSamlAuthorityBinding(), keyId, (Document)secureMessage.getSOAPPart());
                    } else {
                        Element element4 = SAMLUtil.locateSamlAssertion(keyId, (Document)secureMessage.getSOAPPart());
                    }
                    newElement = (Element)element.getOwnerDocument().importNode((Node)var11_19, true);
                    Assertion assertion = null;
                    try {
                        assertion = AssertionUtil.fromElement((Element)var11_19);
                    }
                    catch (Exception e) {
                        throw new XWSSecurityException(e);
                    }
                    tokenCache.put(keyId, assertion);
                    break block29;
                } else {
                    void var11_21;
                    try {
                        Element element5 = DSigResolver.resolveSAMLToken(tokenRef, keyId, filterContext);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (var11_21 == null) {
                        XWSSecurityException xwsse = new XWSSecurityException("WSS_DSIG0008:unsupported KeyIdentifier Reference Type " + valueType);
                        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
                    }
                    newElement = (Element)element.getOwnerDocument().importNode((Node)var11_21, true);
                }
                break block29;
            }
            if (!(refElement instanceof X509IssuerSerial)) {
                throw new XWSSecurityException("Cannot handle reference mechanism: " + refElement.getTagName());
            }
            BigInteger serialNumber = ((X509IssuerSerial)refElement).getSerialNumber();
            String issuerName = ((X509IssuerSerial)refElement).getIssuerName();
            X509Certificate cert = null;
            Object token = tokenCache.get(issuerName + serialNumber);
            if (token instanceof X509IssuerSerial) {
                cert = ((X509IssuerSerial)token).getCertificate();
            }
            if (cert == null) {
                cert = filterContext.getSecurityEnvironment().getCertificate(filterContext.getExtraneousProperties(), serialNumber, issuerName);
            }
            secToken = new X509SecurityToken((Document)soapDocument, cert);
            SOAPElement sOAPElement = secToken.getAsSoapElement();
            newElement = sOAPElement;
            try {
                newElement.removeAttribute("EncodingType");
            }
            catch (DOMException de) {
                throw new XWSSecurityException(de.getMessage(), de);
            }
        }
        Attr attr = element.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        attr.setValue("");
        if (newElement != null) {
            newElement.setAttributeNodeNS(attr);
        }
        return this.convertToData(newElement, false);
    }

    private static Element resolveSAMLToken(SecurityTokenReference tokenRef, String assertionId, FilterProcessingContext context) throws XWSSecurityException {
        Assertion ret = (Assertion)context.getTokenCache().get(assertionId);
        if (ret != null) {
            try {
                return SAMLUtil.toElement((Node)context.getSecurableSoapMessage().getSOAPPart(), ret);
            }
            catch (Exception e) {
                throw new XWSSecurityException(e);
            }
        }
        Element tokenElement = null;
        tokenElement = tokenRef.getSamlAuthorityBinding() != null ? context.getSecurityEnvironment().locateSAMLAssertion(context.getExtraneousProperties(), tokenRef.getSamlAuthorityBinding(), assertionId, (Document)context.getSOAPMessage().getSOAPPart()) : SAMLUtil.locateSamlAssertion(assertionId, (Document)context.getSOAPMessage().getSOAPPart());
        try {
            ret = AssertionUtil.fromElement(tokenElement);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        context.getTokenCache().put(assertionId, ret);
        return tokenElement;
    }
}

