/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.sequence;

import com.sun.xml.ws.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rm.runtime.sequence.InboundSequence;
import com.sun.xml.ws.rm.runtime.sequence.OutboundSequence;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rm.runtime.sequence.UnknownSequenceException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class DefaultInMemorySequenceManager
implements SequenceManager {
    private final ReadWriteLock internalDataAccessLock = new ReentrantReadWriteLock();
    private final Map<String, AbstractSequence> sequences = new HashMap<String, AbstractSequence>();
    private final Map<String, String> boundSequences = new HashMap<String, String>();

    DefaultInMemorySequenceManager() {
    }

    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        try {
            this.internalDataAccessLock.readLock().lock();
            if (this.sequences.containsKey(sequenceId)) {
                Sequence sequence = this.sequences.get(sequenceId);
                return sequence;
            }
            throw new UnknownSequenceException(sequenceId);
        }
        finally {
            this.internalDataAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(String sequenceId) {
        try {
            this.internalDataAccessLock.readLock().lock();
            boolean bl = this.sequences.containsKey(sequenceId);
            return bl;
        }
        finally {
            this.internalDataAccessLock.readLock().unlock();
        }
    }

    public Sequence createOutboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        return this.registerSequence(new OutboundSequence(sequenceId, strId, expirationTime));
    }

    public Sequence createInboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        return this.registerSequence(new InboundSequence(sequenceId, strId, expirationTime));
    }

    public String generateSequenceUID() {
        return "uuid:" + UUID.randomUUID();
    }

    public void closeSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        sequence.close();
    }

    public Sequence terminateSequence(String sequenceId) throws UnknownSequenceException {
        try {
            this.internalDataAccessLock.writeLock().lock();
            if (this.sequences.containsKey(sequenceId)) {
                AbstractSequence sequence = this.sequences.remove(sequenceId);
                sequence.setStatus(Sequence.Status.TERMINATING);
                if (this.boundSequences.containsKey(sequenceId)) {
                    this.boundSequences.remove(sequenceId);
                }
                sequence.preDestroy();
                AbstractSequence abstractSequence = sequence;
                return abstractSequence;
            }
            throw new UnknownSequenceException(sequenceId);
        }
        finally {
            this.internalDataAccessLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence registerSequence(AbstractSequence sequence) throws DuplicateSequenceException {
        try {
            this.internalDataAccessLock.writeLock().lock();
            if (this.sequences.containsKey(sequence.getId())) {
                throw new DuplicateSequenceException(sequence.getId());
            }
            this.sequences.put(sequence.getId(), sequence);
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.internalDataAccessLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindSequences(String referenceSequenceId, String boundSequenceId) throws UnknownSequenceException {
        try {
            this.internalDataAccessLock.writeLock().lock();
            if (!this.sequences.containsKey(referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            if (!this.sequences.containsKey(boundSequenceId)) {
                throw new UnknownSequenceException(boundSequenceId);
            }
            this.boundSequences.put(referenceSequenceId, boundSequenceId);
        }
        finally {
            this.internalDataAccessLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence getBoundSequence(String referenceSequenceId) throws UnknownSequenceException {
        try {
            this.internalDataAccessLock.readLock().lock();
            if (!this.isValid(referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            if (this.boundSequences.containsKey(referenceSequenceId)) {
                Sequence sequence = this.sequences.get(this.boundSequences.get(referenceSequenceId));
                return sequence;
            }
            Sequence sequence = null;
            return sequence;
        }
        finally {
            this.internalDataAccessLock.readLock().unlock();
        }
    }
}

