/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ScheduledTaskManager {
    private static final long DELAY = 2000L;
    private static final long PERIOD = 2000L;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final Queue<ScheduledFuture<?>> scheduledTaskHandles = new ConcurrentLinkedQueue();

    ScheduledTaskManager() {
    }

    List<ScheduledFuture<?>> startTasks(Runnable ... tasks) {
        ArrayList handles = new ArrayList(tasks.length);
        for (Runnable task : tasks) {
            handles.add(this.startTask(task));
        }
        return handles;
    }

    void stopAll() {
        ScheduledFuture<?> handle;
        while ((handle = this.scheduledTaskHandles.poll()) != null) {
            handle.cancel(false);
        }
        this.scheduler.shutdown();
    }

    ScheduledFuture<?> startTask(Runnable task) {
        ScheduledFuture<?> taskHandle = this.scheduler.scheduleAtFixedRate(task, 2000L, 2000L, TimeUnit.MILLISECONDS);
        if (!this.scheduledTaskHandles.offer(taskHandle)) {
            // empty if block
        }
        return taskHandle;
    }
}

