/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rm.RmRuntimeException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.runtime.Rm10PacketAdapter;
import com.sun.xml.ws.rm.runtime.Rm11PacketAdapter;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PacketAdapter {
    private static final RmLogger LOGGER = RmLogger.getLogger(PacketAdapter.class);
    Message message;
    private Packet packet;
    private boolean isSequenceDataInit;
    private boolean isAckRequestedHeaderDataInit;
    private String sequenceId;
    private String ackRequestedHeaderSequenceId;
    private long messageNumber;
    private boolean messageConsumed;
    private final Configuration configuration;
    private final RmVersion rmVersion;
    private final SOAPVersion soapVersion;
    private final AddressingVersion addressingVersion;
    private final Unmarshaller jaxbUnmarshaller;

    public static PacketAdapter getInstance(@NotNull Configuration configuration, @NotNull Packet packet) {
        switch (configuration.getRmVersion()) {
            case WSRM10: {
                return new Rm10PacketAdapter(configuration, packet);
            }
            case WSRM11: {
                return new Rm11PacketAdapter(configuration, packet);
            }
        }
        throw new IllegalStateException(LocalizationMessages.WSRM_1104_RM_VERSION_NOT_SUPPORTED(configuration.getRmVersion().namespaceUri));
    }

    PacketAdapter(@NotNull Configuration configuration, @NotNull Packet packet) {
        this.configuration = configuration;
        this.rmVersion = configuration.getRmVersion();
        this.soapVersion = configuration.getSoapVersion();
        this.addressingVersion = configuration.getAddressingVersion();
        this.jaxbUnmarshaller = this.rmVersion.createUnmarshaller(this.addressingVersion);
        this.insertPacket(packet);
    }

    private final void insertPacket(Packet packet) {
        this.packet = packet;
        if (packet.getMessage() != null) {
            this.message = packet.getMessage();
        }
    }

    public final void consume() {
        if (this.message != null && !this.messageConsumed) {
            this.messageConsumed = true;
            this.message.consume();
        }
    }

    public final Packet getPacket() {
        return this.packet;
    }

    public final Packet copyPacket(boolean copyMessage) {
        return this.packet.copy(copyMessage);
    }

    public final PacketAdapter createServerResponse(Object jaxbElement, String wsaAction) {
        return PacketAdapter.getInstance(this.configuration, this.packet.createServerResponse(Messages.create(this.rmVersion.getJaxbContext(this.addressingVersion), jaxbElement, this.soapVersion), this.addressingVersion, this.soapVersion, wsaAction));
    }

    public final PacketAdapter createEmptyServerResponse(String wsaAction) {
        return PacketAdapter.getInstance(this.configuration, this.packet.createServerResponse(Messages.createEmpty(this.soapVersion), this.addressingVersion, this.soapVersion, wsaAction));
    }

    public final PacketAdapter createAckResponse(Sequence sequence, String wsaAction) throws RmRuntimeException {
        PacketAdapter responseAdapter = this.createEmptyServerResponse(wsaAction);
        responseAdapter.appendSequenceAcknowledgementHeader(sequence);
        return responseAdapter;
    }

    public final PacketAdapter closeTransportAndReturnNull() {
        this.packet.transportBackChannel.close();
        Packet emptyReturnPacket = new Packet();
        emptyReturnPacket.invocationProperties.putAll(this.packet.invocationProperties);
        return PacketAdapter.getInstance(this.configuration, emptyReturnPacket);
    }

    public final void appendHeader(Object jaxbHeaderContent) throws IllegalStateException {
        this.checkMessageReadyState();
        this.message.getHeaders().add(Headers.create(this.rmVersion.getJaxbContext(this.addressingVersion), jaxbHeaderContent));
    }

    public abstract void appendSequenceHeader(@NotNull String var1, long var2) throws RmRuntimeException;

    public abstract void appendAckRequestedHeader(@NotNull String var1) throws RmRuntimeException;

    public abstract void appendSequenceAcknowledgementHeader(@NotNull Sequence var1) throws RmRuntimeException;

    public final PacketAdapter keepTransportBackChannelOpen() {
        this.packet.keepTransportBackChannelOpen();
        return this;
    }

    public final PacketAdapter setEmptyRequestMessage(String wsaAction) {
        return this.setRequestMessage(Messages.createEmpty(this.soapVersion), wsaAction);
    }

    public final PacketAdapter setEmptyResponseMessage(PacketAdapter requestAdapter, String wsaAction) {
        this.checkPacketReadyState();
        this.message = Messages.createEmpty(this.soapVersion);
        this.packet.setResponseMessage(requestAdapter.packet, this.message, this.addressingVersion, this.soapVersion, wsaAction);
        return this;
    }

    public final PacketAdapter setRequestMessage(Object jaxbElement, String wsaAction) {
        return this.setRequestMessage(Messages.create(this.rmVersion.getJaxbContext(this.addressingVersion), jaxbElement, this.soapVersion), wsaAction);
    }

    private final PacketAdapter setRequestMessage(Message newMessage, String wsaAction) {
        this.checkPacketReadyState();
        this.message = newMessage;
        this.packet.setMessage(this.message);
        this.message.assertOneWay(false);
        this.message.getHeaders().fillRequestAddressingHeaders(this.packet, this.addressingVersion, this.soapVersion, false, wsaAction);
        return this;
    }

    public final boolean isProtocolMessage() {
        return this.message == null ? false : this.rmVersion.isRmAction(this.getWsaAction());
    }

    public final boolean isProtocolRequest() {
        return this.message == null ? false : this.rmVersion.isRmProtocolRequest(this.getWsaAction());
    }

    public final boolean isProtocolResponse() {
        return this.message == null ? false : this.rmVersion.isRmProtocolResponse(this.getWsaAction());
    }

    public final boolean isRmFault() {
        return this.message == null ? false : this.rmVersion.isRmFault(this.getWsaAction());
    }

    public final boolean isFault() {
        return this.message == null ? false : this.message.isFault();
    }

    public final boolean containsMessage() {
        return this.message != null;
    }

    public final String getWsaAction() {
        this.checkMessageReadyState();
        return this.message.getHeaders().getAction(this.addressingVersion, this.soapVersion);
    }

    public final String getDestination() {
        this.checkMessageReadyState();
        return this.message.getHeaders().getTo(this.addressingVersion, this.soapVersion);
    }

    public final <T> T readHeaderAsUnderstood(String name) throws RmRuntimeException {
        this.checkMessageReadyState();
        Header header = this.message.getHeaders().get(this.rmVersion.namespaceUri, name, true);
        if (header == null) {
            return null;
        }
        try {
            Object result = header.readAsJAXB(this.jaxbUnmarshaller);
            return result;
        }
        catch (JAXBException ex) {
            throw LOGGER.logSevereException(new RmRuntimeException(LocalizationMessages.WSRM_1122_ERROR_MARSHALLING_RM_HEADER(this.rmVersion.namespaceUri + "#" + name), ex));
        }
    }

    public final <T> T unmarshallMessage() throws RmRuntimeException {
        this.checkMessageReadyState();
        try {
            Object result;
            Object t = result = this.message.readPayloadAsJAXB(this.jaxbUnmarshaller);
            return t;
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmRuntimeException(LocalizationMessages.WSRM_1123_ERROR_UNMARSHALLING_MESSAGE(), e));
        }
        finally {
            this.messageConsumed = true;
        }
    }

    public final String getSequenceId() throws RmRuntimeException {
        if (!this.isSequenceDataInit) {
            this.initSequenceHeaderData();
            this.isSequenceDataInit = true;
        }
        return this.sequenceId;
    }

    public final long getMessageNumber() throws RmRuntimeException {
        if (!this.isSequenceDataInit) {
            this.initSequenceHeaderData();
            this.isSequenceDataInit = true;
        }
        return this.messageNumber;
    }

    abstract void initSequenceHeaderData() throws RmRuntimeException;

    public final void setSequenceData(String sequenceId, long messageNumber) {
        this.sequenceId = sequenceId;
        this.messageNumber = messageNumber;
    }

    abstract String initAckRequestedHeaderData() throws RmRuntimeException;

    public final String getAckRequestedHeaderSequenceId() throws RmRuntimeException {
        if (!this.isAckRequestedHeaderDataInit) {
            this.ackRequestedHeaderSequenceId = this.initAckRequestedHeaderData();
            this.isAckRequestedHeaderDataInit = true;
        }
        return this.ackRequestedHeaderSequenceId;
    }

    public abstract void processAcknowledgements(SequenceManager var1, String var2) throws RmRuntimeException;

    public Session getSession() {
        String sessionId = (String)this.packet.invocationProperties.get("com.sun.xml.ws.sessionid");
        if (sessionId == null) {
            return null;
        }
        return SessionManager.getSessionManager().getSession(sessionId);
    }

    public boolean hasSession() {
        return this.getSession() != null;
    }

    public void setSession(String sessionId) {
        this.packet.invocationProperties.put("com.sun.xml.ws.sessionid", sessionId);
        Session session = SessionManager.getSessionManager().getSession(sessionId);
        this.packet.invocationProperties.put("com.sun.xml.ws.session", session.getUserData());
    }

    public void exposeSequenceDataToUser() {
        this.packet.invocationProperties.put("com.sun.xml.ws.sequence", this.sequenceId);
        this.packet.invocationProperties.put("com.sun.xml.ws.messagenumber", this.messageNumber);
    }

    public final String getSecurityContextTokenId() {
        Session session = this.getSession();
        return session != null ? session.getSecurityInfo().getIdentifier() : null;
    }

    public final void checkMessageReadyState() throws IllegalStateException {
        if (this.message == null) {
            throw new IllegalStateException("This PacketAdapter instance does not contain a packet with a non-null message");
        }
    }

    public final void checkPacketReadyState() throws IllegalStateException {
        if (this.packet == null) {
            throw new IllegalStateException("This PacketAdapter instance does not contain a packet with a non-null message");
        }
    }

    public final boolean isSecurityContextTokenIdValid(String expectedSctId) {
        String actualSctId = this.getSecurityContextTokenId();
        return expectedSctId != null ? expectedSctId.equals(actualSctId) : actualSctId == null;
    }
}

