/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codeviation.pojson.PojsonLoad;
import org.codeviation.pojson.PojsonSave;
import org.netbeans.modules.kenai.AuthenticationData;
import org.netbeans.modules.kenai.CheckNameData;
import org.netbeans.modules.kenai.FeatureData;
import org.netbeans.modules.kenai.KenaiImpl;
import org.netbeans.modules.kenai.LicensesListData;
import org.netbeans.modules.kenai.ListData;
import org.netbeans.modules.kenai.ProjectCreateData;
import org.netbeans.modules.kenai.ProjectData;
import org.netbeans.modules.kenai.ProjectFeatureCreateData;
import org.netbeans.modules.kenai.ProjectsListData;
import org.netbeans.modules.kenai.RestConnection;
import org.netbeans.modules.kenai.RestResponse;
import org.netbeans.modules.kenai.ServicesListData;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KenaiREST
extends KenaiImpl {
    private URL baseURL;
    private static final Logger TIMER = Logger.getLogger("TIMER.kenai");

    public KenaiREST(URL uRL) {
        this.baseURL = uRL;
    }

    @Override
    public boolean isAuthorized(String string, String string2, String string3) throws KenaiException {
        String[][] stringArray = new String[][]{{"feature_id", string2}, {"activity_id", string3}, {"person_id", Kenai.getDefault().getPasswordAuthentication().getUserName()}, {"project_id", string}};
        RestConnection restConnection = new RestConnection(this.baseURL.toString() + "/api/login/authorize", stringArray);
        long l = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis();
            System.err.println("Loading page " + this.baseURL.toString() + "/api/login/authorize");
        }
        RestResponse restResponse = null;
        try {
            restResponse = restConnection.get(null);
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Page " + this.baseURL.toString() + "/api/login/authorize loaded in " + (System.currentTimeMillis() - l) + " ms");
        }
        return restResponse.getResponseCode() == 200;
    }

    @Override
    public ProjectData getProject(String string) throws KenaiException {
        RestConnection restConnection = new RestConnection(this.baseURL.toString() + "/api/projects/" + string + ".json");
        RestResponse restResponse = null;
        long l = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis();
            System.err.println("Loading project " + string);
        }
        try {
            restResponse = restConnection.get(null);
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Project " + string + " loaded in " + (System.currentTimeMillis() - l) + " ms");
        }
        if (restResponse.getResponseCode() != 200) {
            throw new KenaiException(string + ": " + restResponse.getResponseMessage(), restResponse.getDataAsString());
        }
        String string2 = restResponse.getDataAsString();
        PojsonLoad pojsonLoad = PojsonLoad.create();
        return pojsonLoad.load(string2, ProjectData.class);
    }

    @Override
    public Collection<ProjectData> searchProjects(String string) throws KenaiException {
        try {
            ProjectsListData projectsListData = KenaiREST.loadPage(this.baseURL.toString() + "/api/projects.json?full=true&q=" + URLEncoder.encode(string, "UTF-8"), ProjectsListData.class);
            return new LazyList(this, (ListData)projectsListData, ProjectsListData.class);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    @Override
    public Collection<ProjectData> getMyProjects() throws KenaiException {
        ProjectsListData projectsListData = KenaiREST.loadPage(this.baseURL.toString() + "/api/projects/mine.json?full=true", ProjectsListData.class);
        return new LazyList(this, (ListData)projectsListData, ProjectsListData.class);
    }

    private static <T> T loadPage(String string, Class<T> clazz) throws KenaiException {
        long l = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis();
            System.err.println("Loading page " + string);
        }
        if (string == null) {
            System.out.println("");
        }
        RestConnection restConnection = new RestConnection(string);
        RestResponse restResponse = null;
        try {
            restResponse = restConnection.get(null);
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Page " + string + " loaded in " + (System.currentTimeMillis() - l) + " ms");
        }
        if (restResponse.getResponseCode() != 200) {
            throw new KenaiException(restResponse.getResponseMessage(), restResponse.getDataAsString());
        }
        String string2 = restResponse.getDataAsString();
        PojsonLoad pojsonLoad = PojsonLoad.create();
        T t = pojsonLoad.load(string2, clazz);
        return t;
    }

    @Override
    public Collection<LicensesListData.LicensesListItem> getLicenses() throws KenaiException {
        LicensesListData licensesListData = KenaiREST.loadPage(this.baseURL.toString() + "/api/licenses.json", LicensesListData.class);
        return new LazyList(this, (ListData)licensesListData, LicensesListData.class);
    }

    @Override
    public Collection<ServicesListData.ServicesListItem> getServices() throws KenaiException {
        ServicesListData servicesListData = KenaiREST.loadPage(this.baseURL.toString() + "/api/services.json", ServicesListData.class);
        return new LazyList(this, (ListData)servicesListData, ServicesListData.class);
    }

    @Override
    public String checkName(String string) throws KenaiException {
        CheckNameData checkNameData = KenaiREST.loadPage(this.baseURL.toString() + "/api/projects/check_unique.json?name=" + string, CheckNameData.class);
        return checkNameData.is_unique ? null : checkNameData.message;
    }

    @Override
    public ProjectData createProject(String string, String string2, String string3, String[] stringArray, String string4) throws KenaiException {
        RestConnection restConnection = new RestConnection(this.baseURL.toString() + "/api/projects.json");
        RestResponse restResponse = null;
        PojsonSave<ProjectCreateData> pojsonSave = PojsonSave.create(ProjectCreateData.class);
        ProjectCreateData projectCreateData = new ProjectCreateData();
        projectCreateData.project.name = string;
        projectCreateData.project.display_name = string2;
        projectCreateData.project.description = string3;
        projectCreateData.project.licenses = stringArray;
        projectCreateData.project.tags = string4;
        long l = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis();
            System.err.println("Create project " + string);
        }
        try {
            restResponse = restConnection.post((String[][])null, pojsonSave.asString(projectCreateData));
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Project " + string + " created in " + (System.currentTimeMillis() - l) + " ms");
        }
        if (restResponse.getResponseCode() != 201) {
            throw new KenaiException(restResponse.getResponseMessage(), restResponse.getDataAsString());
        }
        String string5 = restResponse.getDataAsString();
        PojsonLoad pojsonLoad = PojsonLoad.create();
        return pojsonLoad.load(string5, ProjectData.class);
    }

    @Override
    public FeatureData createProjectFeature(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws KenaiException {
        RestConnection restConnection = new RestConnection(this.baseURL.toString() + "/api/projects/" + string + "/features.json");
        RestResponse restResponse = null;
        PojsonSave<ProjectFeatureCreateData> pojsonSave = PojsonSave.create(ProjectFeatureCreateData.class);
        ProjectFeatureCreateData projectFeatureCreateData = new ProjectFeatureCreateData();
        projectFeatureCreateData.feature.name = string2;
        projectFeatureCreateData.feature.display_name = string3;
        projectFeatureCreateData.feature.description = string4;
        projectFeatureCreateData.feature.service = string8;
        projectFeatureCreateData.feature.url = string5;
        projectFeatureCreateData.feature.repository_url = string6;
        projectFeatureCreateData.feature.browse_url = string7;
        long l = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis();
            System.err.println("Creating feature " + string2);
        }
        try {
            restResponse = restConnection.post((String[][])null, pojsonSave.asString(projectFeatureCreateData));
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Feature " + string2 + " created in " + (System.currentTimeMillis() - l) + " ms");
        }
        if (restResponse.getResponseCode() != 201) {
            throw new KenaiException(restResponse.getResponseMessage(), restResponse.getDataAsString());
        }
        String string9 = restResponse.getDataAsString();
        PojsonLoad pojsonLoad = PojsonLoad.create();
        return pojsonLoad.load(string9, FeatureData.class);
    }

    @Override
    public void register(String string, char[] cArray) throws KenaiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String verify(String string, char[] cArray) throws KenaiException {
        AuthenticationData authenticationData = new AuthenticationData();
        authenticationData.username = string;
        authenticationData.password = new String(cArray);
        PojsonSave<AuthenticationData> pojsonSave = PojsonSave.create(AuthenticationData.class);
        RestConnection restConnection = new RestConnection(this.baseURL.toString() + "/api/login/authenticate.json");
        RestResponse restResponse = null;
        long l = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis();
            System.err.println("Loading page " + this.baseURL.toString() + "/api/login/authenticate.json");
        }
        try {
            restResponse = restConnection.post((String[][])null, pojsonSave.asString(authenticationData));
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Page " + this.baseURL.toString() + "/api/login/authenticate.json loaded in" + (System.currentTimeMillis() - l) + " ms");
        }
        if (restResponse.getResponseCode() != 200) {
            throw new KenaiException(ResourceBundle.getBundle("org.netbeans.modules.kenai.Bundle").getString("LBL_AuthenticationFailed"), restResponse.getDataAsString());
        }
        try {
            String string2 = (String)((HashMap)PojsonLoad.create().toCollections(restResponse.getDataAsString())).get("username");
            if (string2 == null || string2.length() == 0) {
                throw new KenaiException(ResourceBundle.getBundle("org.netbeans.modules.kenai.Bundle").getString("LBL_AuthenticationFailed"));
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyIterator<COLLECTION extends ListData, ITEM>
    implements Iterator<ITEM> {
        private COLLECTION col;
        private int currentIndex = 0;
        private Class<COLLECTION> clazz;
        final /* synthetic */ KenaiREST this$0;

        public LazyIterator(COLLECTION COLLECTION, Class<COLLECTION> clazz) {
            this.this$0 = var1_1;
            this.col = COLLECTION;
            this.clazz = clazz;
        }

        @Override
        public boolean hasNext() {
            if (((ListData)this.col).size() > this.currentIndex) {
                return true;
            }
            return ((ListData)this.col).next != null;
        }

        @Override
        public ITEM next() {
            if (this.currentIndex == ((ListData)this.col).size()) {
                this.currentIndex -= ((ListData)this.col).size();
                try {
                    this.col = (ListData)KenaiREST.loadPage(((ListData)this.col).next, this.clazz);
                }
                catch (KenaiException kenaiException) {
                    throw new RuntimeException("Error loading " + ((ListData)this.col).next, kenaiException);
                }
            }
            return this.colToItem(this.currentIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove items");
        }

        private ITEM colToItem(int n) {
            if (this.col instanceof ProjectsListData) {
                return (ITEM)((ProjectsListData)this.col).projects[n];
            }
            if (this.col instanceof ServicesListData) {
                return (ITEM)((ServicesListData)this.col).services[n];
            }
            if (this.col instanceof LicensesListData) {
                return (ITEM)((LicensesListData)this.col).licenses[n];
            }
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyList<COLLECTION extends ListData, ITEM>
    extends AbstractCollection<ITEM> {
        private COLLECTION col;
        private Class<COLLECTION> clazz;
        final /* synthetic */ KenaiREST this$0;

        public LazyList(COLLECTION COLLECTION, Class<COLLECTION> clazz) {
            this.this$0 = var1_1;
            this.col = COLLECTION;
            this.clazz = clazz;
        }

        @Override
        public Iterator<ITEM> iterator() {
            return new LazyIterator(this.this$0, this.col, this.clazz);
        }

        @Override
        public int size() {
            return ((ListData)this.col).total;
        }
    }
}

