/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.spring.container.servlet;

import com.sun.jersey.api.spring.Autowire;
import com.sun.jersey.spi.inject.Inject;
import com.sun.jersey.spi.service.ComponentContext;
import com.sun.jersey.spi.service.ComponentProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringComponentProvider
implements ComponentProvider {
    private static final Logger LOGGER = Logger.getLogger(SpringComponentProvider.class.getName());
    private ConfigurableApplicationContext springContext;

    public SpringComponentProvider(ConfigurableApplicationContext springContext) {
        this.springContext = springContext;
    }

    public <T> T getInstance(ComponentProvider.Scope scope, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return this.getInstance(null, scope, clazz);
    }

    public <T> T getInstance(ComponentProvider.Scope scope, Constructor<T> constructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.getInstance(null, scope, constructor.getDeclaringClass());
    }

    public <T> T getInstance(ComponentContext cc, ComponentProvider.Scope scope, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        Autowire autowire = clazz.getAnnotation(Autowire.class);
        if (autowire != null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Creating resource class " + clazz.getSimpleName() + " annotated with @" + Autowire.class.getSimpleName() + " as spring bean.");
            }
            Object result = this.springContext.getBeanFactory().createBean(clazz, autowire.mode().getSpringCode(), autowire.dependencyCheck());
            return clazz.cast(result);
        }
        String beanName = SpringComponentProvider.getBeanName(cc, clazz, (ApplicationContext)this.springContext);
        if (beanName == null) {
            return null;
        }
        if (scope == ComponentProvider.Scope.Undefined || scope == ComponentProvider.Scope.Singleton && this.springContext.isSingleton(beanName) || scope == ComponentProvider.Scope.PerRequest && this.springContext.isPrototype(beanName)) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Retrieving bean '" + beanName + "' for resource class " + clazz.getSimpleName() + " from spring.");
            }
            Object result = this.springContext.getBean(beanName, clazz);
            return clazz.cast(result);
        }
        if (scope == ComponentProvider.Scope.Singleton && !this.springContext.isSingleton(beanName) || scope == ComponentProvider.Scope.PerRequest && !this.springContext.isPrototype(beanName)) {
            throw new RuntimeException("The scopes defined for jersey and spring do not match for the resource class " + clazz.getName() + " and bean with name " + beanName + "!");
        }
        return null;
    }

    public <T> T getInjectableInstance(T instance) {
        if (AopUtils.isAopProxy(instance)) {
            Advised aopResource = (Advised)instance;
            try {
                Object result = aopResource.getTargetSource().getTarget();
                return (T)result;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not get target object from proxy.", e);
                throw new RuntimeException("Could not get target object from proxy.", e);
            }
        }
        return instance;
    }

    public void inject(Object instance) {
    }

    private static String getBeanName(ComponentContext cc, Class<?> c, ApplicationContext springContext) {
        String[] names;
        Inject inject;
        boolean annotatedWithInject = false;
        if (cc != null && (inject = SpringComponentProvider.getAnnotation(cc.getAnnotations(), Inject.class)) != null) {
            annotatedWithInject = true;
            if (inject.value() != null && !inject.value().equals("")) {
                return inject.value();
            }
        }
        if ((names = springContext.getBeanNamesForType(c)).length == 0) {
            return null;
        }
        if (names.length == 1) {
            return names[0];
        }
        StringBuilder sb = new StringBuilder();
        sb.append("There are multiple beans configured in spring for the type ").append(c.getName()).append(".");
        if (annotatedWithInject) {
            sb.append("\nYou should specify the name of the preferred bean at @Inject: Inject(\"yourBean\").");
        } else {
            sb.append("\nAnnotation information was not available, the reason might be because you're not using @Inject. You should use @Inject and specifiy the bean name via Inject(\"yourBean\").");
        }
        sb.append("\nAvailable bean names: ").append(SpringComponentProvider.toCSV(names));
        throw new RuntimeException(sb.toString());
    }

    private static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> clazz) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(clazz)) continue;
                return (T)((Annotation)clazz.cast(annotation));
            }
        }
        return null;
    }

    private static <T> String toCSV(T[] items) {
        if (items == null) {
            return null;
        }
        return SpringComponentProvider.toCSV(Arrays.asList(items));
    }

    private static <I> String toCSV(Collection<I> items) {
        return SpringComponentProvider.toCSV(items, ", ", null);
    }

    private static <I> String toCSV(Collection<I> items, String separator, String delimiter) {
        if (items == null) {
            return null;
        }
        if (items.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<I> iter = items.iterator();
        while (iter.hasNext()) {
            if (delimiter != null) {
                sb.append(delimiter);
            }
            I item = iter.next();
            sb.append(item);
            if (delimiter != null) {
                sb.append(delimiter);
            }
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }
}

