/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.WeakEventListenerList;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.impl.SideBarFactoriesProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizableSideBar {
    private static final Logger LOG = Logger.getLogger(CustomizableSideBar.class.getName());
    private static final Map<JTextComponent, Map<SideBarPosition, Reference<JPanel>>> CACHE = new WeakHashMap<JTextComponent, Map<SideBarPosition, Reference<JPanel>>>(5);
    private static final Map<String, WeakEventListenerList> LISTENERS = new HashMap<String, WeakEventListenerList>(5);
    private static final Map<MimePath, Lookup.Result<SideBarFactoriesProvider>> LR = new WeakHashMap<MimePath, Lookup.Result<SideBarFactoriesProvider>>(5);
    private static final Map<Lookup.Result<SideBarFactoriesProvider>, LookupListener> LL = new WeakHashMap<Lookup.Result<SideBarFactoriesProvider>, LookupListener>(5);

    private CustomizableSideBar() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChangeListener(String string, ChangeListener changeListener) {
        Map<String, WeakEventListenerList> map = LISTENERS;
        synchronized (map) {
            WeakEventListenerList weakEventListenerList = LISTENERS.get(string);
            if (weakEventListenerList == null) {
                weakEventListenerList = new WeakEventListenerList();
                LISTENERS.put(string, weakEventListenerList);
            }
            weakEventListenerList.add(ChangeListener.class, (EventListener)changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChangeListener(String string, ChangeListener changeListener) {
        Map<String, WeakEventListenerList> map = LISTENERS;
        synchronized (map) {
            WeakEventListenerList weakEventListenerList = LISTENERS.get(string);
            if (weakEventListenerList != null) {
                weakEventListenerList.remove(ChangeListener.class, (EventListener)changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireChange(String string) {
        ChangeListener[] changeListenerArray = null;
        Object object = LISTENERS;
        synchronized (object) {
            ChangeListener[] changeListenerArray2 = LISTENERS.get(string);
            if (changeListenerArray2 != null) {
                changeListenerArray = (ChangeListener[])changeListenerArray2.getListeners(ChangeListener.class);
            }
        }
        if (changeListenerArray != null && changeListenerArray.length > 0) {
            object = new ChangeEvent(CustomizableSideBar.class);
            for (ChangeListener changeListener : changeListenerArray) {
                changeListener.stateChanged((ChangeEvent)object);
            }
        }
    }

    public static Map<SideBarPosition, JComponent> getSideBars(JTextComponent jTextComponent) {
        assert (SwingUtilities.isEventDispatchThread()) : "Side bars can only be accessed from AWT";
        return CustomizableSideBar.getSideBarsInternal(jTextComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<SideBarPosition, JComponent> getSideBarsInternal(JTextComponent jTextComponent) {
        Object object;
        HashMap<SideBarPosition, JComponent> hashMap;
        Map<Object, Object> map;
        Map<Object, Object> map2 = CACHE;
        synchronized (map2) {
            map = CACHE.get(jTextComponent);
            if (map != null) {
                hashMap = new HashMap<SideBarPosition, JComponent>();
                for (SideBarPosition object2 : map.keySet()) {
                    Object object3 = (Reference)map.get(object2);
                    if (object3 == null) continue;
                    object = (JPanel)((Reference)object3).get();
                    if (object == null) break;
                    hashMap.put(object2, (JComponent)object);
                }
                if (hashMap.size() == map.size()) {
                    return hashMap;
                }
            }
        }
        map2 = CustomizableSideBar.createSideBarsMap(jTextComponent);
        map = CACHE;
        synchronized (map) {
            hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            for (Object object3 : map2.keySet()) {
                object = (List)map2.get(object3);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, ((SideBarPosition)object3).getAxis()));
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    JComponent jComponent = (JComponent)iterator.next();
                    jPanel.add(jComponent);
                }
                hashMap.put((SideBarPosition)object3, (JComponent)((Object)new WeakReference<JPanel>(jPanel)));
                hashMap2.put(object3, jPanel);
            }
            CACHE.put(jTextComponent, hashMap);
            return hashMap2;
        }
    }

    private static Map<SideBarPosition, List<JComponent>> createSideBarsMap(JTextComponent jTextComponent) {
        String string = NbEditorUtilities.getMimeType(jTextComponent);
        Map<SideBarPosition, List<SideBarFactory>> map = CustomizableSideBar.getFactoriesMap(string);
        HashMap<SideBarPosition, List<JComponent>> hashMap = new HashMap<SideBarPosition, List<JComponent>>(map.size());
        boolean bl = Boolean.TRUE.equals(jTextComponent.getClientProperty("errorStripeOnly"));
        for (SideBarPosition sideBarPosition : map.keySet()) {
            List<SideBarFactory> list = map.get(sideBarPosition);
            ArrayList<JComponent> arrayList = (ArrayList<JComponent>)hashMap.get(sideBarPosition);
            if (arrayList == null) {
                arrayList = new ArrayList<JComponent>();
                hashMap.put(sideBarPosition, arrayList);
            }
            for (SideBarFactory sideBarFactory : list) {
                JComponent jComponent = sideBarFactory.createSideBar(jTextComponent);
                if (jComponent == null) {
                    LOG.fine("Ignoring null side bar created by the factory: " + sideBarFactory);
                    continue;
                }
                if (bl && !"errorStripe".equals(jComponent.getName())) {
                    LOG.fine("Error stripe sidebar only. Ignoring '" + jComponent.getName() + "' side bar created by the factory: " + sideBarFactory);
                    continue;
                }
                arrayList.add(jComponent);
            }
        }
        return hashMap;
    }

    public static Map<SideBarPosition, List<SideBarFactory>> getFactoriesMap(String string) {
        Object object;
        MimePath mimePath = MimePath.parse((String)string);
        Lookup.Result result = LR.get(mimePath);
        if (result == null) {
            result = MimeLookup.getLookup((MimePath)mimePath).lookupResult(SideBarFactoriesProvider.class);
            object = LL.get(result);
            if (object == null) {
                object = new MyLookupListener(string);
                LL.put((Lookup.Result<SideBarFactoriesProvider>)result, (LookupListener)object);
            }
            result.addLookupListener((LookupListener)object);
            LR.put(mimePath, (Lookup.Result<SideBarFactoriesProvider>)result);
        }
        object = result.allInstances();
        assert (object.size() == 1) : "There should always be only one SideBarFactoriesProvider; provider-count=" + object.size() + ", mimeType=" + string + ", providers: " + object;
        SideBarFactoriesProvider sideBarFactoriesProvider = (SideBarFactoriesProvider)object.iterator().next();
        return sideBarFactoriesProvider.getFactories();
    }

    private static class MyLookupListener
    implements LookupListener {
        private String mimeType;

        public MyLookupListener(String string) {
            this.mimeType = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            Map map = CACHE;
            synchronized (map) {
                ArrayList<JTextComponent> arrayList = new ArrayList<JTextComponent>();
                for (JTextComponent jTextComponent : CACHE.keySet()) {
                    String string = NbEditorUtilities.getMimeType(jTextComponent);
                    if (!string.equals(this.mimeType)) continue;
                    arrayList.add(jTextComponent);
                }
                CACHE.keySet().removeAll(arrayList);
            }
            CustomizableSideBar.fireChange(this.mimeType);
        }
    }

    public static final class SideBarPosition {
        public static final int WEST = 1;
        public static final int NORTH = 2;
        public static final int SOUTH = 3;
        public static final int EAST = 4;
        public static final String WEST_NAME = "West";
        public static final String NORTH_NAME = "North";
        public static final String SOUTH_NAME = "South";
        public static final String EAST_NAME = "East";
        private int position;
        private boolean scrollable;
        private static String[] borderLayoutConstants = new String[]{"", "West", "North", "South", "East"};
        private static int[] axisConstants = new int[]{-1, 0, 1, 1, 0};

        SideBarPosition(FileObject fileObject) {
            Object object;
            Object object2 = fileObject.getAttribute("location");
            if (object2 == null) {
                object2 = fileObject.getAttribute("position");
            }
            if (object2 != null && object2 instanceof String) {
                object = (String)object2;
                if (WEST_NAME.equals(object)) {
                    this.position = 1;
                } else if (NORTH_NAME.equals(object)) {
                    this.position = 2;
                } else if (SOUTH_NAME.equals(object)) {
                    this.position = 3;
                } else if (EAST_NAME.equals(object)) {
                    this.position = 4;
                } else {
                    if (Logger.getLogger("global").isLoggable(Level.FINE)) {
                        Logger.getLogger("global").log(Level.FINE, "Unsupported position: " + (String)object);
                    }
                    this.position = 1;
                }
            } else {
                this.position = 1;
            }
            object = fileObject.getAttribute("scrollable");
            this.scrollable = object != null && object instanceof Boolean ? (Boolean)object : true;
            if (this.scrollable && (this.position == 3 || this.position == 4) && Logger.getLogger("global").isLoggable(Level.FINE)) {
                Logger.getLogger("global").log(Level.FINE, "Unsupported combination: scrollable == true, position=" + this.getBorderLayoutPosition());
            }
        }

        public int hashCode() {
            return this.scrollable ? this.position : -this.position;
        }

        public boolean equals(Object object) {
            if (object instanceof SideBarPosition) {
                SideBarPosition sideBarPosition = (SideBarPosition)object;
                if (this.scrollable != sideBarPosition.scrollable) {
                    return false;
                }
                return this.position == sideBarPosition.position;
            }
            return false;
        }

        public int getPosition() {
            return this.position;
        }

        public String getBorderLayoutPosition() {
            return borderLayoutConstants[this.getPosition()];
        }

        private int getAxis() {
            return axisConstants[this.getPosition()];
        }

        public boolean isScrollable() {
            return this.scrollable;
        }

        public String toString() {
            return "[SideBarPosition: scrollable=" + this.scrollable + ", position=" + this.position + "]";
        }
    }
}

