/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.newproject;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.ide.ergonomics.fod.ConfigurationPanel;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FindComponentModules;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.netbeans.modules.ide.ergonomics.fod.ModulesInstaller;
import org.netbeans.modules.ide.ergonomics.newproject.ContentPanel;
import org.netbeans.modules.ide.ergonomics.newproject.FeatureOnDemanWizardIterator;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionStep
implements WizardDescriptor.Panel<WizardDescriptor> {
    private ContentPanel panel;
    private ProgressHandle handle = null;
    private Collection<UpdateElement> forEnable = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static FindComponentModules finder = null;
    private FeatureInfo info;
    private WizardDescriptor wd;
    private FileObject fo;
    private boolean autoEnable;
    private PresentModules findModules = new PresentModules();

    public DescriptionStep(boolean bl) {
        this.autoEnable = bl;
    }

    public Component getComponent() {
        if (this.panel == null) {
            this.panel = new ContentPanel(DescriptionStep.getBundle("DescriptionPanel_Name", new Object[0]));
            this.panel.addPropertyChangeListener(this.findModules);
        }
        return this.panel;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return false;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        DescriptionStep descriptionStep = this;
        synchronized (descriptionStep) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void presentModulesForActivation() {
        this.forEnable = this.getFinder().getModulesForEnable();
        this.presentModulesForEnable();
    }

    private void presentModulesForEnable() {
        Collection<UpdateElement> collection;
        if (this.handle != null) {
            this.handle.finish();
            this.panel.replaceComponents(new JComponent[0]);
            this.handle = null;
        }
        if ((collection = this.getFinder().getModulesForEnable()) != null && !collection.isEmpty()) {
            Collection<UpdateElement> collection2 = this.getFinder().getVisibleUpdateElements(collection);
            final String string = ModulesInstaller.presentUpdateElements(collection2);
            final JPanel[] jPanelArray = new JPanel[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        jPanelArray[0] = new ConfigurationPanel(string, new Callable<JComponent>(){

                            @Override
                            public JComponent call() throws Exception {
                                FoDFileSystem.getInstance().refresh();
                                DescriptionStep.this.waitForDelegateWizard();
                                return new JLabel(" ");
                            }
                        }, DescriptionStep.this.info, DescriptionStep.this.autoEnable);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
            this.panel.replaceComponents(jPanelArray[0]);
            this.forEnable = collection;
        } else {
            FoDFileSystem.getInstance().refresh();
            this.waitForDelegateWizard();
        }
        this.fireChange();
    }

    private FindComponentModules getFinder() {
        assert (finder != null) : "Finder needs to be created first!";
        return finder;
    }

    private static String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(DescriptionStep.class, (String)string, (Object[])objectArray);
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wd = wizardDescriptor;
        Object object = wizardDescriptor.getProperty("chosen-template");
        assert (object != null && object instanceof FileObject) : object + " is not null and instanceof FileObject.";
        FileObject fileObject = (FileObject)object;
        this.info = FoDFileSystem.getInstance().whichProvides(fileObject);
        finder = new FindComponentModules(this.info, new FeatureInfo[0]);
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        if (this.forEnable != null && !this.forEnable.isEmpty()) {
            wizardDescriptor.putProperty("chosen-elements-for-enable", this.forEnable);
            this.fireChange();
        }
    }

    private void waitForDelegateWizard() {
        Object object = this.wd.getProperty("chosen-template");
        assert (object != null && object instanceof FileObject) : object + " is not null and instanceof FileObject";
        String string = ((FileObject)object).getPath();
        this.fo = null;
        WizardDescriptor.InstantiatingIterator<?> instantiatingIterator = null;
        int n = 0;
        while (this.fo == null || instantiatingIterator == null) {
            FoDFileSystem.getInstance().refresh();
            FoDFileSystem.getInstance().waitFinished();
            this.fo = FileUtil.getConfigFile((String)string);
            instantiatingIterator = DescriptionStep.readWizard(this.fo);
            if (!(instantiatingIterator instanceof FeatureOnDemanWizardIterator)) continue;
            Logger logger = Logger.getLogger(DescriptionStep.class.getName());
            logger.warning("There is still wrong interator " + instantiatingIterator.getClass().getName() + " for file object " + this.fo);
            FeatureManager.dumpModules(Level.INFO, Level.INFO);
            instantiatingIterator = null;
            if (++n == 10) {
                Logger.getLogger(DescriptionStep.class.getName()).severe("Giving up to find iterator for " + this.fo);
                boolean bl = false;
                if (!$assertionsDisabled) {
                    bl = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (bl) {
                    throw new NullPointerException("Send us the messages.log please!");
                }
                return;
            }
            logger.info("Forcing refresh");
            FoDFileSystem.getInstance().refreshForce();
            logger.info("Done with refresh");
            FileObject fileObject = FileUtil.getConfigFile((String)string);
            if (fileObject == null) {
                logger.warning("no " + string + " on FoD: " + fileObject);
                for (FileObject fileObject2 = this.fo; fileObject2 != null; fileObject2 = fileObject2.getParent()) {
                    logger.info("  parent: " + fileObject2 + " children: " + Arrays.asList(fileObject2.getChildren()));
                }
                continue;
            }
            logger.info("fake found " + fileObject);
            logger.info("its wizard is " + DescriptionStep.readWizard(fileObject));
        }
        instantiatingIterator.initialize(this.wd);
        this.wd.putProperty("delegate-iterator", instantiatingIterator);
        this.fireChange();
    }

    public static WizardDescriptor.InstantiatingIterator<?> readWizard(FileObject fileObject) {
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        Object object = fileObject.getAttribute("instantiatingIterator");
        if (object == null) {
            object = fileObject.getAttribute("templateWizardIterator");
        }
        if (!(object instanceof WizardDescriptor.InstantiatingIterator) && object instanceof TemplateWizard.Iterator) {
            final TemplateWizard.Iterator iterator = (TemplateWizard.Iterator)object;
            object = new WizardDescriptor.InstantiatingIterator<WizardDescriptor>(){
                private TemplateWizard tw;

                public Set instantiate() throws IOException {
                    return iterator.instantiate(this.tw);
                }

                public void initialize(WizardDescriptor wizardDescriptor) {
                    this.tw = (TemplateWizard)wizardDescriptor;
                    try {
                        FileObject fileObject = this.tw.getTemplate().getPrimaryFile();
                        if (!fileObject.isValid()) {
                            fileObject = FileUtil.getConfigFile((String)fileObject.getPath());
                        }
                        this.tw.setTemplate(DataObject.find((FileObject)fileObject));
                        iterator.initialize(this.tw);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        Logger.getLogger(DescriptionStep.class.getName()).severe(dataObjectNotFoundException.toString());
                    }
                }

                public void uninitialize(WizardDescriptor wizardDescriptor) {
                    iterator.uninitialize((TemplateWizard)wizardDescriptor);
                    this.tw = null;
                }

                public WizardDescriptor.Panel<WizardDescriptor> current() {
                    return iterator.current();
                }

                public String name() {
                    return iterator.name();
                }

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public boolean hasPrevious() {
                    return iterator.hasPrevious();
                }

                public void nextPanel() {
                    iterator.nextPanel();
                }

                public void previousPanel() {
                    iterator.previousPanel();
                }

                public void addChangeListener(ChangeListener changeListener) {
                    iterator.addChangeListener(changeListener);
                }

                public void removeChangeListener(ChangeListener changeListener) {
                    iterator.removeChangeListener(changeListener);
                }
            };
        }
        assert (object != null && object instanceof WizardDescriptor.InstantiatingIterator) : object + " is not null and instanceof WizardDescriptor.InstantiatingIterator";
        return (WizardDescriptor.InstantiatingIterator)object;
    }

    private class PresentModules
    implements Runnable,
    PropertyChangeListener {
        private PresentModules() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ContentPanel.FINDING_MODULES.equals(propertyChangeEvent.getPropertyName())) {
                RequestProcessor.getDefault().post((Runnable)this);
            }
        }

        public void run() {
            assert (!SwingUtilities.isEventDispatchThread());
            DescriptionStep.this.presentModulesForActivation();
        }
    }
}

