/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FindComponentModules;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.netbeans.modules.ide.ergonomics.fod.ModulesActivator;
import org.netbeans.modules.ide.ergonomics.fod.ProgressMonitor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulesInstaller {
    private Collection<UpdateElement> modules4install;
    private RequestProcessor.Task installTask = null;
    private OperationContainer<InstallSupport> installContainer;
    private ProgressHandle downloadHandle;
    private ProgressHandle verifyHandle;
    private ProgressHandle installHandle;
    private final FindComponentModules finder;
    private final ProgressMonitor progressMonitor;
    static boolean success = false;
    private Runnable doInstall = new Runnable(){

        public void run() {
            ModulesInstaller.this.installMissingModules();
        }
    };

    public ModulesInstaller(Collection<UpdateElement> collection, FindComponentModules findComponentModules) {
        this(collection, findComponentModules, null);
    }

    public ModulesInstaller(Collection<UpdateElement> collection, FindComponentModules findComponentModules, ProgressMonitor progressMonitor) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Cannot construct InstallerMissingModules with null or empty Collection " + collection);
        }
        this.modules4install = collection;
        this.finder = findComponentModules;
        this.progressMonitor = progressMonitor != null ? progressMonitor : ProgressMonitor.DEV_NULL_PROGRESS_MONITOR;
    }

    public static boolean installModules(FeatureInfo featureInfo) {
        return ModulesInstaller.installModules(null, featureInfo);
    }

    public static boolean installModules(ProgressMonitor progressMonitor, FeatureInfo featureInfo) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ!";
        FindComponentModules findComponentModules = new FindComponentModules(featureInfo, new FeatureInfo[0]);
        Collection<UpdateElement> collection = findComponentModules.getModulesForInstall();
        Collection<UpdateElement> collection2 = findComponentModules.getModulesForEnable();
        if (collection != null && !collection.isEmpty()) {
            ModulesInstaller modulesInstaller = new ModulesInstaller(collection, findComponentModules, progressMonitor);
            modulesInstaller.getInstallTask().schedule(10);
            modulesInstaller.getInstallTask().waitFinished();
            findComponentModules = new FindComponentModules(featureInfo, new FeatureInfo[0]);
            success = findComponentModules.getModulesForInstall().isEmpty();
        } else if (collection2 != null && !collection2.isEmpty()) {
            ModulesActivator modulesActivator = new ModulesActivator(collection2, findComponentModules, progressMonitor);
            modulesActivator.getEnableTask().schedule(100);
            modulesActivator.getEnableTask().waitFinished();
            success = true;
        }
        if (success) {
            FoDFileSystem.getInstance().refresh();
        }
        return success;
    }

    public void assignDownloadHandle(ProgressHandle progressHandle) {
        this.downloadHandle = progressHandle;
    }

    public void assignVerifyHandle(ProgressHandle progressHandle) {
        this.verifyHandle = progressHandle;
    }

    public void assignInstallHandle(ProgressHandle progressHandle) {
        this.installHandle = progressHandle;
    }

    public RequestProcessor.Task getInstallTask() {
        if (this.installTask == null) {
            this.installTask = this.createInstallTask();
        }
        return this.installTask;
    }

    private RequestProcessor.Task createInstallTask() {
        assert (this.installTask == null || this.installTask.isFinished()) : "The Install Task cannot be started nor scheduled.";
        this.installTask = RequestProcessor.getDefault().create(this.doInstall);
        return this.installTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installMissingModules() {
        try {
            this.doInstallMissingModules();
        }
        catch (Exception exception) {
            JButton jButton = new JButton();
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RequestProcessor.Task task;
                    if (ModulesInstaller.this.installContainer != null) {
                        try {
                            ((InstallSupport)ModulesInstaller.this.installContainer.getSupport()).doCancel();
                        }
                        catch (Exception exception) {
                            Logger.getLogger(ModulesInstaller.class.getName()).log(Level.INFO, exception.getLocalizedMessage(), exception);
                        }
                    }
                    if ((task = ModulesInstaller.this.getInstallTask()) != null) {
                        task.schedule(10);
                    }
                }
            });
            Logger.getLogger(ModulesInstaller.class.getName()).log(Level.INFO, exception.getLocalizedMessage(), exception);
            jButton.setEnabled(this.getInstallTask() != null);
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)ModulesInstaller.getBundle("InstallerMissingModules_TryAgainButton", new Object[0]));
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)this.getErrorNotifyPanel(exception), ModulesInstaller.getBundle("InstallerMissingModules_ErrorPanel_Title", new Object[0]), -1, 0, new Object[]{jButton, NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notifyLater(notifyDescriptor);
        }
        finally {
            FoDFileSystem.getInstance().refresh();
        }
    }

    private JComponent getErrorNotifyPanel(Exception exception) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setRows(15);
        jTextArea.setColumns(40);
        jTextArea.setOpaque(false);
        jTextArea.setText(ModulesInstaller.getBundle("InstallerMissingModules_ErrorPanel", exception.getLocalizedMessage(), exception));
        return jTextArea;
    }

    private void doInstallMissingModules() throws OperationException {
        UpdateElement updateElement2;
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot be called in EQ.";
        this.installContainer = null;
        for (UpdateElement updateElement2 : this.modules4install) {
            if (this.installContainer == null) {
                boolean bl = updateElement2.getUpdateUnit().getInstalled() == null;
                this.installContainer = bl ? OperationContainer.createForInstall() : OperationContainer.createForUpdate();
            }
            if (!this.installContainer.canBeAdded(updateElement2.getUpdateUnit(), updateElement2)) continue;
            this.installContainer.add(updateElement2);
        }
        if (this.installContainer.listAll().isEmpty()) {
            return;
        }
        assert (this.installContainer.listInvalid().isEmpty()) : "No invalid Update Elements " + this.installContainer.listInvalid();
        if (!this.installContainer.listInvalid().isEmpty()) {
            throw new IllegalArgumentException("Some are invalid for install: " + this.installContainer.listInvalid());
        }
        InstallSupport installSupport = (InstallSupport)this.installContainer.getSupport();
        if (this.downloadHandle == null) {
            this.downloadHandle = ProgressHandleFactory.createHandle((String)ModulesInstaller.getBundle("InstallerMissingModules_Download", ModulesInstaller.presentUpdateElements(this.finder.getVisibleUpdateElements(this.modules4install))));
        }
        this.progressMonitor.onDownload(this.downloadHandle);
        updateElement2 = installSupport.doDownload(this.downloadHandle, false);
        if (this.verifyHandle == null) {
            this.verifyHandle = ProgressHandleFactory.createHandle((String)ModulesInstaller.getBundle("InstallerMissingModules_Verify", new Object[0]));
        }
        this.progressMonitor.onValidate(this.verifyHandle);
        InstallSupport.Installer installer = installSupport.doValidate((InstallSupport.Validator)updateElement2, this.verifyHandle);
        if (this.installHandle == null) {
            this.installHandle = ProgressHandleFactory.createHandle((String)ModulesInstaller.getBundle("InstallerMissingModules_Install", new Object[0]));
        }
        this.progressMonitor.onInstall(this.installHandle);
        OperationSupport.Restarter restarter = installSupport.doInstall(installer, this.installHandle);
        if (restarter != null) {
            installSupport.doRestartLater(restarter);
        } else {
            this.waitToModuleLoaded();
        }
    }

    public static String presentUpdateElements(Collection<UpdateElement> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (UpdateElement updateElement : collection) {
            stringBuilder.append(string);
            stringBuilder.append(updateElement.getCategory());
            if (stringBuilder.length() > 30) {
                stringBuilder.append("...");
                break;
            }
            string = ", ";
        }
        return stringBuilder.toString();
    }

    private void waitToModuleLoaded() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot be called in EQ.";
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
            }
        });
        for (UpdateElement updateElement : this.modules4install) {
            while (!updateElement.isEnabled()) {
                task.schedule(100);
                task.waitFinished();
            }
        }
    }

    private static String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(ModulesInstaller.class, (String)string, (Object[])objectArray);
    }
}

