/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.ide.ergonomics.fod.BrokenProjectInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.ModulesInstaller;
import org.netbeans.modules.ide.ergonomics.fod.ProgressMonitor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 27938464212508L;
    final DownloadProgressMonitor progressMonitor = new DownloadProgressMonitor();
    private FeatureInfo featureInfo;
    private Callable<JComponent> callable;
    private final Boolean autoActivate;
    private JButton downloadButton;
    private JEditorPane errorLabel;
    private JLabel infoLabel;
    private JPanel progressPanel;

    public ConfigurationPanel(String string, Callable<JComponent> callable, FeatureInfo featureInfo, Boolean bl) {
        if (string == null) {
            // empty if block
        }
        FeatureManager.logUI("ERGO_QUESTION", featureInfo.clusterName, string);
        this.initComponents();
        this.callable = callable;
        String string2 = null;
        String string3 = null;
        this.featureInfo = featureInfo;
        this.autoActivate = bl;
        if (this.featureInfo != null && this.featureInfo.isPresent()) {
            string2 = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_EnableInfo", (Object)string);
            string3 = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_Enable");
        } else {
            string2 = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_DownloadInfo", (Object)string);
            string3 = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_Download");
        }
        boolean bl2 = this.autoActivate != null ? Boolean.TRUE.equals(this.autoActivate) : Boolean.getBoolean("noActivateButton");
        if (bl2) {
            this.infoLabel.setVisible(false);
            this.downloadButton.setVisible(false);
            this.downloadButtonActionPerformed(null);
        } else {
            Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)string2);
            Mnemonics.setLocalizedText((AbstractButton)this.downloadButton, (String)string3);
        }
        this.setError(" ");
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        FeatureManager.logUI("ERGO_CLOSE", new Object[0]);
    }

    void setError(String string) {
        assert (SwingUtilities.isEventDispatchThread());
        this.errorLabel.setText(string);
    }

    private void initComponents() {
        this.errorLabel = BrokenProjectInfo.getErrorPane("dummy");
        this.infoLabel = new JLabel();
        this.downloadButton = new JButton();
        this.progressPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)"dummy");
        Mnemonics.setLocalizedText((AbstractButton)this.downloadButton, (String)"dummy");
        this.downloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationPanel.this.downloadButtonActionPerformed(actionEvent);
            }
        });
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 3));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.progressPanel, -1, 374, Short.MAX_VALUE).add((Component)this.infoLabel).add((Component)this.downloadButton).add((Component)this.errorLabel, -2, -1, -2)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.errorLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.infoLabel).addPreferredGap(0).add((Component)this.downloadButton).add(18, 18, 18).add((Component)this.progressPanel, -1, 131, Short.MAX_VALUE).addContainerGap()));
    }

    private void downloadButtonActionPerformed(ActionEvent actionEvent) {
        FeatureManager.logUI("ERGO_DOWNLOAD", new Object[0]);
        this.downloadButton.setEnabled(false);
        final FeatureInfo featureInfo = this.featureInfo;
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                ModulesInstaller.installModules(ConfigurationPanel.this.progressMonitor, featureInfo);
            }
        });
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                if (!ConfigurationPanel.this.progressMonitor.error) {
                    SwingUtilities.invokeLater(new Runnable(){
                        private String msg;

                        public void run() {
                            ConfigurationPanel.this.removeAll();
                            ConfigurationPanel.this.setLayout(new BorderLayout());
                            try {
                                ConfigurationPanel.this.add((Component)ConfigurationPanel.this.callable.call(), "Center");
                            }
                            catch (Exception exception) {
                                Exceptions.printStackTrace((Throwable)exception);
                            }
                            ConfigurationPanel.this.invalidate();
                            ConfigurationPanel.this.revalidate();
                            ConfigurationPanel.this.repaint();
                            this.msg = ConfigurationPanel.this.featureInfo.isPresent() ? NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_EnableFailed") : NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_DownloadFailed");
                            ConfigurationPanel.this.setError(this.msg);
                            ConfigurationPanel.this.downloadButton.setEnabled(true);
                            ConfigurationPanel.this.progressPanel.removeAll();
                            ConfigurationPanel.this.progressPanel.revalidate();
                            ConfigurationPanel.this.progressPanel.repaint();
                        }
                    });
                }
            }
        });
        task.schedule(0);
    }

    private final class DownloadProgressMonitor
    implements ProgressMonitor {
        private boolean error = false;

        private DownloadProgressMonitor() {
        }

        public void onDownload(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        public void onValidate(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        public void onInstall(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        public void onEnable(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        private void updateProgress(ProgressHandle progressHandle) {
            final JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
            final JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigurationPanel.this.progressPanel.removeAll();
                    ConfigurationPanel.this.progressPanel.add(jLabel);
                    ConfigurationPanel.this.progressPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    ConfigurationPanel.this.progressPanel.add(jComponent);
                    ConfigurationPanel.this.progressPanel.revalidate();
                    ConfigurationPanel.this.progressPanel.repaint();
                }
            });
        }

        public void onError(final String string) {
            this.error = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigurationPanel.this.setError("<html>" + string + "</html>");
                    ConfigurationPanel.this.progressPanel.removeAll();
                    ConfigurationPanel.this.progressPanel.add(ConfigurationPanel.this.errorLabel);
                }
            });
        }
    }
}

