/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.ide.ergonomics.Utilities;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class ImportProjectAction
implements ActionListener {
    public void actionPerformed(final ActionEvent actionEvent) {
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                boolean bl;
                FeatureInfo featureInfo = null;
                for (FeatureInfo featureInfo2 : FeatureManager.features()) {
                    if (!"Eclipse".equals(featureInfo2.getProjectImporter())) continue;
                    featureInfo = featureInfo2;
                    break;
                }
                if (featureInfo != null && (bl = Utilities.featureNotFoundDialog(featureInfo, "Importer"))) {
                    ImportProjectAction.this.performRegular(actionEvent);
                }
            }
        });
        task.schedule(0);
    }

    private void performRegular(final ActionEvent actionEvent) {
        try {
            FoDFileSystem.getInstance().waitFinished();
            FileObject fileObject = FileUtil.getConfigFile((String)"Menu/File/Import/org-netbeans-modules-projectimport-eclipse-core-ImportProjectAction.instance");
            InstanceCookie instanceCookie = (InstanceCookie)DataObject.find((FileObject)fileObject).getCookie(InstanceCookie.class);
            final ActionListener actionListener = (ActionListener)instanceCookie.instanceCreate();
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    actionListener.actionPerformed(actionEvent);
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
    }
}

