/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modeldiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.PkgConfigManager;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSource
implements SourceFileProperties {
    private static final boolean TRACE_AMBIGUOUS = Boolean.getBoolean("cnd.modeldiscovery.trace.ambiguous");
    private static Logger logger = Logger.getLogger("org.netbeans.modules.cnd.modeldiscovery.provider.SourceFileProperties");
    private Item item;
    private CsmFile file;
    private Map<String, List<String>> searchBase;
    private PkgConfigManager.PkgConfig pkgConfig;
    private String itemPath;
    private List<String> userIncludePaths;
    private Set<String> includedFiles;
    private Map<String, String> userMacros;
    private boolean preferLocal;
    private static final String PATTERN = "/../";

    public ModelSource(Item item, CsmFile csmFile, Map<String, List<String>> map, PkgConfigManager.PkgConfig pkgConfig, boolean bl) {
        if (TRACE_AMBIGUOUS) {
            logger.setLevel(Level.ALL);
        }
        this.includedFiles = new HashSet<String>();
        this.item = item;
        this.file = csmFile;
        this.searchBase = map;
        this.pkgConfig = pkgConfig;
        this.preferLocal = bl;
    }

    public Set<String> getIncludedFiles() {
        if (this.userIncludePaths == null) {
            this.getUserInludePaths();
        }
        return this.includedFiles;
    }

    public String getCompilePath() {
        return new File(this.getItemPath()).getParentFile().getAbsolutePath();
    }

    public String getItemPath() {
        if (this.itemPath == null) {
            this.itemPath = this.item.getAbsPath();
            this.itemPath = this.itemPath.replace('\\', '/');
            this.itemPath = ModelSource.cutLocalRelative(this.itemPath);
            if (Utilities.isWindows()) {
                this.itemPath = this.itemPath.replace('/', File.separatorChar);
            }
        }
        return this.itemPath;
    }

    public static String cutLocalRelative(String string) {
        int n;
        String string2 = PATTERN;
        while ((n = string.indexOf(string2)) >= 0) {
            int n2 = -1;
            for (int i = n - 1; i >= 0; --i) {
                if (string.charAt(i) != '/') continue;
                n2 = i;
                break;
            }
            if (n2 < 0) break;
            string = string.substring(0, n2 + 1) + string.substring(n + string2.length());
        }
        return string;
    }

    public String getItemName() {
        return this.item.getFile().getName();
    }

    public List<String> getUserInludePaths() {
        if (this.userIncludePaths == null) {
            List list = this.item.getUserIncludePaths();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (Object e : list) {
                String string = (String)e;
                string = this.getRelativepath(string);
                linkedHashSet.add(string);
            }
            this.analyzeUnresolved(linkedHashSet, this.file, 0);
            this.userIncludePaths = new ArrayList<String>(linkedHashSet);
        }
        return this.userIncludePaths;
    }

    private String getRelativepath(String string) {
        if (Utilities.isWindows()) {
            string = string.replace('/', File.separatorChar);
        }
        string = IpeUtils.toRelativePath((String)this.getCompilePath(), (String)string);
        string = FilePathAdaptor.normalize((String)string);
        return string;
    }

    private void analyzeUnresolved(Set<String> set, CsmFile csmFile, int n) {
        if (csmFile == null) {
            return;
        }
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            CsmFile csmFile2 = csmInclude.getIncludeFile();
            if (csmFile2 == null) {
                PkgConfigManager.ResolvedPath resolvedPath;
                String string = this.guessPath(csmInclude);
                if (string != null) {
                    csmFile2 = this.file.getProject().findFile((Object)(string + File.separatorChar + csmInclude.getIncludeName()));
                    string = this.getRelativepath(string);
                    set.add(string);
                    if (n >= 5 || csmFile2 == null) continue;
                    this.analyzeUnresolved(set, csmFile2, n + 1);
                    continue;
                }
                if (this.pkgConfig == null || (resolvedPath = this.pkgConfig.getResolvedPath(((Object)csmInclude.getIncludeName()).toString())) == null) continue;
                set.add(resolvedPath.getIncludePath());
                for (Object object : resolvedPath.getPackages()) {
                    for (String string2 : object.getIncludePaths()) {
                        if (this.getSystemInludePaths().contains(string2)) continue;
                        set.add(string2);
                    }
                    for (String string2 : object.getMacros()) {
                        String string3;
                        int n2 = string2.indexOf("=");
                        String string4 = null;
                        if (n2 > 0) {
                            string3 = string2.substring(0, n2);
                            string4 = string2.substring(n2 + 1);
                        } else {
                            string3 = string2;
                        }
                        if (this.getUserMacros().containsKey(string3)) continue;
                        this.getUserMacros().put(string3, string4);
                    }
                }
                continue;
            }
            boolean bl = false;
            if (this.preferLocal) {
                Object object;
                boolean bl2 = false;
                String string = ((Object)csmFile2.getAbsolutePath()).toString();
                object = this.getSystemInludePaths().iterator();
                while (object.hasNext()) {
                    String string5 = object.next();
                    if (!string.startsWith(string5)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 && (object = this.guessPath(csmInclude)) != null && !string.startsWith((String)object)) {
                    if (TRACE_AMBIGUOUS) {
                        logger.fine("Directive resolved in project on path: " + (String)object + " instead " + (String)string);
                    }
                    csmFile2 = this.file.getProject().findFile((Object)((String)object + File.separatorChar + csmInclude.getIncludeName()));
                    object = this.getRelativepath((String)object);
                    set.add((String)object);
                    bl = true;
                }
            }
            if (!bl) {
                this.includedFiles.add(((Object)csmFile2.getAbsolutePath()).toString());
            }
            if (n >= 5 || csmFile2 == null) continue;
            this.analyzeUnresolved(set, csmFile2, n + 1);
        }
    }

    private String guessPath(CsmInclude csmInclude) {
        int n;
        List<String> list;
        String string = ((Object)csmInclude.getIncludeName()).toString();
        String string2 = string.replace('\\', '/');
        String string3 = null;
        int n2 = string2.lastIndexOf(47);
        if (n2 >= 0) {
            string3 = string2.substring(0, n2 + 1);
            string2 = string2.substring(n2 + 1);
            n2 = string3.lastIndexOf("./");
            if (n2 >= 0) {
                if ((string3 = string3.substring(n2 + 2)).length() == 0) {
                    string3 = null;
                    string = string2;
                } else {
                    string = string3 + '/' + string2;
                }
            }
        }
        if ((list = this.searchBase.get(string2)) != null && list.size() > 0) {
            n = -1;
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).endsWith(string)) continue;
                if (n >= 0) {
                    if (!TRACE_AMBIGUOUS) continue;
                    logger.fine("Ambiguous name for item: " + this.getItemPath());
                    logger.fine("  name1: " + list.get(n));
                    logger.fine("  name2: " + list.get(i));
                    continue;
                }
                n = i;
            }
            if (n >= 0) {
                String string4 = list.get(n);
                string4 = string4.substring(0, string4.length() - string.length() - 1);
                return string4;
            }
        }
        if (TRACE_AMBIGUOUS) {
            logger.fine("Unresolved name for item: " + this.getItemPath());
            logger.fine("  from: " + csmInclude.getContainingFile().getAbsolutePath());
            logger.fine("  name: " + csmInclude.getIncludeName());
            if (list != null && list.size() > 0) {
                for (n = 0; n < list.size(); ++n) {
                    logger.fine("  candidate: " + list.get(n));
                }
            }
        }
        return null;
    }

    public List<String> getSystemInludePaths() {
        return this.item.getSystemIncludePaths();
    }

    public Map<String, String> getUserMacros() {
        if (this.userMacros == null) {
            this.userMacros = new HashMap<String, String>();
            List list = this.item.getUserMacroDefinitions();
            for (String string : list) {
                int n = string.indexOf(61);
                if (n > 0) {
                    this.userMacros.put(string.substring(0, n).trim(), string.substring(n + 1).trim());
                    continue;
                }
                this.userMacros.put(string, null);
            }
        }
        return this.userMacros;
    }

    public Map<String, String> getSystemMacros() {
        return null;
    }

    public ItemProperties.LanguageKind getLanguageKind() {
        if (this.item.getLanguage() == NativeFileItem.Language.C) {
            return ItemProperties.LanguageKind.C;
        }
        if (this.item.getLanguage() == NativeFileItem.Language.CPP) {
            return ItemProperties.LanguageKind.CPP;
        }
        return ItemProperties.LanguageKind.Unknown;
    }
}

