/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.jsp.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.jsp.lexer.JspLexer;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JspTokenId implements TokenId
{
    TEXT("text"),
    SCRIPTLET("scriptlet"),
    ERROR("error"),
    TAG("tag-directive"),
    ENDTAG("endtag"),
    SYMBOL("symbol"),
    SYMBOL2("scriptlet-delimiter"),
    COMMENT("comment"),
    ATTRIBUTE("attribute-name"),
    ATTR_VALUE("attribute-value"),
    EOL("EOL"),
    WHITESPACE("jsp-whitespace"),
    EL("expression-language");

    public static final String SCRIPTLET_TOKEN_TYPE_PROPERTY = "JAVA_CODE_TYPE";
    private final String primaryCategory;
    private static final Language<JspTokenId> language;

    private JspTokenId() {
        this(null);
    }

    private JspTokenId(String string2) {
        this.primaryCategory = string2;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<JspTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<JspTokenId>(){

            protected Collection<JspTokenId> createTokenIds() {
                return EnumSet.allOf(JspTokenId.class);
            }

            protected Map<String, Collection<JspTokenId>> createTokenCategories() {
                return null;
            }

            protected Lexer<JspTokenId> createLexer(LexerRestartInfo<JspTokenId> lexerRestartInfo) {
                return new JspLexer(lexerRestartInfo);
            }

            protected LanguageEmbedding<?> embedding(Token<JspTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                switch ((JspTokenId)token.id()) {
                    case TEXT: {
                        return LanguageEmbedding.create((Language)HTMLTokenId.language(), (int)0, (int)0, (boolean)true);
                    }
                    case EL: {
                        int n = token.length() > 2 ? 2 : token.length();
                        int n2 = token.length() > 2 ? 1 : 0;
                        return LanguageEmbedding.create((Language)ELTokenId.language(), (int)n, (int)n2);
                    }
                    case SCRIPTLET: {
                        return LanguageEmbedding.create((Language)JavaTokenId.language(), (int)0, (int)0, (boolean)true);
                    }
                }
                return null;
            }

            protected String mimeType() {
                return "text/x-jsp";
            }
        }.language();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JavaCodeType {
        SCRIPTLET("scriptlet"),
        DECLARATION("declaration"),
        EXPRESSION("expression");

        private final String type;

        private JavaCodeType(String string2) {
            this.type = string2;
        }
    }
}

