/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.repository;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.repository.ConnectionType;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.ui.repository.RepositoryDialogPanel;
import org.netbeans.modules.subversion.ui.repository.RepositoryPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
implements ActionListener,
DocumentListener,
ItemListener {
    public static final int FLAG_URL_EDITABLE = 2;
    public static final int FLAG_URL_ENABLED = 4;
    public static final int FLAG_ACCEPT_REVISION = 8;
    public static final int FLAG_SHOW_REMOVE = 16;
    public static final int FLAG_SHOW_HINTS = 32;
    public static final int FLAG_SHOW_PROXY = 64;
    private static final String FILE_PANEL = "file-panel";
    private static final String HTTP_PANEL = "http-panel";
    private static final String SSH_PANEL = "ssh-panel";
    private static final String INVALID_URL_PANEL = "invalid-url-panel";
    private String currentConnPanelType;
    private ConnectionType currentPanel;
    private RepositoryPanel repositoryPanel;
    private boolean valid = true;
    private List<PropertyChangeListener> listeners;
    private RepositoryConnection editedRC;
    public static final String PROP_VALID = "valid";
    private String message;
    private int modeMask;
    private Dimension maxNeededSize;
    private ConnectionType http;
    private ConnectionType file;
    private ConnectionType svnSSHCli;
    private ConnectionType invalidUrlPanel;

    public Repository(String string) {
        this(0, string);
    }

    public Repository(int n, String string) {
        this.modeMask = n;
        this.initPanel();
        this.repositoryPanel.titleLabel.setText(string);
        this.repositoryPanel.urlComboBox.setEditable(this.isSet(2));
        this.repositoryPanel.urlComboBox.setEnabled(this.isSet(4));
        this.repositoryPanel.tipLabel.setVisible(this.isSet(32));
        this.repositoryPanel.removeButton.setVisible(this.isSet(16));
        this.repositoryPanel.removeButton.addActionListener(this);
        this.maxNeededSize = this.repositoryPanel.getPreferredSize();
        this.refreshUrlHistory();
    }

    public void selectUrl(SVNUrl sVNUrl, boolean bl) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.repositoryPanel.urlComboBox.getModel();
        int n = defaultComboBoxModel.getIndexOf(sVNUrl.toString());
        if (n > -1) {
            defaultComboBoxModel.setSelectedItem(sVNUrl.toString());
        } else if (bl) {
            RepositoryConnection repositoryConnection = new RepositoryConnection(sVNUrl.toString());
            defaultComboBoxModel.addElement(repositoryConnection);
            defaultComboBoxModel.setSelectedItem(repositoryConnection);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.repositoryPanel.removeButton) {
            this.onRemoveClick();
        }
    }

    private void onRemoveClick() {
        RepositoryConnection repositoryConnection = this.getSelectedRCIntern();
        if (repositoryConnection != null) {
            this.remove(repositoryConnection);
        }
    }

    private void initPanel() {
        this.repositoryPanel = new RepositoryPanel();
        this.http = new ConnectionType.Http(this);
        this.repositoryPanel.connPanel.add((Component)this.http.getPanel(), HTTP_PANEL);
        this.file = new ConnectionType.FileUrl(this);
        this.repositoryPanel.connPanel.add((Component)this.file.getPanel(), FILE_PANEL);
        this.svnSSHCli = new ConnectionType.SvnSSHCli(this);
        this.repositoryPanel.connPanel.add((Component)this.svnSSHCli.getPanel(), SSH_PANEL);
        this.invalidUrlPanel = new ConnectionType.InvalidUrl(this);
        this.repositoryPanel.connPanel.add((Component)this.invalidUrlPanel.getPanel(), INVALID_URL_PANEL);
        this.svnSSHCli.showHints(this.isSet(32));
        this.updateVisibility(FILE_PANEL);
        this.repositoryPanel.urlComboBox.addActionListener(this);
        this.getUrlComboEditor().getDocument().addDocumentListener(this);
        this.repositoryPanel.urlComboBox.addItemListener(this);
        this.onSelectedRepositoryChange();
    }

    public void refreshUrlHistory() {
        List<RepositoryConnection> list = SvnModuleConfig.getDefault().getRecentUrls();
        LinkedHashSet<RepositoryConnection> linkedHashSet = new LinkedHashSet<RepositoryConnection>();
        linkedHashSet.addAll(list);
        if (this.repositoryPanel.urlComboBox.isEditable()) {
            linkedHashSet.add(new RepositoryConnection("file:///"));
            linkedHashSet.add(new RepositoryConnection("http://"));
            linkedHashSet.add(new RepositoryConnection("https://"));
            linkedHashSet.add(new RepositoryConnection("svn://"));
            linkedHashSet.add(new RepositoryConnection("svn+ssh://"));
        }
        RepositoryModel repositoryModel = new RepositoryModel(new Vector(linkedHashSet));
        this.repositoryPanel.urlComboBox.setModel(repositoryModel);
        if (linkedHashSet.size() > 0) {
            this.repositoryPanel.urlComboBox.setSelectedIndex(0);
            this.currentPanel.refresh(this.getSelectedRCIntern());
        }
        if (this.repositoryPanel.urlComboBox.isEditable()) {
            JTextComponent jTextComponent = this.getUrlComboEditor();
            jTextComponent.selectAll();
        }
        this.updateVisibility();
    }

    public void storeRecentUrls() {
        SvnModuleConfig.getDefault().setRecentUrls(this.getRecentUrls());
    }

    public boolean isChanged() {
        List<RepositoryConnection> list;
        List<RepositoryConnection> list2 = this.getRecentUrls();
        return !SvnUtils.equals(list2, list = SvnModuleConfig.getDefault().getRecentUrls());
    }

    private List<RepositoryConnection> getRecentUrls() {
        ComboBoxModel comboBoxModel = this.repositoryPanel.urlComboBox.getModel();
        ArrayList<RepositoryConnection> arrayList = new ArrayList<RepositoryConnection>(comboBoxModel.getSize());
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            arrayList.add((RepositoryConnection)comboBoxModel.getElementAt(i));
        }
        return arrayList;
    }

    private JTextComponent getUrlComboEditor() {
        Component component = this.repositoryPanel.urlComboBox.getEditor().getEditorComponent();
        JTextComponent jTextComponent = (JTextComponent)component;
        return jTextComponent;
    }

    public void setEditable(boolean bl) {
        this.repositoryPanel.urlComboBox.setEditable(bl);
        this.currentPanel.setEditable(bl);
    }

    public void storeConfigValues() {
        this.currentPanel.storeConfigValues();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    private void textChanged(final DocumentEvent documentEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (documentEvent.getDocument() == ((JTextComponent)((Repository)Repository.this).repositoryPanel.urlComboBox.getEditor().getEditorComponent()).getDocument()) {
                    Repository.this.onSelectedRepositoryChange();
                }
                Repository.this.validateSvnUrl();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    void validateSvnUrl() {
        boolean bl = true;
        RepositoryConnection repositoryConnection = null;
        try {
            repositoryConnection = this.getSelectedRCIntern();
            new SVNUrl(repositoryConnection.getSvnUrl().toString());
            if (!this.isSet(8) && !repositoryConnection.getSvnRevision().equals((Object)SVNRevision.HEAD)) {
                this.message = NbBundle.getMessage(Repository.class, (String)"MSG_Repository_OnlyHEADRevision");
                bl = false;
            } else {
                repositoryConnection.getSvnRevision();
            }
        }
        catch (Exception exception) {
            this.message = exception.getLocalizedMessage();
            bl = false;
        }
        if (bl) {
            boolean bl2 = bl = repositoryConnection != null && !repositoryConnection.getUrl().equals("");
            if (!this.currentPanel.isValid(repositoryConnection)) {
                bl = false;
            }
        }
        this.setValid(bl, this.message);
        this.currentPanel.setEnabled(bl);
        this.repositoryPanel.removeButton.setEnabled(repositoryConnection != null && repositoryConnection.getUrl().length() > 0);
    }

    private void onSelectedRepositoryChange() {
        this.setValid(true, "");
        String string = "";
        try {
            string = this.getUrlString();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (string != null) {
            RepositoryConnection repositoryConnection = this.getEditedRC();
            repositoryConnection.setUrl(string);
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.repositoryPanel.urlComboBox.getModel();
            int n = defaultComboBoxModel.getIndexOf(repositoryConnection);
            if (n > -1) {
                this.currentPanel.refresh((RepositoryConnection)defaultComboBoxModel.getElementAt(n));
            }
            this.currentPanel.onSelectedRepositoryChange(string);
            this.currentPanel.fillRC(repositoryConnection);
        }
        this.message = "";
        this.updateVisibility();
    }

    private RepositoryConnection getEditedRC() {
        if (this.editedRC == null) {
            this.editedRC = new RepositoryConnection("");
        }
        return this.editedRC;
    }

    private void updateVisibility() {
        String string;
        try {
            string = this.getUrlString();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        String string2 = string.startsWith("http:") ? HTTP_PANEL : (string.startsWith("https:") ? HTTP_PANEL : (string.startsWith("svn:") ? HTTP_PANEL : (string.startsWith("svn+") ? SSH_PANEL : (string.startsWith("file:") ? FILE_PANEL : INVALID_URL_PANEL))));
        this.updateVisibility(string2, string);
    }

    private void updateVisibility(String string) {
        String string2;
        try {
            string2 = this.getUrlString();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.updateVisibility(string, string2);
    }

    private void updateVisibility(String string, String string2) {
        if (string == HTTP_PANEL) {
            this.currentPanel = this.http;
        } else if (string == SSH_PANEL) {
            this.currentPanel = this.svnSSHCli;
        } else if (string == FILE_PANEL) {
            this.currentPanel = this.file;
        } else if (string == INVALID_URL_PANEL) {
            this.currentPanel = this.invalidUrlPanel;
        } else assert (false);
        if (string != this.currentConnPanelType) {
            ((CardLayout)this.repositoryPanel.connPanel.getLayout()).show(this.repositoryPanel.connPanel, string);
            this.currentConnPanelType = string;
        }
        this.repositoryPanel.tipLabel.setText(this.currentPanel.getTip(string2));
        this.currentPanel.updateVisibility(string2);
    }

    private String getUrlString() throws InterruptedException {
        if (!this.repositoryPanel.urlComboBox.isEditable()) {
            Object object = this.repositoryPanel.urlComboBox.getSelectedItem();
            if (object != null) {
                return object.toString().trim();
            }
            return "";
        }
        final String[] stringArray = new String[1];
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    stringArray[0] = ((Repository)Repository.this).repositoryPanel.urlComboBox.getEditor().getItem().toString().trim();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
            return stringArray[0].trim();
        }
        catch (InvocationTargetException invocationTargetException) {
            Subversion.LOG.log(Level.SEVERE, null, invocationTargetException);
            return null;
        }
    }

    public RepositoryConnection getSelectedRC() {
        RepositoryConnection repositoryConnection = this.getSelectedRCIntern();
        return repositoryConnection;
    }

    RepositoryConnection getSelectedRCIntern() {
        String string;
        try {
            string = this.getUrlString();
        }
        catch (InterruptedException interruptedException) {
            Subversion.LOG.log(Level.SEVERE, null, interruptedException);
            return null;
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.repositoryPanel.urlComboBox.getModel();
        int n = defaultComboBoxModel.getIndexOf(string);
        if (n > -1) {
            return (RepositoryConnection)defaultComboBoxModel.getElementAt(n);
        }
        return this.getEditedRC();
    }

    public RepositoryPanel getPanel() {
        return this.repositoryPanel;
    }

    public boolean isValid() {
        return this.valid;
    }

    void setValid(boolean bl, String string) {
        boolean bl2 = this.valid;
        this.message = string;
        this.valid = bl;
        this.fireValidPropertyChanged(bl2, bl);
    }

    private void fireValidPropertyChanged(boolean bl, boolean bl2) {
        if (this.listeners == null) {
            return;
        }
        for (PropertyChangeListener propertyChangeListener : this.listeners) {
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, PROP_VALID, new Boolean(bl), new Boolean(bl2)));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        this.listeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(propertyChangeListener);
    }

    public String getMessage() {
        return this.message;
    }

    public void remove(RepositoryConnection repositoryConnection) {
        RepositoryModel repositoryModel = (RepositoryModel)this.repositoryPanel.urlComboBox.getModel();
        repositoryModel.removeElement(repositoryConnection);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            RepositoryConnection repositoryConnection = (RepositoryConnection)itemEvent.getItem();
            this.currentPanel.refresh(repositoryConnection);
            this.updateVisibility();
            this.editedRC = new RepositoryConnection(repositoryConnection);
        } else if (itemEvent.getStateChange() == 2) {
            this.updateVisibility();
        }
    }

    public boolean show(String string, HelpCtx helpCtx, boolean bl) {
        RepositoryDialogPanel repositoryDialogPanel = new RepositoryDialogPanel();
        repositoryDialogPanel.panel.setLayout(new BorderLayout());
        RepositoryPanel repositoryPanel = this.getPanel();
        if (bl) {
            repositoryPanel.setPreferredSize(this.maxNeededSize);
        }
        repositoryDialogPanel.panel.add((Component)repositoryPanel, "North");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)repositoryDialogPanel, string);
        this.showDialog(dialogDescriptor, helpCtx);
        return dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Object show(String string, HelpCtx helpCtx, Object[] objectArray, Object object) {
        RepositoryDialogPanel repositoryDialogPanel = new RepositoryDialogPanel();
        repositoryDialogPanel.panel.setLayout(new BorderLayout());
        repositoryDialogPanel.panel.add((Component)this.getPanel(), "North");
        DialogDescriptor dialogDescriptor = null;
        dialogDescriptor = objectArray != null ? new DialogDescriptor((Object)repositoryDialogPanel, string, true, objectArray, object, 0, helpCtx, null) : new DialogDescriptor((Object)repositoryDialogPanel, string);
        this.showDialog(dialogDescriptor, helpCtx);
        return dialogDescriptor.getValue();
    }

    public Object show(String string, HelpCtx helpCtx, Object[] objectArray) {
        return this.show(string, helpCtx, objectArray, null);
    }

    private void showDialog(DialogDescriptor dialogDescriptor, HelpCtx helpCtx) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(helpCtx);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Repository.class, (String)"ACSD_RepositoryPanel"));
        dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Repository.class, (String)"ACSN_RepositoryPanel"));
        dialog.setVisible(true);
    }

    private boolean isSet(int n) {
        return (this.modeMask & n) != 0;
    }

    public class RepositoryModel
    extends DefaultComboBoxModel {
        public RepositoryModel(Vector vector) {
            super(vector);
        }

        public void setSelectedItem(Object object) {
            if (object instanceof String) {
                int n = this.getIndexOf(object);
                object = n > -1 ? this.getElementAt(n) : this.createNewRepositoryConnection((String)object);
            }
            super.setSelectedItem(object);
        }

        public int getIndexOf(Object object) {
            if (object instanceof String) {
                object = this.createNewRepositoryConnection((String)object);
            }
            return super.getIndexOf(object);
        }

        public void addElement(Object object) {
            if (object instanceof String) {
                object = this.createNewRepositoryConnection((String)object);
            }
            super.addElement(object);
        }

        public void insertElementAt(Object object, int n) {
            if (object instanceof String) {
                String string = (String)object;
                RepositoryConnection repositoryConnection = null;
                try {
                    repositoryConnection = (RepositoryConnection)this.getElementAt(n);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (repositoryConnection != null) {
                    repositoryConnection.setUrl(string);
                    object = repositoryConnection;
                }
                object = this.createNewRepositoryConnection(string);
            }
            super.insertElementAt(object, n);
        }

        public void removeElement(Object object) {
            int n = this.getIndexOf(object);
            if (n != -1) {
                this.removeElementAt(n);
            }
        }

        private RepositoryConnection createNewRepositoryConnection(String string) {
            if (Repository.this.editedRC != null) {
                Repository.this.editedRC.setUrl(string);
                return new RepositoryConnection(Repository.this.editedRC);
            }
            return new RepositoryConnection(string);
        }
    }
}

