/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.ui.update.RevertModifications;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.versioning.util.HyperlinkProvider;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener,
DiffSetupSource {
    private static final String SUMMARY_REVERT_PROPERTY = "Summary-Revert-";
    private static final String HLINK_ISSUE_PROPERTY = "Hyperlink-Issue-";
    private final SearchHistoryPanel master;
    private JList resultsList;
    private JScrollPane scrollPane;
    private final List dispResults;
    private String message;
    private AttributeSet searchHiliteAttrs;
    private List<RepositoryRevision> results;

    public SummaryView(SearchHistoryPanel searchHistoryPanel, List<RepositoryRevision> list) {
        this.master = searchHistoryPanel;
        this.results = list;
        this.dispResults = this.expandResults(list);
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getMimeLookup((String)"text/x-java").lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fontColorSettings.getFontColors("highlight-search");
        this.message = searchHistoryPanel.getCriteria().getCommitMessage();
        this.resultsList = new JList(new SummaryListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.setCellRenderer(new SummaryCellRenderer());
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        searchHistoryPanel.addComponentListener(this);
        this.resultsList.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.resultsList.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SummaryView.this.onPopup(Utils.getPositionForPopup((JList)SummaryView.this.resultsList));
            }
        });
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        int[] nArray = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SummaryListModel());
        this.resultsList.setSelectedIndices(nArray);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    private List expandResults(List<RepositoryRevision> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (RepositoryRevision repositoryRevision : list) {
            arrayList.add(repositoryRevision);
            List<RepositoryRevision.Event> list2 = repositoryRevision.getEvents();
            for (RepositoryRevision.Event event : list2) {
                arrayList.add(event);
            }
        }
        return arrayList;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Linker linker;
        int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.resultsList.getCellBounds(n, n);
        Point point = new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
        Rectangle rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.diffPrevious(n);
        }
        if ((rectangle2 = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + n)) != null && rectangle2.contains(point)) {
            this.revertModifications(new int[]{n});
        }
        if ((linker = (Linker)this.resultsList.getClientProperty(HLINK_ISSUE_PROPERTY + n)) != null) {
            for (int i = 0; i < linker.start.length; ++i) {
                if (linker.bounds == null || linker.bounds[i] == null || !linker.bounds[i].contains(point)) continue;
                linker.hp.onClick(this.master.getRoots()[0], linker.text[i], linker.start[i], linker.end[i]);
                break;
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.resultsList.getCellBounds(n, n);
        Point point = new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
        Rectangle rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        rectangle2 = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        Linker linker = (Linker)this.resultsList.getClientProperty(HLINK_ISSUE_PROPERTY + n);
        if (linker != null) {
            for (int i = 0; i < linker.start.length; ++i) {
                if (linker.bounds == null || linker.bounds[i] == null || !linker.bounds[i].contains(point)) continue;
                this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
        }
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
    }

    public Collection getSetups() {
        int[] nArray;
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length == 0) {
            return this.master.getSetups(this.results.toArray(new RepositoryRevision[this.results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> hashSet = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> hashSet2 = new HashSet<RepositoryRevision>();
        for (int n : nArray = this.resultsList.getSelectedIndices()) {
            Object e = this.dispResults.get(n);
            if (e instanceof RepositoryRevision) {
                hashSet2.add((RepositoryRevision)e);
                continue;
            }
            hashSet.add((RepositoryRevision.Event)e);
        }
        return this.master.getSetups(hashSet2.toArray(new RepositoryRevision[hashSet2.size()]), hashSet.toArray(new RepositoryRevision.Event[hashSet.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    private boolean isMixedSelection(List list, int[] nArray) {
        if (nArray.length < 1) {
            return false;
        }
        Class<?> clazz = list.get(nArray[0]).getClass();
        for (int i = 0; i < nArray.length; ++i) {
            if (clazz.equals(list.get(nArray[i]).getClass())) continue;
            return true;
        }
        return false;
    }

    private void onPopup(MouseEvent mouseEvent) {
        this.onPopup(mouseEvent.getPoint());
    }

    private void onPopup(Point point) {
        boolean bl;
        ArrayList<RepositoryRevision.Event> arrayList;
        boolean bl2;
        int[] nArray = this.resultsList.getSelectedIndices();
        if (nArray.length == 0) {
            int n = this.resultsList.locationToIndex(point);
            if (n == -1) {
                return;
            }
            this.resultsList.setSelectedIndex(n);
            nArray = new int[]{n};
        }
        final int[] nArray2 = nArray;
        JPopupMenu jPopupMenu = new JPopupMenu();
        Object var5_6 = null;
        RepositoryRevision repositoryRevision = null;
        Object e = this.dispResults.get(nArray2[0]);
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        if (e instanceof RepositoryRevision) {
            bl2 = true;
            repositoryRevision = (RepositoryRevision)this.dispResults.get(nArray2[0]);
            arrayList = new ArrayList(0);
            bl5 = true;
            bl3 = true;
        } else {
            bl2 = false;
            arrayList = new ArrayList<RepositoryRevision.Event>(nArray2.length);
            for (int i = 0; i < nArray2.length; ++i) {
                if (!(this.dispResults.get(nArray2[i]) instanceof RepositoryRevision.Event)) {
                    bl2 = true;
                    continue;
                }
                RepositoryRevision.Event event = (RepositoryRevision.Event)this.dispResults.get(nArray2[i]);
                arrayList.add(event);
                File file = event.getFile();
                if (!bl6 && file != null && !file.exists() && event.getChangedPath().getAction() == 'D') {
                    bl6 = true;
                }
                if (!bl4 && event.getFile() == null) {
                    bl4 = true;
                }
                if (bl5 && i > 0 && ((RepositoryRevision.Event)arrayList.get(0)).getLogInfoHeader().getLog().getRevision().getNumber() != ((RepositoryRevision.Event)arrayList.get(0)).getLogInfoHeader().getLog().getRevision().getNumber()) {
                    bl5 = false;
                }
                if (file == null || !file.exists() || event.getChangedPath().getAction() != 'D') continue;
                bl3 = false;
            }
            repositoryRevision = ((RepositoryRevision.Event)arrayList.get(0)).getLogInfoHeader();
        }
        final RepositoryRevision.Event[] eventArray = arrayList.toArray(new RepositoryRevision.Event[arrayList.size()]);
        long l = repositoryRevision.getLog().getRevision().getNumber();
        final boolean bl7 = !bl6 && !bl4 && !bl2 && bl5;
        final boolean bl8 = !bl4 && bl5 && (eventArray.length == 0 || bl3);
        final boolean bl9 = nArray2.length == 1 && !bl2 && eventArray[0].getFile() != null && !eventArray[0].getFile().isDirectory() && eventArray[0].getChangedPath().getAction() != 'D';
        boolean bl10 = bl = nArray2.length == 1;
        if (l > 1L) {
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", var5_6)){
                {
                    super(string);
                    this.setEnabled(bl);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SummaryView.this.diffPrevious(nArray2[0]);
                }
            }));
        }
        jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
            {
                super(string);
                this.setEnabled(bl8);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SummaryView.this.revertModifications(nArray2);
            }
        }));
        if (!bl2) {
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)l)){
                {
                    super(string);
                    this.setEnabled(bl7);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            SummaryView.rollback(eventArray);
                        }
                    });
                }
            }));
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){
                {
                    super(string);
                    this.setEnabled(bl9);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            SummaryView.this.view(nArray2[0]);
                        }
                    });
                }
            }));
        }
        jPopupMenu.show(this.resultsList, point.x, point.y);
    }

    static void rollback(RepositoryRevision.Event event) {
        SummaryView.rollback(new RepositoryRevision.Event[]{event});
    }

    static void rollback(final RepositoryRevision.Event[] eventArray) {
        SVNUrl sVNUrl = eventArray[0].getLogInfoHeader().getRepositoryRootUrl();
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            public void perform() {
                for (RepositoryRevision.Event event : eventArray) {
                    SummaryView.rollback(event, this);
                }
            }
        };
        svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(SummaryView.class, (String)"MSG_Rollback_Progress"));
    }

    private static void rollback(RepositoryRevision.Event event, SvnProgressSupport svnProgressSupport) {
        File file = event.getFile();
        if (event.getChangedPath().getAction() == 'D') {
            if (file.exists()) {
                try {
                    SvnClient svnClient = Subversion.getInstance().getClient(false);
                    svnClient.remove(new File[]{file}, true);
                }
                catch (SVNClientException sVNClientException) {
                    Subversion.LOG.log(Level.SEVERE, null, sVNClientException);
                }
                Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
            }
            return;
        }
        File file2 = file.getParentFile();
        file2.mkdirs();
        try {
            SVNUrl sVNUrl = event.getLogInfoHeader().getRepositoryRootUrl();
            SVNUrl sVNUrl2 = sVNUrl.appendPath(event.getChangedPath().getPath());
            File file3 = VersionsCache.getInstance().getFileRevision(sVNUrl, sVNUrl2, Long.toString(event.getLogInfoHeader().getLog().getRevision().getNumber()), event.getFile().getName());
            for (int i = 1; i < 7 && !file.delete(); ++i) {
                try {
                    Thread.sleep(i * 34);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)file3), (FileObject)FileUtil.toFileObject((File)file2), (String)file.getName(), (String)"");
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.SEVERE, null, iOException);
        }
    }

    private void revertModifications(int[] nArray) {
        HashSet<RepositoryRevision.Event> hashSet = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> hashSet2 = new HashSet<RepositoryRevision>();
        for (int n : nArray) {
            Object e = this.dispResults.get(n);
            if (e instanceof RepositoryRevision) {
                hashSet2.add((RepositoryRevision)e);
                continue;
            }
            hashSet.add((RepositoryRevision.Event)e);
        }
        SummaryView.revert(this.master, hashSet2.toArray(new RepositoryRevision[hashSet2.size()]), hashSet.toArray(new RepositoryRevision.Event[hashSet.size()]));
    }

    static void revert(final SearchHistoryPanel searchHistoryPanel, final RepositoryRevision[] repositoryRevisionArray, final RepositoryRevision.Event[] eventArray) {
        SVNUrl sVNUrl;
        try {
            sVNUrl = searchHistoryPanel.getSearchRepositoryRootUrl();
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            public void perform() {
                SummaryView.revertImpl(searchHistoryPanel, repositoryRevisionArray, eventArray, this);
            }
        };
        svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(SummaryView.class, (String)"MSG_Revert_Progress"));
    }

    private static void revertImpl(SearchHistoryPanel searchHistoryPanel, RepositoryRevision[] repositoryRevisionArray, RepositoryRevision.Event[] eventArray, SvnProgressSupport svnProgressSupport) {
        Context context;
        RevertModifications.RevisionInterval revisionInterval;
        SVNUrl sVNUrl;
        try {
            sVNUrl = searchHistoryPanel.getSearchRepositoryRootUrl();
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(sVNUrl, sVNUrl, SVNRevision.HEAD);
        for (RepositoryRevision object : repositoryRevisionArray) {
            revisionInterval = new RevertModifications.RevisionInterval((SVNRevision)object.getLog().getRevision());
            context = new Context(searchHistoryPanel.getRoots());
            RevertModificationsAction.performRevert(revisionInterval, false, context, svnProgressSupport);
        }
        for (RepositoryRevision.Event event : eventArray) {
            if (event.getFile() == null) continue;
            revisionInterval = new RevertModifications.RevisionInterval((SVNRevision)event.getLogInfoHeader().getLog().getRevision());
            context = new Context(event.getFile());
            RevertModificationsAction.performRevert(revisionInterval, false, context, svnProgressSupport);
        }
    }

    private void view(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event event = (RepositoryRevision.Event)e;
            File file = event.getFile();
            String string = event.getLogInfoHeader().getLog().getRevision().toString();
            SVNUrl sVNUrl = event.getLogInfoHeader().getRepositoryRootUrl();
            SVNUrl sVNUrl2 = sVNUrl.appendPath(event.getChangedPath().getPath());
            File file2 = null;
            try {
                file2 = VersionsCache.getInstance().getFileRevision(sVNUrl, sVNUrl2, string, file.getName());
            }
            catch (IOException iOException) {
                Subversion.LOG.log(Level.SEVERE, null, iOException);
                return;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file2);
            EditorCookie editorCookie = null;
            OpenCookie openCookie = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Subversion.LOG.log(Level.FINE, null, dataObjectNotFoundException);
            }
            if (editorCookie != null) {
                Utils.openFile((FileObject)fileObject, (String)string);
            } else if (openCookie != null) {
                openCookie.open();
            } else {
                Utils.openFile((FileObject)fileObject, (String)string);
            }
        }
    }

    private void diffPrevious(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event event = (RepositoryRevision.Event)e;
            this.master.showDiff(event);
        } else {
            RepositoryRevision repositoryRevision = (RepositoryRevision)e;
            this.master.showDiff(repositoryRevision);
        }
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel() {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void set(String string, Color color, Color color2) {
            StringBuilder stringBuilder = new StringBuilder(100);
            if (color.equals(UIManager.getColor("List.foreground"))) {
                stringBuilder.append("<html><a href=\"\">");
                stringBuilder.append(string);
                stringBuilder.append("</a>");
            } else {
                stringBuilder.append("<html><a href=\"\" style=\"color:");
                stringBuilder.append("rgb(");
                stringBuilder.append(color.getRed());
                stringBuilder.append(",");
                stringBuilder.append(color.getGreen());
                stringBuilder.append(",");
                stringBuilder.append(color.getBlue());
                stringBuilder.append(")");
                stringBuilder.append("\">");
                stringBuilder.append(string);
                stringBuilder.append("</a>");
            }
            this.setText(stringBuilder.toString());
            this.setBackground(color2);
        }
    }

    private class SummaryCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private static final double DARKEN_FACTOR = 0.95;
        private Style selectedStyle;
        private Style normalStyle;
        private Style filenameStyle;
        private Style indentStyle;
        private Style noindentStyle;
        private Style hiliteStyle;
        private Style hyperlinkStyle;
        private Color selectionBackground;
        private Color selectionForeground;
        private JTextPane textPane = new JTextPane();
        private JPanel actionsPane = new JPanel();
        private DateFormat defaultFormat;
        private int index;
        private HyperlinkLabel diffLink;
        private HyperlinkLabel revertLink;

        public SummaryCellRenderer() {
            this.selectionBackground = new JList().getSelectionBackground();
            this.selectionForeground = new JList().getSelectionForeground();
            this.selectedStyle = this.textPane.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, this.selectionForeground);
            StyleConstants.setBackground(this.selectedStyle, this.selectionBackground);
            this.normalStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.filenameStyle = this.textPane.addStyle("filename", this.normalStyle);
            StyleConstants.setBold(this.filenameStyle, true);
            this.indentStyle = this.textPane.addStyle("indent", null);
            StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
            this.noindentStyle = this.textPane.addStyle("noindent", null);
            StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
            this.defaultFormat = DateFormat.getDateTimeInstance();
            this.hyperlinkStyle = this.textPane.addStyle("hyperlink", this.normalStyle);
            StyleConstants.setForeground(this.hyperlinkStyle, Color.BLUE);
            StyleConstants.setUnderline(this.hyperlinkStyle, true);
            this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
            Color color = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background);
            if (color != null) {
                StyleConstants.setBackground(this.hiliteStyle, color);
            }
            if ((color = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
                StyleConstants.setForeground(this.hiliteStyle, color);
            }
            this.setLayout(new BorderLayout());
            this.add(this.textPane);
            this.add((Component)this.actionsPane, "Last");
            this.actionsPane.setLayout(new FlowLayout(4, 2, 5));
            this.diffLink = new HyperlinkLabel();
            this.diffLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
            this.actionsPane.add(this.diffLink);
            this.revertLink = new HyperlinkLabel();
            this.actionsPane.add(this.revertLink);
            this.textPane.setBorder(null);
        }

        public Color darker(Color color) {
            return new Color(Math.max((int)((double)color.getRed() * 0.95), 0), Math.max((int)((double)color.getGreen() * 0.95), 0), Math.max((int)((double)color.getBlue() * 0.95), 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof RepositoryRevision) {
                this.renderContainer(jList, (RepositoryRevision)object, n, bl);
            } else {
                this.renderRevision(jList, (RepositoryRevision.Event)object, n, bl);
            }
            return this;
        }

        private void renderContainer(JList jList, RepositoryRevision repositoryRevision, int n, boolean bl) {
            Style style;
            Color color;
            Color color2;
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            if (bl) {
                color2 = this.selectionForeground;
                color = this.selectionBackground;
                style = this.selectedStyle;
            } else {
                color2 = UIManager.getColor("List.foreground");
                color = UIManager.getColor("List.background");
                color = this.darker(color);
                style = this.normalStyle;
            }
            this.textPane.setBackground(color);
            this.actionsPane.setBackground(color);
            this.index = n;
            Lookup.Result result = Lookup.getDefault().lookupResult(HyperlinkProvider.class);
            Collection collection = result.allInstances();
            try {
                int n2;
                HyperlinkProvider hyperlinkProvider;
                int[] nArray;
                String string;
                styledDocument.remove(0, styledDocument.getLength());
                styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.noindentStyle, false);
                styledDocument.insertString(0, Long.toString(repositoryRevision.getLog().getRevision().getNumber()), null);
                styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.filenameStyle, false);
                styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + repositoryRevision.getLog().getAuthor(), null);
                Date date = repositoryRevision.getLog().getDate();
                if (date != null) {
                    styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + this.defaultFormat.format(date), null);
                }
                if ((string = repositoryRevision.getLog().getMessage()).endsWith("\n")) {
                    string = string.substring(0, string.length() - 1);
                }
                styledDocument.insertString(styledDocument.getLength(), "\n", null);
                styledDocument.insertString(styledDocument.getLength(), string, null);
                int n3 = string.length();
                int n4 = styledDocument.getLength();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && (nArray = (hyperlinkProvider = (HyperlinkProvider)iterator.next()).getSpans(string)) != null) {
                    if (nArray.length % 2 != 0) {
                        Subversion.LOG.warning("Hyperlink provider " + hyperlinkProvider.getClass().getName() + " returns wrong spans");
                        break;
                    }
                    if (nArray.length <= 0) continue;
                    Linker linker = new Linker();
                    linker.docstart = new int[nArray.length / 2];
                    linker.docend = new int[nArray.length / 2];
                    linker.start = new int[nArray.length / 2];
                    linker.end = new int[nArray.length / 2];
                    linker.text = new String[nArray.length / 2];
                    int n5 = 0;
                    while (n5 < nArray.length) {
                        int n6;
                        int n7;
                        int n8 = n5 / 2;
                        if ((n7 = nArray[n5++]) < (n6 = nArray[n5++])) {
                            Subversion.LOG.warning("Hyperlink provider " + hyperlinkProvider.getClass().getName() + " returns wrong spans [" + n6 + "," + n7 + "]");
                            continue;
                        }
                        styledDocument.setCharacterAttributes(n4 - n3 + n6, n7 - n6, this.hyperlinkStyle, false);
                        int n9 = n4 - n3 + n6;
                        int n10 = n9 + n7 - n6;
                        linker.hp = hyperlinkProvider;
                        linker.start[n8] = n6;
                        linker.end[n8] = n7;
                        linker.docstart[n8] = n9;
                        linker.docend[n8] = n10;
                        linker.text[n8] = string;
                    }
                    SummaryView.this.resultsList.putClientProperty(SummaryView.HLINK_ISSUE_PROPERTY + n, linker);
                }
                if (SummaryView.this.message != null && !bl && (n2 = string.indexOf(SummaryView.this.message)) != -1) {
                    styledDocument.setCharacterAttributes(n4 - n3 + n2, SummaryView.this.message.length(), this.hiliteStyle, true);
                }
                this.resizePane(string, jList.getFontMetrics(jList.getFont()));
                styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
            }
            catch (BadLocationException badLocationException) {
                Subversion.LOG.log(Level.SEVERE, null, badLocationException);
            }
            this.actionsPane.setVisible(true);
            this.diffLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Diff"), color2, color);
            this.revertLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Revert"), color2, color);
        }

        private void renderRevision(JList jList, RepositoryRevision.Event event, int n, boolean bl) {
            Style style;
            Color color;
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            if (bl) {
                Color color2 = this.selectionForeground;
                color = this.selectionBackground;
                style = this.selectedStyle;
            } else {
                Color color3 = UIManager.getColor("List.foreground");
                color = UIManager.getColor("List.background");
                style = this.normalStyle;
            }
            this.textPane.setBackground(color);
            this.actionsPane.setVisible(false);
            this.index = -1;
            try {
                styledDocument.remove(0, styledDocument.getLength());
                styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.indentStyle, false);
                styledDocument.insertString(styledDocument.getLength(), String.valueOf(event.getChangedPath().getAction()), null);
                styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + event.getChangedPath().getPath(), null);
                styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
                this.resizePane(styledDocument.getText(0, styledDocument.getLength() - 1), jList.getFontMetrics(jList.getFont()));
            }
            catch (BadLocationException badLocationException) {
                Subversion.LOG.log(Level.SEVERE, null, badLocationException);
            }
        }

        private void resizePane(String string, FontMetrics fontMetrics) {
            int n;
            if (string == null) {
                string = "";
            }
            if ((n = SummaryView.this.master.getWidth()) > 0) {
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.textPane.getGraphics());
                int n2 = -1;
                int n3 = 0;
                while (n3 != -1) {
                    n3 = string.indexOf(10, n3 + 1);
                    ++n2;
                }
                int n4 = (int)(rectangle2D.getWidth() / (double)(n - 80) + 1.0);
                int n5 = fontMetrics.getHeight() * (n4 + ++n2) + 0;
                this.textPane.setPreferredSize(new Dimension(n - 50, n5));
            }
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.index == -1) {
                return;
            }
            Rectangle rectangle = this.actionsPane.getBounds();
            Rectangle rectangle2 = this.diffLink.getBounds();
            rectangle2.setBounds(rectangle2.x, rectangle2.y + rectangle.y, rectangle2.width, rectangle2.height);
            SummaryView.this.resultsList.putClientProperty("Summary-Diff-" + this.index, rectangle2);
            rectangle2 = this.revertLink.getBounds();
            rectangle2.setBounds(rectangle2.x, rectangle2.y + rectangle.y, rectangle2.width, rectangle2.height);
            SummaryView.this.resultsList.putClientProperty(SummaryView.SUMMARY_REVERT_PROPERTY + this.index, rectangle2);
            Rectangle rectangle3 = this.textPane.getBounds();
            try {
                Linker linker = (Linker)SummaryView.this.resultsList.getClientProperty(SummaryView.HLINK_ISSUE_PROPERTY + this.index);
                if (linker != null) {
                    TextUI textUI = this.textPane.getUI();
                    linker.bounds = new Rectangle[linker.docstart.length];
                    for (int i = 0; i < linker.docstart.length; ++i) {
                        Rectangle rectangle4 = textUI.modelToView(this.textPane, linker.docstart[i], Position.Bias.Forward).getBounds();
                        Rectangle rectangle5 = textUI.modelToView(this.textPane, linker.docend[i], Position.Bias.Backward).getBounds();
                        linker.bounds[i] = rectangle2 = new Rectangle(rectangle3.x + rectangle4.x, rectangle4.y, rectangle5.x - rectangle4.x, rectangle4.height);
                    }
                    SummaryView.this.resultsList.putClientProperty(SummaryView.HLINK_ISSUE_PROPERTY + this.index, linker);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private class Linker {
        HyperlinkProvider hp;
        Rectangle[] bounds;
        int[] docstart;
        int[] docend;
        int[] start;
        int[] end;
        String[] text;

        private Linker() {
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private SummaryListModel() {
        }

        public int getSize() {
            return SummaryView.this.dispResults.size();
        }

        public Object getElementAt(int n) {
            return SummaryView.this.dispResults.get(n);
        }
    }
}

