/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.ProxySettings;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnConfigFiles
implements PreferenceChangeListener {
    private static SvnConfigFiles instance;
    private Ini svnServers = null;
    private Ini config = null;
    private ProxySettings proxySettings;
    private static final String UNIX_CONFIG_DIR = ".subversion/";
    private static final String GROUPS_SECTION = "groups";
    private static final String GLOBAL_SECTION = "global";
    private static final String WINDOWS_USER_APPDATA;
    private static final String WINDOWS_CONFIG_DIR;
    private static final String WINDOWS_GLOBAL_CONFIG_DIR;
    private static final List<String> DEFAULT_GLOBAL_IGNORES;
    private boolean recentUrlsChanged = true;

    private SvnConfigFiles() {
        Config.getGlobal().setEscape(false);
        this.config = this.copyConfigFileToIDEConfigDir("config", new ConfigIniFilePatcher());
        this.svnServers = this.loadSystemIniFile("servers");
        SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public static SvnConfigFiles getInstance() {
        String string = System.getProperty("netbeans.t9y.svn.user.config.path");
        if (string != null && string.length() > 0) {
            instance = null;
        }
        if (instance == null) {
            instance = new SvnConfigFiles();
        }
        return instance;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("repository.recentURL")) {
            this.recentUrlsChanged = true;
        }
    }

    public void storeSvnServersSettings(SVNUrl sVNUrl) {
        assert (sVNUrl != null) : "can't do anything for a null host";
        if (!sVNUrl.getProtocol().startsWith("http") && !sVNUrl.getProtocol().startsWith("https")) {
            return;
        }
        boolean bl = false;
        Ini ini = new Ini();
        Ini.Section section = ini.add(GLOBAL_SECTION);
        bl = this.recentUrlsChanged;
        ProxySettings proxySettings = new ProxySettings();
        if (this.proxySettings == null || !proxySettings.equals(this.proxySettings)) {
            this.proxySettings = proxySettings;
            bl = true;
        }
        if (bl) {
            if (sVNUrl.getProtocol().startsWith("https")) {
                this.setSSLCert(sVNUrl, section);
            }
            this.setProxy(sVNUrl, section);
            this.storeIni(ini, "servers");
        }
    }

    private boolean setSSLCert(SVNUrl sVNUrl, Ini.Section section) {
        this.recentUrlsChanged = false;
        RepositoryConnection repositoryConnection = SvnModuleConfig.getDefault().getRepositoryConnection(sVNUrl.toString());
        if (repositoryConnection == null) {
            return true;
        }
        String string = repositoryConnection.getCertFile();
        if (string == null || string.equals("")) {
            return true;
        }
        String string2 = repositoryConnection.getCertPassword();
        if (string2 == null || string2.equals("")) {
            return true;
        }
        section.put((Object)"ssl-client-cert-file", (Object)string);
        section.put((Object)"ssl-client-cert-password", (Object)string2);
        return true;
    }

    private boolean setProxy(SVNUrl sVNUrl, Ini.Section section) {
        String string = SvnUtils.ripUserFromHost(sVNUrl.getHost());
        Ini.Section section2 = (Ini.Section)this.svnServers.get((Object)GLOBAL_SECTION);
        if (!this.proxySettings.isDirect()) {
            String string2 = "";
            int n = -1;
            if (sVNUrl.getProtocol().startsWith("https")) {
                string2 = this.proxySettings.getHttpsHost();
                n = this.proxySettings.getHttpsPort();
            }
            if (string2.equals("")) {
                string2 = this.proxySettings.getHttpHost();
                n = this.proxySettings.getHttpPort();
            }
            String string3 = this.proxySettings.getNotProxyHosts();
            if (string2 != null && !string2.equals("")) {
                Preferences preferences;
                boolean bl;
                section.put((Object)"http-proxy-host", (Object)string2);
                section.put((Object)"http-proxy-port", (Object)Integer.toString(n));
                if (!string3.equals("")) {
                    section.put((Object)"http-proxy-exceptions", (Object)string3);
                }
                if (bl = (preferences = NbPreferences.root().node("org/netbeans/core")).getBoolean("useProxyAuthentication", false)) {
                    String string4 = preferences.get("proxyAuthenticationUsername", "");
                    String string5 = preferences.get("proxyAuthenticationPassword", "");
                    section.put((Object)"http-proxy-username", (Object)string4);
                    section.put((Object)"http-proxy-password", (Object)string5);
                }
            }
        }
        this.mergeNonProxyKeys(string, section2, section);
        return true;
    }

    private void mergeNonProxyKeys(String string, Ini.Section section, Ini.Section section2) {
        Ini.Section section3;
        if (section != null) {
            this.mergeNonProxyKeys(section, section2);
        }
        if ((section3 = this.getServerGroup(string)) != null) {
            this.mergeNonProxyKeys(section3, section2);
        }
    }

    private void mergeNonProxyKeys(Ini.Section section, Ini.Section section2) {
        for (String string : section.keySet()) {
            if (this.isProxyConfigurationKey(string)) continue;
            section2.put((Object)string, section.get((Object)string));
        }
    }

    public void setExternalCommand(String string, String string2) {
        Ini.Section section = this.getSection(this.config, "tunnels", true);
        section.put((Object)string, (Object)string2);
        this.storeIni(this.config, "config");
    }

    public String getExternalCommand(String string) {
        Ini.Section section = this.getSection(this.config, "tunnels", true);
        String string2 = (String)section.get((Object)string);
        return string2 != null ? string2 : "";
    }

    private Ini.Section getSection(Ini ini, String string, boolean bl) {
        Ini.Section section = (Ini.Section)ini.get((Object)string);
        if (section == null) {
            return ini.add(string);
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeIni(Ini ini, String string) {
        FilterOutputStream filterOutputStream = null;
        try {
            File file = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath() + "/" + string));
            file.getParentFile().mkdirs();
            filterOutputStream = FileUtils.createOutputStream(file);
            ini.store((OutputStream)filterOutputStream);
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.INFO, null, iOException);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    Subversion.LOG.log(Level.INFO, null, iOException);
                }
            }
        }
    }

    public List<String> getGlobalIgnores() {
        String string;
        Ini.Section section = (Ini.Section)this.config.get((Object)"miscellany");
        if (section != null && (string = (String)section.get((Object)"global-ignores")) != null && string.trim().length() > 0) {
            return SvnConfigFiles.parseGlobalIgnores(string);
        }
        return DEFAULT_GLOBAL_IGNORES;
    }

    public String getClientCertFile(String string) {
        return this.getMergeValue("ssl-client-cert-file", string);
    }

    public String getClientCertPassword(String string) {
        return this.getMergeValue("ssl-client-cert-password", string);
    }

    private String getMergeValue(String string, String string2) {
        Ini.Section section = this.getServerGroup(string2);
        if (section != null) {
            return (String)section.get((Object)string);
        }
        section = (Ini.Section)this.svnServers.get((Object)GLOBAL_SECTION);
        if (section != null) {
            return (String)section.get((Object)string);
        }
        return null;
    }

    private static List<String> parseGlobalIgnores(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<String> arrayList = new ArrayList<String>(10);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String getUserConfigPath() {
        String string = System.getProperty("netbeans.t9y.svn.user.config.path");
        if (string != null && string.length() > 0) {
            return string;
        }
        if (Utilities.isUnix()) {
            String string2 = System.getProperty("user.home");
            return string2 + "/" + UNIX_CONFIG_DIR;
        }
        if (Utilities.isWindows()) {
            return WINDOWS_CONFIG_DIR;
        }
        return "";
    }

    public static String getNBConfigPath() {
        String string = System.getProperty("netbeans.t9y.svn.nb.config.path");
        if (string != null && string.length() > 0) {
            return string;
        }
        String string2 = System.getProperty("netbeans.user");
        return string2 + "/config/svn/config/";
    }

    private Ini.Section getServerGroup(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Ini.Section section = (Ini.Section)this.svnServers.get((Object)GROUPS_SECTION);
        if (section != null) {
            for (String string2 : section.keySet()) {
                String string3 = (String)section.get((Object)string2);
                if (string3 == null || (string3 = string3.trim()) == null || !this.match(string3, string)) continue;
                return (Ini.Section)this.svnServers.get((Object)string2);
            }
        }
        return null;
    }

    private boolean match(String string, String string2) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i].trim();
            if (string.equals("*") || string.equals(string2)) {
                return true;
            }
            int n = string.indexOf("*");
            if (n <= -1 || !this.matchSegments(string, string2)) continue;
            return true;
        }
        return false;
    }

    private boolean matchSegments(String string, String string2) {
        string = string.replace(".", "\\.");
        string = string.replace("*", ".*");
        Matcher matcher = Pattern.compile(string).matcher(string2);
        return matcher.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ini copyConfigFileToIDEConfigDir(String string, IniFilePatcher iniFilePatcher) {
        Ini ini = this.loadSystemIniFile(string);
        iniFilePatcher.patch(ini);
        File file = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath() + "/" + string));
        FilterOutputStream filterOutputStream = null;
        try {
            file.getParentFile().mkdirs();
            filterOutputStream = FileUtils.createOutputStream(file);
            ini.store((OutputStream)filterOutputStream);
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.INFO, null, iOException);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    Subversion.LOG.log(Level.INFO, null, iOException);
                }
            }
        }
        return ini;
    }

    private Ini loadSystemIniFile(String string) {
        String string2 = SvnConfigFiles.getUserConfigPath() + "/" + string;
        File file = FileUtil.normalizeFile((File)new File(string2));
        Ini ini = null;
        try {
            ini = new Ini((Reader)new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.INFO, null, iOException);
        }
        catch (Exception exception) {
            Subversion.LOG.log(Level.INFO, "exception in Ini4j, system file not loaded: " + string2, exception);
        }
        if (ini == null) {
            ini = new Ini();
            Subversion.LOG.warning("Could not load the file " + string2 + ". Falling back on svn defaults.");
        }
        Ini ini2 = null;
        try {
            ini2 = new Ini((Reader)new FileReader(SvnConfigFiles.getGlobalConfigPath() + "/" + string));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.INFO, null, iOException);
        }
        catch (Exception exception) {
            Subversion.LOG.log(Level.INFO, "exception in Ini4j, global file not loaded: " + SvnConfigFiles.getGlobalConfigPath() + "/" + string, exception);
        }
        if (ini2 != null) {
            this.merge(ini2, ini);
        }
        return ini;
    }

    private void merge(Ini ini, Ini ini2) {
        for (String string : ini.keySet()) {
            Ini.Section section = (Ini.Section)ini.get((Object)string);
            Ini.Section section2 = (Ini.Section)ini2.get((Object)string);
            if (section2 == null) {
                section2 = ini2.add(string);
            }
            for (String string2 : section.keySet()) {
                if (section2.containsKey((Object)string2)) continue;
                section2.put((Object)string2, section.get((Object)string2));
            }
        }
    }

    private boolean isProxyConfigurationKey(String string) {
        return string.equals("http-proxy-host") || string.equals("http-proxy-port") || string.equals("http-proxy-username") || string.equals("http-proxy-password") || string.equals("http-proxy-exceptions");
    }

    private static String getGlobalConfigPath() {
        if (Utilities.isUnix()) {
            return "/etc/subversion";
        }
        if (Utilities.isWindows()) {
            return WINDOWS_GLOBAL_CONFIG_DIR;
        }
        return "";
    }

    private static String getAPPDATA() {
        String string = "";
        if (Utilities.isWindows()) {
            string = System.getenv("APPDATA");
        }
        return string != null ? string : "";
    }

    private static String getGlobalAPPDATA() {
        if (Utilities.isWindows()) {
            String string;
            String string2 = System.getenv("ALLUSERSPROFILE");
            if (string2 == null || string2.trim().equals("")) {
                string2 = "";
            }
            if ((string = WINDOWS_USER_APPDATA) == null || string.equals("")) {
                return "";
            }
            return SvnConfigFiles.getWinUserAppdata(string, string2);
        }
        return "";
    }

    private static String getWinUserAppdata(String string, String string2) {
        string = SvnConfigFiles.trimBackslash(string);
        string2 = SvnConfigFiles.trimBackslash(string2);
        String string3 = "";
        int n = string.lastIndexOf("\\");
        if (n > -1) {
            string3 = string.substring(n + 1);
            if (string3.trim().equals("")) {
                int n2 = string.lastIndexOf("\\", n);
                if (n > -1) {
                    string3 = string.substring(n2 + 1, n);
                }
            }
        } else {
            return "";
        }
        if (string2.endsWith("\\")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2 + "/" + string3;
    }

    private static String trimBackslash(String string) {
        if (string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static {
        WINDOWS_USER_APPDATA = SvnConfigFiles.getAPPDATA();
        WINDOWS_CONFIG_DIR = WINDOWS_USER_APPDATA + "\\Subversion";
        WINDOWS_GLOBAL_CONFIG_DIR = SvnConfigFiles.getGlobalAPPDATA() + "\\Subversion";
        DEFAULT_GLOBAL_IGNORES = SvnConfigFiles.parseGlobalIgnores("*.o *.lo *.la #*# .*.rej *.rej .*~ *~ .#* .DS_Store");
    }

    private class ConfigIniFilePatcher
    implements IniFilePatcher {
        private ConfigIniFilePatcher() {
        }

        public void patch(Ini ini) {
            Ini.Section section = (Ini.Section)ini.get((Object)"auth");
            if (section == null) {
                section = ini.add("auth");
            }
            section.put((Object)"store-auth-creds", (Object)"no");
        }
    }

    private static interface IniFilePatcher {
        public void patch(Ini var1);
    }
}

