/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.svnclientadapter.SvnClientAdapterFactory;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientCallback;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientInvocationHandler;
import org.netbeans.modules.subversion.client.SvnCmdLineClientInvocationHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.client.cli.CommandlineClient;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnClientFactory {
    public static final String JAVAHL_MODULE_CODE_NAME = "org.netbeans.libs.svnjavahlwin32";
    private static final String SUBVERSION_NATIVE_LIBRARY = "subversion.native.library";
    private static SvnClientFactory instance;
    private static ClientAdapterFactory factory;
    private static SVNClientException exception;
    private static boolean javahlCrash;
    private static final int JAVAHL_INIT_SUCCESS = 1;
    private static final int JAVAHL_INIT_STOP_REPORTING = 2;
    private static final Logger LOG;

    private SvnClientFactory() {
    }

    public static synchronized SvnClientFactory getInstance() {
        SvnClientFactory.init();
        return instance;
    }

    public static synchronized void init() {
        if (instance == null) {
            instance = new SvnClientFactory();
            instance.setup();
        }
    }

    public static synchronized void reset() {
        instance = null;
    }

    public static boolean isCLI() {
        SvnClientFactory.init();
        assert (factory != null);
        return factory.connectionType() == ConnectionType.cli;
    }

    public static boolean isJavaHl() {
        SvnClientFactory.init();
        assert (factory != null);
        return factory.connectionType() == ConnectionType.javahl;
    }

    public static boolean isSvnKit() {
        SvnClientFactory.init();
        assert (factory != null);
        return factory.connectionType() == ConnectionType.svnkit;
    }

    public SvnClient createSvnClient() throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
        return factory.createSvnClient();
    }

    public SvnClient createSvnClient(SVNUrl sVNUrl, SvnProgressSupport svnProgressSupport, String string, String string2, int n) throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
        return factory.createSvnClient(sVNUrl, svnProgressSupport, string, string2, n);
    }

    private void setup() {
        block7: {
            try {
                String string = System.getProperty("svnClientAdapterFactory");
                if (string == null || string.trim().equals("") || string.trim().equals("javahl")) {
                    if (!this.setupJavaHl()) {
                        this.setupCommandline();
                    }
                    break block7;
                }
                if (string.trim().equals("svnkit")) {
                    if (!this.setupSvnKit()) {
                        this.setupCommandline();
                    }
                    break block7;
                }
                if (string.trim().equals("commandline")) {
                    this.setupCommandline();
                    break block7;
                }
                throw new SVNClientException("Unknown factory: " + string);
            }
            catch (SVNClientException sVNClientException) {
                exception = sVNClientException;
            }
        }
    }

    public static void checkClientAvailable() throws SVNClientException {
        SvnClientFactory.init();
        if (exception != null) {
            throw exception;
        }
    }

    public static boolean isClientAvailable() {
        SvnClientFactory.init();
        return exception == null;
    }

    public static boolean wasJavahlCrash() {
        SvnClientFactory.init();
        if (javahlCrash) {
            javahlCrash = false;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setupJavaHl() {
        String string = System.getProperty("netbeans.user") + "/config/svn/jhlinit";
        File file = new File(string);
        if (this.checkJavahlCrash(file)) {
            return false;
        }
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, null, iOException);
        }
        this.presetJavahl();
        try {
            if (!SvnClientAdapterFactory.getInstance().setup(SvnClientAdapterFactory.Client.javahl)) {
                LOG.log(Level.INFO, "Could not setup subversion java bindings. Falling back on commandline.");
                boolean bl = false;
                return bl;
            }
            if (!this.checkJavaHlVersion()) {
                LOG.log(Level.INFO, "Unsupported version of subversion javahl bindings. Falling back on commandline.");
                boolean bl = false;
                return bl;
            }
        }
        catch (SVNClientException sVNClientException) {
            LOG.log(Level.WARNING, null, sVNClientException);
        }
        finally {
            this.writeJavahlInitFlag(file, 1);
        }
        factory = new ClientAdapterFactory(){

            protected ISVNClientAdapter createAdapter() {
                return SvnClientAdapterFactory.getInstance().createClient();
            }

            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter iSVNClientAdapter, SvnClientDescriptor svnClientDescriptor, SvnProgressSupport svnProgressSupport, int n) {
                return new SvnClientInvocationHandler(iSVNClientAdapter, svnClientDescriptor, svnProgressSupport, n);
            }

            protected ISVNPromptUserPassword createCallback(SVNUrl sVNUrl, int n) {
                return new SvnClientCallback(sVNUrl, n);
            }

            protected ConnectionType connectionType() {
                return ConnectionType.javahl;
            }
        };
        LOG.info("running on javahl");
        return true;
    }

    private void presetJavahl() {
        if (Utilities.isUnix() && !Utilities.isMac()) {
            this.presetJavahlUnix();
        } else if (Utilities.isWindows()) {
            this.presetJavahlWindows();
        }
    }

    private void presetJavahlUnix() {
        LOG.log(Level.FINE, "looking for svn native library...");
        String string = System.getProperty(SUBVERSION_NATIVE_LIBRARY);
        if (string != null && !string.trim().equals("")) {
            LOG.log(Level.FINE, "won't preset javahl due to subversion.native.library={0}", new Object[]{string});
            return;
        }
        String string2 = "libsvnjavahl-1.so";
        String[] stringArray = new String[]{"/usr/lib/", "/usr/lib/jni/", "/usr/local/lib/"};
        File file = null;
        for (String string3 : stringArray) {
            File file2 = new File(string3, string2);
            LOG.log(Level.FINE, " checking existence of {0}", new Object[]{file2.getAbsolutePath()});
            if (!file2.exists()) continue;
            file = file2;
            break;
        }
        if (file == null) {
            file = this.getJavahlFromExecutablePath(string2);
        }
        if (file != null) {
            System.setProperty(SUBVERSION_NATIVE_LIBRARY, file.getAbsolutePath());
            LOG.log(Level.FINE, "   found javahl library. Setting subversion.native.library={0}", new Object[]{file.getAbsolutePath()});
        }
    }

    private void presetJavahlWindows() {
        String string = System.getProperty(SUBVERSION_NATIVE_LIBRARY);
        if (string != null && !string.trim().equals("")) {
            LOG.log(Level.FINE, "preset subversion.native.library={0}", new Object[]{string});
            int n = string.lastIndexOf(File.separator);
            if (n > -1) {
                string = string.substring(0, n);
                LOG.log(Level.FINE, "loading dependencies from ", new Object[]{string});
                this.loadJavahlDependencies(string);
            }
            return;
        }
        File file = InstalledFileLocator.getDefault().locate("modules/lib/libsvnjavahl-1.dll", JAVAHL_MODULE_CODE_NAME, false);
        if (file == null) {
            LOG.fine("could not find location for bundled javahl library");
            file = this.getJavahlFromExecutablePath("libsvnjavahl-1.dll");
            if (file == null) {
                return;
            }
        }
        LOG.fine("libsvnjavahl-1.dll located : " + file.getAbsolutePath());
        String string2 = file.getParentFile().getAbsolutePath();
        this.loadJavahlDependencies(string2);
        string2 = file.getAbsolutePath();
        LOG.log(Level.FINE, "setting subversion.native.library={0}", new Object[]{string2});
        System.setProperty(SUBVERSION_NATIVE_LIBRARY, string2);
    }

    private void loadJavahlDependencies(String string) {
        try {
            System.load(string + "/libapr-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libapriconv-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libeay32.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libdb44.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/ssleay32.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libaprutil-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/intl3_svn.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/dbghelp.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libsasl.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libsvn_subr-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libsvn_delta-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libsvn_diff-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libsvn_wc-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libsvn_fs-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libsvn_repos-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libsvn_ra-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.load(string + "/libsvn_client-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private File getJavahlFromExecutablePath(String string) {
        String string2 = SvnModuleConfig.getDefault().getExecutableBinaryPath();
        LOG.log(Level.FINE, "looking for svn native library in executable path={0}", new Object[]{string2});
        File file = new File(string2);
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if (file != null && (file = new File(file.getAbsolutePath() + File.separatorChar + string)).exists()) {
            LOG.log(Level.FINE, "found svn native library in executable path={0}", new Object[]{file.getAbsolutePath()});
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkJavahlCrash(File file) {
        if (!file.exists()) {
            LOG.fine("trying to init javahl first time.");
            return false;
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            int n = fileReader.read();
            try {
                fileReader.close();
                fileReader = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            switch (n) {
                case -1: {
                    this.writeJavahlInitFlag(file, 2);
                    javahlCrash = true;
                    LOG.log(Level.WARNING, "It appears that subversion java bindings initialization caused trouble in a previous Netbeans session. Please report.");
                    boolean bl = true;
                    return bl;
                }
                case 2: {
                    LOG.fine("won't init javahl due to problem in a previous try.");
                    boolean bl = true;
                    return bl;
                }
                case 1: {
                    LOG.fine("will try init javahl.");
                    boolean bl = false;
                    return bl;
                }
            }
            return false;
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, null, iOException);
            return false;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJavahlInitFlag(File file, int n) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(n);
            fileWriter.flush();
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, null, iOException);
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean setupSvnKit() {
        try {
            if (!SvnClientAdapterFactory.getInstance().setup(SvnClientAdapterFactory.Client.svnkit)) {
                LOG.log(Level.INFO, "Svnkit not available. Falling back on commandline!");
                return false;
            }
        }
        catch (SVNClientException sVNClientException) {
            LOG.log(Level.INFO, null, sVNClientException);
            LOG.log(Level.INFO, null, sVNClientException.getCause());
            LOG.log(Level.INFO, "Could not setup svnkit. Falling back on commandline!");
            return false;
        }
        factory = new ClientAdapterFactory(){

            protected ISVNClientAdapter createAdapter() {
                return SvnClientAdapterFactory.getInstance().createClient();
            }

            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter iSVNClientAdapter, SvnClientDescriptor svnClientDescriptor, SvnProgressSupport svnProgressSupport, int n) {
                return new SvnClientInvocationHandler(iSVNClientAdapter, svnClientDescriptor, svnProgressSupport, n);
            }

            protected ISVNPromptUserPassword createCallback(SVNUrl sVNUrl, int n) {
                return new SvnClientCallback(sVNUrl, n);
            }

            protected ConnectionType connectionType() {
                return ConnectionType.svnkit;
            }
        };
        LOG.info("svnClientAdapter running on svnkit");
        return true;
    }

    public void setupCommandline() {
        if (!this.checkCLIExecutable()) {
            return;
        }
        factory = new ClientAdapterFactory(){

            protected ISVNClientAdapter createAdapter() {
                return new CommandlineClient();
            }

            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter iSVNClientAdapter, SvnClientDescriptor svnClientDescriptor, SvnProgressSupport svnProgressSupport, int n) {
                return new SvnCmdLineClientInvocationHandler(iSVNClientAdapter, svnClientDescriptor, svnProgressSupport, n);
            }

            protected ISVNPromptUserPassword createCallback(SVNUrl sVNUrl, int n) {
                return null;
            }

            protected ConnectionType connectionType() {
                return ConnectionType.cli;
            }
        };
        LOG.info("running on commandline");
    }

    private boolean checkCLIExecutable() {
        exception = null;
        SVNClientException sVNClientException = null;
        try {
            this.checkVersion();
        }
        catch (SVNClientException sVNClientException2) {
            sVNClientException = sVNClientException2;
        }
        if (sVNClientException == null) {
            LOG.fine("svn client returns correct version");
            return true;
        }
        String string = SvnModuleConfig.getDefault().getExecutableBinaryPath();
        if (string != null && !string.trim().equals("")) {
            exception = sVNClientException;
            LOG.log(Level.WARNING, "executable binary path set to {0} yet client not available.", new Object[]{string});
            return false;
        }
        if (Utilities.isUnix()) {
            LOG.fine("svn client isn't set on path yet. Will check known locations...");
            String[] stringArray = new String[]{"/usr/local/bin/", "/usr/bin/"};
            String string2 = "svn";
            for (String string3 : stringArray) {
                File file = new File(string3, string2);
                LOG.log(Level.FINE, "checking existence of {0}", new Object[]{file.getAbsolutePath()});
                if (!file.exists()) continue;
                SvnModuleConfig.getDefault().setExecutableBinaryPath(string3);
                try {
                    this.checkVersion();
                }
                catch (SVNClientException sVNClientException3) {
                    sVNClientException = sVNClientException3;
                    continue;
                }
                LOG.log(Level.INFO, "found svn executable binary. Setting executable binary path to {0}", new Object[]{string3});
                return true;
            }
        }
        exception = sVNClientException;
        return false;
    }

    private void checkVersion() throws SVNClientException {
        CommandlineClient commandlineClient = new CommandlineClient();
        try {
            commandlineClient.checkSupportedVersion();
        }
        catch (SVNClientException sVNClientException) {
            LOG.log(Level.FINE, "checking version", sVNClientException);
            throw sVNClientException;
        }
    }

    private boolean checkJavaHlVersion() throws SVNClientException {
        return SvnClientAdapterFactory.getInstance().isSupportedJavahlVersion();
    }

    static {
        exception = null;
        javahlCrash = false;
        LOG = Logger.getLogger("org.netbeans.modules.subversion.client.SvnClientFactory");
    }

    private abstract class ClientAdapterFactory {
        private ClientAdapterFactory() {
        }

        protected abstract ISVNClientAdapter createAdapter();

        protected abstract SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter var1, SvnClientDescriptor var2, SvnProgressSupport var3, int var4);

        protected abstract ISVNPromptUserPassword createCallback(SVNUrl var1, int var2);

        protected abstract ConnectionType connectionType();

        SvnClient createSvnClient() {
            SvnClientInvocationHandler svnClientInvocationHandler = this.getInvocationHandler(this.createAdapter(), this.createDescriptor(null), null, -1);
            return this.createSvnClient(svnClientInvocationHandler);
        }

        public SvnClient createSvnClient(SVNUrl sVNUrl, SvnProgressSupport svnProgressSupport, String string, String string2, int n) {
            ISVNClientAdapter iSVNClientAdapter = this.createAdapter();
            SvnClientInvocationHandler svnClientInvocationHandler = this.getInvocationHandler(iSVNClientAdapter, this.createDescriptor(sVNUrl), svnProgressSupport, n);
            this.setupAdapter(iSVNClientAdapter, string, string2, this.createCallback(sVNUrl, n));
            return this.createSvnClient(svnClientInvocationHandler);
        }

        private SvnClientDescriptor createDescriptor(final SVNUrl sVNUrl) {
            return new SvnClientDescriptor(){

                public SVNUrl getSvnUrl() {
                    return sVNUrl;
                }
            };
        }

        private SvnClient createSvnClient(SvnClientInvocationHandler svnClientInvocationHandler) {
            Class<?> clazz = Proxy.getProxyClass(SvnClient.class.getClassLoader(), SvnClient.class);
            Subversion.getInstance().cleanupFilesystem();
            try {
                return (SvnClient)clazz.getConstructor(InvocationHandler.class).newInstance(svnClientInvocationHandler);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, null, exception);
                return null;
            }
        }

        protected void setupAdapter(ISVNClientAdapter iSVNClientAdapter, String string, String string2, ISVNPromptUserPassword iSVNPromptUserPassword) {
            if (iSVNPromptUserPassword != null) {
                iSVNClientAdapter.addPasswordCallback(iSVNPromptUserPassword);
            }
            try {
                File file = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath()));
                iSVNClientAdapter.setConfigDirectory(file);
                iSVNClientAdapter.setUsername(string);
                iSVNClientAdapter.setPassword(string2);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionType {
        javahl,
        cli,
        svnkit;

    }
}

