/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.diff.PatchAction;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.ui.blame.BlameAction;
import org.netbeans.modules.subversion.ui.checkout.CheckoutAction;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.copy.CreateCopyAction;
import org.netbeans.modules.subversion.ui.copy.MergeAction;
import org.netbeans.modules.subversion.ui.copy.SwitchToAction;
import org.netbeans.modules.subversion.ui.diff.DiffAction;
import org.netbeans.modules.subversion.ui.diff.ExportDiffAction;
import org.netbeans.modules.subversion.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.ui.ignore.IgnoreAction;
import org.netbeans.modules.subversion.ui.project.ImportAction;
import org.netbeans.modules.subversion.ui.properties.SvnPropertiesAction;
import org.netbeans.modules.subversion.ui.relocate.RelocateAction;
import org.netbeans.modules.subversion.ui.status.StatusAction;
import org.netbeans.modules.subversion.ui.update.ResolveConflictsAction;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.ui.update.UpdateAction;
import org.netbeans.modules.subversion.ui.update.UpdateWithDependenciesAction;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Annotator {
    private static MessageFormat uptodateFormat = Annotator.getFormat("uptodateFormat");
    private static MessageFormat newLocallyFormat = Annotator.getFormat("newLocallyFormat");
    private static MessageFormat addedLocallyFormat = Annotator.getFormat("addedLocallyFormat");
    private static MessageFormat modifiedLocallyFormat = Annotator.getFormat("modifiedLocallyFormat");
    private static MessageFormat removedLocallyFormat = Annotator.getFormat("removedLocallyFormat");
    private static MessageFormat deletedLocallyFormat = Annotator.getFormat("deletedLocallyFormat");
    private static MessageFormat newInRepositoryFormat = Annotator.getFormat("newInRepositoryFormat");
    private static MessageFormat modifiedInRepositoryFormat = Annotator.getFormat("modifiedInRepositoryFormat");
    private static MessageFormat removedInRepositoryFormat = Annotator.getFormat("removedInRepositoryFormat");
    private static MessageFormat conflictFormat = Annotator.getFormat("conflictFormat");
    private static MessageFormat mergeableFormat = Annotator.getFormat("mergeableFormat");
    private static MessageFormat excludedFormat = Annotator.getFormat("excludedFormat");
    private static MessageFormat newLocallyTooltipFormat = Annotator.getFormat("newLocallyTooltipFormat");
    private static MessageFormat addedLocallyTooltipFormat = Annotator.getFormat("addedLocallyTooltipFormat");
    private static MessageFormat modifiedLocallyTooltipFormat = Annotator.getFormat("modifiedLocallyTooltipFormat");
    private static MessageFormat removedLocallyTooltipFormat = Annotator.getFormat("removedLocallyTooltipFormat");
    private static MessageFormat deletedLocallyTooltipFormat = Annotator.getFormat("deletedLocallyTooltipFormat");
    private static MessageFormat newInRepositoryTooltipFormat = Annotator.getFormat("newInRepositoryTooltipFormat");
    private static MessageFormat modifiedInRepositoryTooltipFormat = Annotator.getFormat("modifiedInRepositoryTooltipFormat");
    private static MessageFormat removedInRepositoryTooltipFormat = Annotator.getFormat("removedInRepositoryTooltipFormat");
    private static MessageFormat conflictTooltipFormat = Annotator.getFormat("conflictTooltipFormat");
    private static MessageFormat mergeableTooltipFormat = Annotator.getFormat("mergeableTooltipFormat");
    private static MessageFormat excludedTooltipFormat = Annotator.getFormat("excludedTooltipFormat");
    private static String badgeModified = "org/netbeans/modules/subversion/resources/icons/modified-badge.png";
    private static String badgeConflicts = "org/netbeans/modules/subversion/resources/icons/conflicts-badge.png";
    private static String toolTipModified = "<img src=\"" + Annotator.class.getClassLoader().getResource(badgeModified) + "\">&nbsp;" + NbBundle.getMessage(Annotator.class, (String)"MSG_Contains_Modified_Locally");
    private static String toolTipConflict = "<img src=\"" + Annotator.class.getClassLoader().getResource(badgeConflicts) + "\">&nbsp;" + NbBundle.getMessage(Annotator.class, (String)"MSG_Contains_Conflicts");
    private static final int STATUS_TEXT_ANNOTABLE = 6494;
    private static final Pattern lessThan = Pattern.compile("<");
    public static String ANNOTATION_REVISION = "revision";
    public static String ANNOTATION_STATUS = "status";
    public static String ANNOTATION_FOLDER = "folder";
    public static String ANNOTATION_MIME_TYPE = "mime_type";
    public static String[] LABELS = new String[]{ANNOTATION_REVISION, ANNOTATION_STATUS, ANNOTATION_FOLDER, ANNOTATION_MIME_TYPE};
    private final FileStatusCache cache;
    private MessageFormat format;
    private String emptyFormat;
    private boolean mimeTypeFlag;
    private static final int STATUS_BADGEABLE = 28;

    Annotator(Subversion subversion) {
        this.cache = subversion.getStatusCache();
        this.initDefaults();
    }

    private void initDefaults() {
        Field[] fieldArray = Annotator.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            if (!string.endsWith("Format")) continue;
            this.initDefaultColor(string.substring(0, string.length() - 6));
        }
        this.refresh();
    }

    public void refresh() {
        String string = SvnModuleConfig.getDefault().getAnnotationFormat();
        if (string != null && !string.trim().equals("")) {
            this.mimeTypeFlag = string.indexOf("{mime_type}") > -1;
            if (!SvnUtils.isAnnotationFormatValid(string = SvnUtils.createAnnotationFormat(string))) {
                Subversion.LOG.log(Level.WARNING, "Bad annotation format, switching to defaults");
                string = NbBundle.getMessage(Annotator.class, (String)"Annotator.defaultFormat");
                this.mimeTypeFlag = string.contains("{3}");
            }
            this.format = new MessageFormat(string);
            this.emptyFormat = this.format.format(new String[]{"", "", "", ""}, new StringBuffer(), (FieldPosition)null).toString().trim();
        }
    }

    private void initDefaultColor(String string) {
        String string2 = System.getProperty("svn.color." + string);
        if (string2 == null) {
            return;
        }
        this.setAnnotationColor(string, string2);
    }

    private void setAnnotationColor(String string, String string2) {
        try {
            Field field = Annotator.class.getDeclaredField(string + "Format");
            MessageFormat messageFormat = new MessageFormat("<font color=\"" + string2 + "\">{0}</font><font color=\"#999999\">{1}</font>");
            field.set(null, messageFormat);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid color name");
        }
    }

    public String annotateNameHtml(String string, FileInformation fileInformation, File file) {
        String string2;
        if (!SvnClientFactory.isClientAvailable()) {
            Subversion.LOG.fine(" skipping annotateNameHtml due to missing client");
            return string;
        }
        string = this.htmlEncode(string);
        int n = fileInformation.getStatus();
        boolean bl = VersioningSupport.getPreferences().getBoolean("textAnnotationsVisible", false);
        if (bl && file != null && (n & 0x195E) != 0) {
            if (this.format != null) {
                string2 = this.formatAnnotation(fileInformation, file);
            } else {
                String string3;
                String string4 = SvnUtils.getCopy(file);
                string2 = n == 8 && string4 == null ? "" : (n == 8 ? " [" + string4 + "]" : (string4 == null ? (!(string3 = fileInformation.getShortStatusText()).equals("") ? " [" + fileInformation.getShortStatusText() + "]" : "") : " [" + fileInformation.getShortStatusText() + "; " + string4 + "]"));
            }
        } else {
            string2 = "";
        }
        if (string2.length() > 0) {
            string2 = NbBundle.getMessage(Annotator.class, (String)"textAnnotation", (Object)string2);
        }
        if (0 != (n & 0x40)) {
            return conflictFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x80)) {
            return mergeableFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x800)) {
            return deletedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x100)) {
            return removedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 4)) {
            return newLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x1000)) {
            return addedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x10)) {
            return modifiedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x400)) {
            return removedInRepositoryFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x200)) {
            return newInRepositoryFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x20)) {
            return modifiedInRepositoryFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 8)) {
            return uptodateFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 2)) {
            return excludedFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 1)) {
            return string;
        }
        if (n == 0) {
            return string;
        }
        throw new IllegalArgumentException("Unknown status: " + n);
    }

    private String formatAnnotation(FileInformation fileInformation, File file) {
        Object[] objectArray;
        String string;
        Object object;
        String string2 = "";
        int n = fileInformation.getStatus();
        if (n != 8) {
            string2 = fileInformation.getShortStatusText();
        }
        String string3 = "";
        String string4 = "";
        ISVNStatus iSVNStatus = fileInformation.getEntry(file);
        if (iSVNStatus != null) {
            object = iSVNStatus.getRevision();
            String string5 = string3 = object != null ? object.toString() : "";
            if (this.mimeTypeFlag) {
                string4 = this.getMimeType(file);
            }
        }
        if ((object = SvnUtils.getCopy(file)) == null) {
            object = "";
        }
        if ((string = this.format.format(objectArray = new Object[]{string3, string2, object, string4}, new StringBuffer(), (FieldPosition)null).toString().trim()).equals(this.emptyFormat)) {
            return "";
        }
        return " " + string;
    }

    private String getMimeType(File file) {
        try {
            SvnClient svnClient = Subversion.getInstance().getClient(false);
            ISVNProperty iSVNProperty = svnClient.propertyGet(file, "svn:mime-type");
            if (iSVNProperty != null) {
                String string = iSVNProperty.getValue();
                return string != null ? string : "";
            }
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            return "";
        }
        return "";
    }

    private String annotateFolderNameHtml(String string, FileInformation fileInformation, File file) {
        String string2;
        string = this.htmlEncode(string);
        int n = fileInformation.getStatus();
        boolean bl = VersioningSupport.getPreferences().getBoolean("textAnnotationsVisible", false);
        if (bl && file != null && (n & 0xFFFFFFFE) != 0) {
            if (this.format != null) {
                string2 = this.formatAnnotation(fileInformation, file);
            } else {
                String string3;
                ISVNStatus iSVNStatus = fileInformation.getEntry(file);
                String string4 = iSVNStatus != null && iSVNStatus.getUrl() != null ? SvnUtils.getCopy(iSVNStatus.getUrl()) : SvnUtils.getCopy(file);
                string2 = n == 8 && string4 == null ? "" : (n == 8 ? " [" + string4 + "]" : (string4 == null ? (!(string3 = fileInformation.getShortStatusText()).equals("") ? " [" + fileInformation.getShortStatusText() + "]" : "") : " [" + fileInformation.getShortStatusText() + "; " + string4 + "]"));
            }
        } else {
            string2 = "";
        }
        if (string2.length() > 0) {
            string2 = NbBundle.getMessage(Annotator.class, (String)"textAnnotation", (Object)string2);
        }
        if (n == 0) {
            return string;
        }
        if (Annotator.match(n, 256)) {
            return string;
        }
        if (Annotator.match(n, 4)) {
            return uptodateFormat.format(new Object[]{string, string2});
        }
        if (Annotator.match(n, 4096)) {
            return uptodateFormat.format(new Object[]{string, string2});
        }
        if (Annotator.match(n, 8)) {
            return uptodateFormat.format(new Object[]{string, string2});
        }
        if (Annotator.match(n, 2)) {
            return excludedFormat.format(new Object[]{string, string2});
        }
        if (Annotator.match(n, 2048)) {
            return string;
        }
        if (Annotator.match(n, 512)) {
            return string;
        }
        if (Annotator.match(n, 32)) {
            return string;
        }
        if (Annotator.match(n, 1024)) {
            return string;
        }
        if (Annotator.match(n, 1)) {
            return string;
        }
        if (Annotator.match(n, 128)) {
            return string;
        }
        if (Annotator.match(n, 16)) {
            return string;
        }
        if (Annotator.match(n, 64)) {
            return string;
        }
        throw new IllegalArgumentException("Unknown status: " + n);
    }

    private static boolean match(int n, int n2) {
        return (n & n2) != 0;
    }

    private String htmlEncode(String string) {
        if (string.indexOf(60) == -1) {
            return string;
        }
        return lessThan.matcher(string).replaceAll("&lt;");
    }

    public String annotateNameHtml(File file, FileInformation fileInformation) {
        return this.annotateNameHtml(file.getName(), fileInformation, file);
    }

    public String annotateNameHtml(String string, VCSContext vCSContext, int n) {
        if (!SvnClientFactory.isClientAvailable()) {
            Subversion.LOG.fine(" skipping annotateNameHtml due to missing client");
            return string;
        }
        FileInformation fileInformation = null;
        File file = null;
        boolean bl = false;
        for (File file2 : vCSContext.getRootFiles()) {
            int n2;
            FileInformation fileInformation2 = this.cache.getCachedStatus(file2);
            if (fileInformation2 == null) {
                File file3 = file2.getParentFile();
                Subversion.LOG.log(Level.FINE, "null cached status for: {0} in {1}", new Object[]{file2, file3});
                this.cache.refreshAsync(file2);
                fileInformation2 = new FileInformation(8, false);
            }
            if (((n2 = fileInformation2.getStatus()) & n) == 0 || !this.isMoreImportant(fileInformation2, fileInformation)) continue;
            fileInformation = fileInformation2;
            file = file2;
            bl = file2.isDirectory();
        }
        if (!bl && vCSContext.getRootFiles().size() > 1) {
            boolean bl2 = bl = !Utils.shareCommonDataObject((File[])vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]));
        }
        if (fileInformation == null) {
            return null;
        }
        return bl ? this.annotateFolderNameHtml(string, fileInformation, file) : this.annotateNameHtml(string, fileInformation, file);
    }

    private boolean isMoreImportant(FileInformation fileInformation, FileInformation fileInformation2) {
        if (fileInformation2 == null) {
            return true;
        }
        if (fileInformation == null) {
            return false;
        }
        return SvnUtils.getComparableStatus(fileInformation.getStatus()) < SvnUtils.getComparableStatus(fileInformation2.getStatus());
    }

    String annotateName(String string, Set set) {
        return null;
    }

    public static Action[] getActions(VCSContext vCSContext, VCSAnnotator.ActionDestination actionDestination) {
        ResourceBundle resourceBundle = NbBundle.getBundle(Annotator.class);
        Node[] nodeArray = vCSContext.getElements().lookupAll(Node.class).toArray(new Node[0]);
        File[] fileArray = vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]);
        Lookup lookup = vCSContext.getElements();
        boolean bl = Annotator.isNothingVersioned(fileArray);
        boolean bl2 = Annotator.onlyFolders(fileArray);
        boolean bl3 = Annotator.onlyProjects(nodeArray);
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        if (actionDestination == VCSAnnotator.ActionDestination.MainMenu) {
            arrayList.add(SystemAction.get(CheckoutAction.class));
            arrayList.add(SystemAction.get(ImportAction.class));
            arrayList.add(SystemAction.get(RelocateAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(UpdateWithDependenciesAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(StatusAction.class));
            arrayList.add(SystemAction.get(DiffAction.class));
            arrayList.add(SystemAction.get(UpdateAction.class));
            arrayList.add(SystemAction.get(CommitAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(ExportDiffAction.class));
            arrayList.add(SystemAction.get(PatchAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(CreateCopyAction.class));
            arrayList.add(SystemAction.get(SwitchToAction.class));
            arrayList.add(SystemAction.get(MergeAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(BlameAction.class));
            arrayList.add(SystemAction.get(SearchHistoryAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(RevertModificationsAction.class));
            arrayList.add(SystemAction.get(ResolveConflictsAction.class));
            arrayList.add(SystemAction.get(IgnoreAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(SvnPropertiesAction.class));
        } else if (bl) {
            arrayList.add(SystemActionBridge.createAction((Action)((ImportAction)SystemAction.get(ImportAction.class)).createContextAwareInstance(lookup), (String)resourceBundle.getString("CTL_PopupMenuItem_Import"), (Lookup)lookup));
        } else {
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(StatusAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Status"), (Lookup)lookup));
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(DiffAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Diff"), (Lookup)lookup));
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(UpdateAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Update"), (Lookup)lookup));
            if (bl3) {
                arrayList.add(new SystemActionBridge((Action)SystemAction.get(UpdateWithDependenciesAction.class), resourceBundle.getString("CTL_PopupMenuItem_UpdateWithDeps")));
            }
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Commit"), (Lookup)lookup));
            arrayList.add(null);
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(CreateCopyAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Copy"), (Lookup)lookup));
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(SwitchToAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Switch"), (Lookup)lookup));
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(MergeAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Merge"), (Lookup)lookup));
            arrayList.add(null);
            if (!bl2) {
                arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(BlameAction.class), (String)(((BlameAction)SystemAction.get(BlameAction.class)).visible(nodeArray) ? resourceBundle.getString("CTL_PopupMenuItem_HideAnnotations") : resourceBundle.getString("CTL_PopupMenuItem_ShowAnnotations")), (Lookup)lookup));
            }
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(SearchHistoryAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_SearchHistory"), (Lookup)lookup));
            arrayList.add(null);
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(RevertModificationsAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_GetClean"), (Lookup)lookup));
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(ResolveConflictsAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_ResolveConflicts"), (Lookup)lookup));
            if (!bl3) {
                arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(IgnoreAction.class), (String)(((IgnoreAction)SystemAction.get(IgnoreAction.class)).getActionStatus(nodeArray) == 2 ? resourceBundle.getString("CTL_PopupMenuItem_Unignore") : resourceBundle.getString("CTL_PopupMenuItem_Ignore")), (Lookup)lookup));
            }
            arrayList.add(null);
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(SvnPropertiesAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Properties"), (Lookup)lookup));
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static boolean isNothingVersioned(File[] fileArray) {
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        for (File file : fileArray) {
            if ((fileStatusCache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyProjects(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        for (Node node : nodeArray) {
            if (node.getLookup().lookup(Project.class) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyFolders(File[] fileArray) {
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                return false;
            }
            if (fileArray[i].exists() || fileStatusCache.getStatus(fileArray[i]).isDirectory()) continue;
            return false;
        }
        return true;
    }

    private static MessageFormat getFormat(String string) {
        String string2 = NbBundle.getMessage(Annotator.class, (String)string);
        return new MessageFormat(string2);
    }

    public Image annotateIcon(Image image, VCSContext vCSContext, int n) {
        if (!SvnClientFactory.isClientAvailable()) {
            Subversion.LOG.fine(" skipping annotateIcon due to missing client");
            return null;
        }
        boolean bl = false;
        for (File file : vCSContext.getRootFiles()) {
            if (!file.isDirectory()) continue;
            bl = true;
            break;
        }
        if (!bl && vCSContext.getRootFiles().size() > 1) {
            boolean bl2 = bl = !Utils.shareCommonDataObject((File[])vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]));
        }
        if (!bl) {
            return this.annotateFileIcon(vCSContext, image, n);
        }
        return this.annotateFolderIcon(vCSContext, image);
    }

    private Image annotateFileIcon(VCSContext vCSContext, Image image, int n) {
        FileInformation fileInformation = null;
        for (File file : vCSContext.getRootFiles()) {
            int n2;
            FileInformation fileInformation2 = this.cache.getCachedStatus(file);
            if (fileInformation2 == null) {
                File file2 = file.getParentFile();
                Subversion.LOG.log(Level.FINE, "null cached status for: {0} in {1}", new Object[]{file, file2});
                this.cache.refreshAsync(file);
                fileInformation2 = new FileInformation(8, false);
            }
            if (((n2 = fileInformation2.getStatus()) & n) == 0 || !this.isMoreImportant(fileInformation2, fileInformation)) continue;
            fileInformation = fileInformation2;
        }
        if (fileInformation == null) {
            return null;
        }
        Object object = null;
        int n3 = fileInformation.getStatus();
        if (0 != (n3 & 0x40)) {
            object = conflictTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n3 & 0x80)) {
            object = mergeableTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n3 & 0x800)) {
            object = deletedLocallyTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n3 & 0x100)) {
            object = removedLocallyTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n3 & 4)) {
            object = newLocallyTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n3 & 0x1000)) {
            object = addedLocallyTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n3 & 0x10)) {
            object = modifiedLocallyTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n3 & 0x400)) {
            object = removedInRepositoryTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n3 & 0x200)) {
            object = newInRepositoryTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n3 & 0x20)) {
            object = modifiedInRepositoryTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n3 & 8)) {
            object = null;
        } else if (0 != (n3 & 2)) {
            object = excludedTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n3 & 1)) {
            object = null;
        } else if (n3 == 0) {
            object = null;
        } else {
            throw new IllegalArgumentException("Unknown status: " + n3);
        }
        return object != null ? ImageUtilities.addToolTipToImage((Image)image, (String)object) : null;
    }

    private Image annotateFolderIcon(VCSContext vCSContext, Image image) {
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        boolean bl = false;
        for (File file : vCSContext.getRootFiles()) {
            if ((fileStatusCache.getStatus(file).getStatus() & 0x1C) == 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        SvnModuleConfig svnModuleConfig = SvnModuleConfig.getDefault();
        boolean bl2 = true;
        boolean bl3 = false;
        Map<File, FileInformation> map = fileStatusCache.getAllModifiedFiles();
        HashMap hashMap = new HashMap();
        for (File file : map.keySet()) {
            FileInformation fileInformation = map.get(file);
            if (fileInformation != null) {
                if ((fileInformation.getStatus() & 0x19D4) == 0) continue;
                hashMap.put(file, fileInformation);
                continue;
            }
            Subversion.LOG.log(Level.WARNING, "null FileInformation returned for {0}", new Object[]{file});
        }
        for (File file : vCSContext.getRootFiles()) {
            int n;
            FileInformation fileInformation;
            if (VersioningSupport.isFlat((File)file)) {
                for (File file2 : hashMap.keySet()) {
                    if (file2 == null) {
                        Subversion.LOG.log(Level.WARNING, "null File entry returned from getAllModifiedFiles");
                        continue;
                    }
                    if (!file.equals(file2.getParentFile()) || (fileInformation = (FileInformation)hashMap.get(file2)).isDirectory()) continue;
                    n = fileInformation.getStatus();
                    if (n == 64) {
                        Image image2 = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeConflicts, (boolean)true), (String)toolTipConflict);
                        return ImageUtilities.mergeImages((Image)image, (Image)image2, (int)16, (int)9);
                    }
                    bl3 = true;
                    bl2 &= svnModuleConfig.isExcludedFromCommit(file2.getAbsolutePath());
                }
                continue;
            }
            for (File file2 : hashMap.keySet()) {
                if (file2 == null) {
                    Subversion.LOG.log(Level.WARNING, "null File entry returned from getAllModifiedFiles");
                    continue;
                }
                if (!Utils.isAncestorOrEqual((File)file, (File)file2) || ((n = (fileInformation = (FileInformation)hashMap.get(file2)).getStatus()) == 4 || n == 4096) && file.equals(file2)) continue;
                if (n == 64) {
                    Image image3 = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeConflicts, (boolean)true), (String)toolTipConflict);
                    return ImageUtilities.mergeImages((Image)image, (Image)image3, (int)16, (int)9);
                }
                bl3 = true;
                bl2 &= svnModuleConfig.isExcludedFromCommit(file2.getAbsolutePath());
            }
        }
        if (bl3 && !bl2) {
            Image image4 = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeModified, (boolean)true), (String)toolTipModified);
            return ImageUtilities.mergeImages((Image)image, (Image)image4, (int)16, (int)9);
        }
        return null;
    }
}

