/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.lexer;

import java.io.IOException;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.lexer.Lexer;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.lexer.StrTerm;
import org.jrubyparser.lexer.StringTerm;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.lexer.Token;
import org.jrubyparser.util.CStringBuilder;

public class HeredocTerm
extends StrTerm {
    private final String marker;
    private final int flags;
    private final String lastLine;

    public HeredocTerm(String marker, int func, String lastLine) {
        this.marker = marker;
        this.flags = func;
        this.lastLine = lastLine;
    }

    public int parseString(Lexer lexer, LexerSource src) throws IOException {
        SourcePosition position;
        boolean done;
        boolean indent;
        boolean bl = indent = (this.flags & 0x20) != 0;
        if (src.peek(-1)) {
            this.syntaxError(src);
        }
        if (lexer.getPreserveSpaces() && (done = src.matchMarker(this.marker, indent, true))) {
            lexer.yaccValue = new StrNode(lexer.getPosition(), "");
            lexer.setStrTerm(new StringTerm(-1, 0, 0));
            src.setIsANewLine(true);
            return 372;
        }
        if (src.lastWasBeginOfLine() && src.matchMarker(this.marker, indent, true)) {
            SourcePosition position2 = lexer.getPosition();
            this.unreadLastLine(src);
            lexer.yaccValue = new Token(this.marker, position2);
            return 372;
        }
        CStringBuilder str = new CStringBuilder();
        if ((this.flags & 2) == 0) {
            do {
                str.append(src.readLineBytes());
                str.append(10);
                if (src.peek(-1)) {
                    this.syntaxError(src);
                }
                position = lexer.getPosition();
            } while (!src.matchMarker(this.marker, indent, true));
        } else {
            int c = src.read();
            if (c == 35) {
                c = src.read();
                switch (c) {
                    case 36: 
                    case 64: {
                        if (this.processingEmbedded == 1) {
                            this.processingEmbedded = 3;
                        }
                        src.unread(c);
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 371;
                    }
                    case 123: {
                        if (this.processingEmbedded == 1) {
                            this.processingEmbedded = 2;
                        }
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 370;
                    }
                }
                str.append(35);
            }
            src.unread(c);
            do {
                StringTerm stringTerm = new StringTerm(this.flags, 0, 10);
                stringTerm.processingEmbedded = this.processingEmbedded;
                c = stringTerm.parseStringIntoBuffer(lexer, src, str);
                if (c == -1) {
                    this.syntaxError(src);
                }
                if (this.processingEmbedded == 3 || this.processingEmbedded == 2) {
                    this.processingEmbedded = 1;
                }
                if (c != 10) {
                    lexer.yaccValue = new StrNode(lexer.getPosition(), str.toString());
                    return 377;
                }
                str.append(src.read());
                if (src.peek(-1)) {
                    this.syntaxError(src);
                }
                position = lexer.getPosition();
            } while (!src.matchMarker(this.marker, indent, true));
        }
        if (this.processingEmbedded == 3) {
            this.processingEmbedded = 1;
        }
        this.unreadLastLine(src);
        if (this.lastLine == null) {
            src.unreadMany(this.marker + "\n");
        } else {
            lexer.setStrTerm(new StringTerm(-1, 0, 0));
        }
        lexer.yaccValue = new StrNode(position, str.toString());
        return 377;
    }

    private void syntaxError(LexerSource src) {
        throw new SyntaxException(SyntaxException.PID.STRING_MARKER_MISSING, src.getPosition(), "can't find string \"" + this.marker + "\" anywhere before EOF", this.marker);
    }

    public boolean isSubstituting() {
        return (this.flags & 2) != 0;
    }

    public Object getMutableState() {
        return new MutableTermState(this.processingEmbedded);
    }

    public void setMutableState(Object o) {
        MutableTermState state = (MutableTermState)o;
        if (state != null) {
            this.processingEmbedded = state.processingEmbedded;
        }
    }

    public void splitEmbeddedTokens() {
        if (this.processingEmbedded == 0) {
            this.processingEmbedded = 1;
        }
    }

    private void unreadLastLine(LexerSource src) {
        if (this.lastLine != null) {
            src.unreadMany(this.lastLine);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HeredocTerm other = (HeredocTerm)obj;
        return this.marker == other.marker || this.marker != null && this.marker.equals(other.marker) && this.flags == other.flags && (this.lastLine == other.lastLine || this.lastLine != null && this.lastLine.equals(other.lastLine));
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.marker != null ? this.marker.hashCode() : 0);
        hash = 83 * hash + this.flags;
        hash = 83 * hash + (this.lastLine != null ? this.lastLine.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "HeredocTerm[" + this.flags + "," + this.marker + "," + this.lastLine + "," + this.processingEmbedded + "]";
    }

    private class MutableTermState {
        private int processingEmbedded;

        private MutableTermState(int embeddedCode) {
            this.processingEmbedded = embeddedCode;
        }

        public boolean equals(Object obj) {
            if (obj == null && this.getClass() != obj.getClass()) {
                return false;
            }
            MutableTermState other = (MutableTermState)obj;
            return this.processingEmbedded == other.processingEmbedded;
        }

        public int hashCode() {
            return 581 + this.processingEmbedded;
        }

        public String toString() {
            return "HeredocTermState[" + this.processingEmbedded + "]";
        }
    }
}

