/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyExecutionDescriptor {
    File pwd;
    File cmd;
    boolean addBinPath;
    boolean inputVisible;
    private String displayName;
    Runnable postBuildAction;
    private final RubyPlatform platform;
    private LineConvertors.FileLocator fileLocator;
    String script;
    private String scriptPrefix;
    private Map<String, String> additionalEnv;
    private String[] additionalArgs;
    private String initialArgs;
    private String jvmArgs;
    private FileObject fileObject;
    private String classPath;
    boolean showProgress = true;
    boolean showSuspended;
    boolean frontWindow = true;
    boolean debug;
    private boolean fastDebugRequired;
    private boolean appendJdkToPath;
    private String encoding;
    private boolean useInterpreter;
    private boolean runThroughRuby = true;
    private final List<LineConvertor> outConvertors = new ArrayList<LineConvertor>();
    private final List<LineConvertor> errConvertors = new ArrayList<LineConvertor>();
    private ExecutionDescriptor.InputProcessorFactory outProcessorFactory;
    private ExecutionDescriptor.InputProcessorFactory errProcessorFactory;
    private boolean addStandardConvertors;
    private boolean lineBased;
    private boolean rerun = true;

    public RubyExecutionDescriptor(RubyPlatform rubyPlatform) {
        this(rubyPlatform, null, null);
    }

    public RubyExecutionDescriptor(RubyPlatform rubyPlatform, String string, File file) {
        this(rubyPlatform, string, file, null);
    }

    public RubyExecutionDescriptor(RubyPlatform rubyPlatform, String string, File file, String string2) {
        HashMap<String, String> hashMap;
        this.platform = rubyPlatform;
        this.displayName = string;
        this.pwd = file;
        this.script = string2;
        this.useInterpreter = true;
        assert (file == null || file.isDirectory()) : file + " is a directory";
        if (rubyPlatform.hasRubyGemsInstalled()) {
            hashMap = new HashMap<String, String>();
            GemManager.adjustEnvironment(rubyPlatform, hashMap);
            this.addAdditionalEnv(hashMap);
        }
        if (rubyPlatform.isJRuby()) {
            hashMap = new HashMap();
            String string3 = rubyPlatform.getHome().getAbsolutePath();
            hashMap.put("JRUBY_HOME", string3);
            hashMap.put("JRUBY_BASE", string3);
            hashMap.put("JAVA_HOME", ExecutionUtils.getJavaHome());
            this.addAdditionalEnv(hashMap);
        }
    }

    public RubyExecutionDescriptor(RubyExecutionDescriptor rubyExecutionDescriptor) {
        this.pwd = rubyExecutionDescriptor.pwd;
        this.cmd = rubyExecutionDescriptor.cmd;
        this.addBinPath = rubyExecutionDescriptor.addBinPath;
        this.inputVisible = rubyExecutionDescriptor.inputVisible;
        this.displayName = rubyExecutionDescriptor.displayName;
        this.postBuildAction = rubyExecutionDescriptor.postBuildAction;
        this.platform = rubyExecutionDescriptor.platform;
        this.fileLocator = rubyExecutionDescriptor.fileLocator;
        this.script = rubyExecutionDescriptor.script;
        this.scriptPrefix = rubyExecutionDescriptor.scriptPrefix;
        this.additionalEnv = rubyExecutionDescriptor.additionalEnv;
        this.additionalArgs = rubyExecutionDescriptor.additionalArgs;
        this.initialArgs = rubyExecutionDescriptor.initialArgs;
        this.jvmArgs = rubyExecutionDescriptor.jvmArgs;
        this.fileObject = rubyExecutionDescriptor.fileObject;
        this.classPath = rubyExecutionDescriptor.classPath;
        this.showSuspended = rubyExecutionDescriptor.showSuspended;
        this.debug = rubyExecutionDescriptor.debug;
        this.fastDebugRequired = rubyExecutionDescriptor.fastDebugRequired;
        this.appendJdkToPath = rubyExecutionDescriptor.appendJdkToPath;
        this.encoding = rubyExecutionDescriptor.encoding;
        this.useInterpreter = rubyExecutionDescriptor.useInterpreter;
        this.outProcessorFactory = rubyExecutionDescriptor.outProcessorFactory;
        this.errProcessorFactory = rubyExecutionDescriptor.errProcessorFactory;
        this.outConvertors.addAll(rubyExecutionDescriptor.outConvertors);
        this.errConvertors.addAll(rubyExecutionDescriptor.errConvertors);
        this.addStandardConvertors = rubyExecutionDescriptor.addStandardConvertors;
        this.lineBased = rubyExecutionDescriptor.lineBased;
    }

    public RubyExecutionDescriptor cmd(File file) {
        this.cmd = file;
        assert (file != null && file.isFile()) : file + " must be a file";
        return this;
    }

    public RubyExecutionDescriptor postBuild(Runnable runnable) {
        this.postBuildAction = runnable;
        return this;
    }

    public RubyExecutionDescriptor fileLocator(LineConvertors.FileLocator fileLocator) {
        this.fileLocator = fileLocator;
        return this;
    }

    public RubyExecutionDescriptor fileObject(FileObject fileObject) {
        this.fileObject = fileObject;
        return this;
    }

    public RubyExecutionDescriptor addStandardRecognizers() {
        this.addStandardConvertors = true;
        return this;
    }

    public RubyExecutionDescriptor allowInput() {
        this.inputVisible = true;
        return this;
    }

    public RubyExecutionDescriptor script(String string) {
        this.script = string;
        return this;
    }

    public RubyExecutionDescriptor showProgress(boolean bl) {
        this.showProgress = bl;
        return this;
    }

    public RubyExecutionDescriptor showSuspended(boolean bl) {
        this.showSuspended = bl;
        return this;
    }

    public RubyExecutionDescriptor additionalArgs(String ... stringArray) {
        this.additionalArgs = stringArray;
        return this;
    }

    public RubyExecutionDescriptor initialArgs(String string) {
        this.initialArgs = string;
        return this;
    }

    public RubyExecutionDescriptor addInitialArgs(String string) {
        if (string == null || "".equals(string)) {
            return this;
        }
        this.initialArgs = this.initialArgs == null || "".equals(this.initialArgs) ? string : this.initialArgs + " " + string;
        return this;
    }

    public RubyExecutionDescriptor jvmArguments(String string) {
        this.jvmArgs = string;
        return this;
    }

    public RubyExecutionDescriptor addBinPath(boolean bl) {
        this.addBinPath = bl;
        return this;
    }

    public RubyExecutionDescriptor frontWindow(boolean bl) {
        this.frontWindow = bl;
        return this;
    }

    public RubyExecutionDescriptor debug(boolean bl) {
        this.debug = bl;
        return this;
    }

    public RubyExecutionDescriptor fastDebugRequired(boolean bl) {
        this.fastDebugRequired = bl;
        return this;
    }

    public RubyExecutionDescriptor runThroughRuby(boolean bl) {
        this.runThroughRuby = bl;
        return this;
    }

    public RubyExecutionDescriptor appendJdkToPath(boolean bl) {
        this.appendJdkToPath = bl;
        return this;
    }

    public RubyExecutionDescriptor classPath(String string) {
        this.classPath = string;
        return this;
    }

    public String getDisplayName() {
        return this.debug ? this.displayName + " (debug)" : this.displayName;
    }

    public RubyPlatform getPlatform() {
        return this.platform;
    }

    public boolean isRunThroughRuby() {
        return this.runThroughRuby;
    }

    public File getCmd() {
        return this.cmd;
    }

    public String getScript() {
        return this.script;
    }

    public void scriptPrefix(String string) {
        this.scriptPrefix = string;
    }

    public String getScriptPrefix() {
        return this.scriptPrefix;
    }

    public Runnable getPostBuild() {
        return this.postBuildAction;
    }

    public String[] getAdditionalArgs() {
        return this.additionalArgs;
    }

    public String[] getInitialArgs() {
        return this.initialArgs == null ? null : Utilities.parseParameters((String)this.initialArgs);
    }

    public String getInitialArgsPlain() {
        return this.initialArgs;
    }

    public String[] getJVMArguments() {
        return this.jvmArgs == null ? null : Utilities.parseParameters((String)this.jvmArgs);
    }

    public File getPwd() {
        return this.pwd;
    }

    public boolean isFastDebugRequired() {
        return this.fastDebugRequired;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public LineConvertors.FileLocator getFileLocator() {
        return this.fileLocator;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    String getEncoding() {
        return this.encoding;
    }

    public boolean getAppendJdkToPath() {
        return this.appendJdkToPath;
    }

    public void addAdditionalEnv(Map<String, String> map) {
        if (this.additionalEnv == null) {
            this.additionalEnv = new HashMap<String, String>();
        }
        this.additionalEnv.putAll(map);
    }

    public Map<String, String> getAdditionalEnvironment() {
        return this.additionalEnv != null ? this.additionalEnv : Collections.emptyMap();
    }

    public boolean useInterpreter() {
        return this.useInterpreter;
    }

    public void useInterpreter(boolean bl) {
        this.useInterpreter = bl;
    }

    public boolean isRerun() {
        return this.rerun;
    }

    public void setRerun(boolean bl) {
        this.rerun = bl;
    }

    public RubyExecutionDescriptor addOutConvertor(LineConvertor lineConvertor) {
        this.outConvertors.add(lineConvertor);
        return this;
    }

    public RubyExecutionDescriptor addErrConvertor(LineConvertor lineConvertor) {
        this.errConvertors.add(lineConvertor);
        return this;
    }

    public void setErrProcessorFactory(ExecutionDescriptor.InputProcessorFactory inputProcessorFactory) {
        this.errProcessorFactory = inputProcessorFactory;
    }

    public void setOutProcessorFactory(ExecutionDescriptor.InputProcessorFactory inputProcessorFactory) {
        this.outProcessorFactory = inputProcessorFactory;
    }

    public RubyExecutionDescriptor lineBased(boolean bl) {
        this.lineBased = bl;
        return this;
    }

    public ExecutionDescriptor toExecutionDescriptor() {
        return new ExecutionDescriptor().showProgress(this.showProgress).controllable(this.isRerun()).inputVisible(this.inputVisible).frontWindow(this.frontWindow).showSuspended(this.showSuspended).postExecution(this.postBuildAction).errLineBased(this.lineBased).outLineBased(this.lineBased).outConvertorFactory(this.lineConvertorFactory(this.outConvertors)).errConvertorFactory(this.lineConvertorFactory(this.errConvertors)).outProcessorFactory(this.outProcessorFactory).errProcessorFactory(this.errProcessorFactory);
    }

    private ExecutionDescriptor.LineConvertorFactory lineConvertorFactory(List<LineConvertor> list) {
        LineConvertor[] lineConvertorArray = list.toArray(new LineConvertor[list.size()]);
        if (this.addStandardConvertors) {
            return RubyLineConvertorFactory.withStandardConvertors(this.fileLocator, lineConvertorArray);
        }
        return RubyLineConvertorFactory.create(this.fileLocator, lineConvertorArray);
    }
}

