/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.spi;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public abstract class WebRestSupport
extends RestSupport {
    public WebRestSupport(Project project) {
        super(project);
    }

    public FileObject getPersistenceXml() {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.getProject().getProjectDirectory());
        if (persistenceScope != null) {
            return persistenceScope.getPersistenceXml();
        }
        return null;
    }

    public WebApp getWebApp() throws IOException {
        FileObject fileObject = this.getWebXml();
        if (fileObject != null) {
            return DDProvider.getDefault().getDDRoot(fileObject);
        }
        return null;
    }

    public FileObject getWebXml() throws IOException {
        File file;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (file = j2eeModuleProvider.getJ2eeModule().getDeploymentConfigurationFile("WEB-INF/web.xml")) != null && file.exists()) {
            return FileUtil.toFileObject((File)file);
        }
        return null;
    }

    public ServletMapping getRestServletMapping(WebApp webApp) {
        for (ServletMapping servletMapping : webApp.getServletMapping()) {
            if (!"ServletAdaptor".equals(servletMapping.getServletName())) continue;
            return servletMapping;
        }
        return null;
    }

    protected boolean hasRestServletAdaptor() {
        try {
            return this.getRestServletAdaptor(this.getWebApp()) != null;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    protected Servlet getRestServletAdaptor(WebApp webApp) {
        if (webApp != null) {
            for (Servlet servlet : webApp.getServlet()) {
                if (!"ServletAdaptor".equals(servlet.getServletName())) continue;
                return servlet;
            }
        }
        return null;
    }

    protected void addResourceConfigToWebApp() throws IOException {
        FileObject fileObject = this.getWebXml();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        boolean bl = false;
        try {
            ServletMapping servletMapping;
            Servlet servlet = this.getRestServletAdaptor(webApp);
            if (servlet == null) {
                servlet = (Servlet)webApp.createBean("Servlet");
                servlet.setServletName("ServletAdaptor");
                servlet.setServletClass(this.getServletAdapterClass());
                servlet.setLoadOnStartup(BigInteger.valueOf(1L));
                webApp.addServlet(servlet);
                bl = true;
            }
            if ((servletMapping = this.getRestServletMapping(webApp)) == null) {
                servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                servletMapping.setServletName(servlet.getServletName());
                servletMapping.setUrlPattern("/resources/*");
                webApp.addServletMapping(servletMapping);
                bl = true;
            }
            if (bl) {
                webApp.write(fileObject);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException);
        }
    }

    protected void removeResourceConfigFromWebApp() throws IOException {
        ServletMapping servletMapping;
        FileObject fileObject = this.getWebXml();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        boolean bl = false;
        Servlet servlet = this.getRestServletAdaptor(webApp);
        if (servlet != null) {
            webApp.removeServlet(servlet);
            bl = true;
        }
        if ((servletMapping = this.getRestServletMapping(webApp)) != null) {
            webApp.removeServletMapping(servletMapping);
            bl = true;
        }
        if (bl) {
            webApp.write(fileObject);
        }
    }
}

