/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSContextProviderWrapper;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSEditorUtil;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSUtil;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.netbeans.modules.web.client.tools.api.JSAbstractLocation;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSSource;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSURILocation;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSFactory;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;

public final class NbJSURIBreakpoint
extends NbJSBreakpoint {
    private WeakReference<Line> ownerLineRef;

    NbJSURIBreakpoint(String string, int n) {
        super(NbJSURIBreakpoint.createNbJSAbstactLocation(string, n));
    }

    public static final JSAbstractLocation createNbJSAbstactLocation(String string, int n) {
        assert (NbJSURIBreakpoint.checkAbsolute(string));
        JSURILocation jSURILocation = new JSURILocation(string, n, 0);
        return jSURILocation;
    }

    private static boolean checkAbsolute(String string) {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return false;
        }
        return uRI.isAbsolute();
    }

    public JSURILocation getLocation() {
        JSAbstractLocation jSAbstractLocation = super.getLocation();
        assert (jSAbstractLocation instanceof JSURILocation);
        return (JSURILocation)jSAbstractLocation;
    }

    public FileObject getFileObject() {
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (session == null) {
            return null;
        }
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        return this.getFileObject(debuggerEngine);
    }

    public void setOwnerLine(Line line) {
        this.ownerLineRef = new WeakReference<Line>(line);
    }

    public Line getOwnerLine() {
        return this.ownerLineRef != null ? (Line)this.ownerLineRef.get() : null;
    }

    public FileObject getFileObject(DebuggerEngine debuggerEngine) {
        assert (debuggerEngine != null);
        FileObject fileObject = null;
        NbJSDebugger nbJSDebugger = (NbJSDebugger)debuggerEngine.lookupFirst(null, NbJSDebugger.class);
        if (!(nbJSDebugger == null || nbJSDebugger.isIgnoringQueryStrings() && this.getLocation().getURI().getQuery() != null)) {
            fileObject = nbJSDebugger.getURLFileObjectForSource(this.createJSSource());
        }
        return fileObject;
    }

    private JSSource createJSSource() {
        URI uRI = this.getLocation().getURI();
        assert (uRI.isAbsolute());
        return JSFactory.createJSSource((String)this.getLocation().getURI().toString());
    }

    public Line getLine() {
        FileObject fileObject = this.getFileObject();
        return this.getLine(fileObject);
    }

    public Line getLine(DebuggerEngine debuggerEngine) {
        FileObject fileObject = this.getFileObject(debuggerEngine);
        return this.getLine(fileObject);
    }

    private final Line getLine(FileObject fileObject) {
        if (fileObject != null) {
            LineCookie lineCookie = NbJSEditorUtil.getLineCookie(fileObject);
            if (lineCookie == null) {
                return null;
            }
            Line.Set set = lineCookie.getLineSet();
            if (set == null) {
                return null;
            }
            try {
                return set.getCurrent(this.getLineNumber() - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                NbJSUtil.LOGGER.log(Level.FINE, indexOutOfBoundsException.getMessage(), indexOutOfBoundsException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                NbJSUtil.LOGGER.log(Level.FINE, illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
        return null;
    }

    public void setLine(String string, int n) {
        JSURILocation jSURILocation = this.getLocation();
        JSAbstractLocation jSAbstractLocation = NbJSURIBreakpoint.createNbJSAbstactLocation(string, n);
        this.setLocation(jSAbstractLocation);
        this.firePropertyChange("lineNumber", jSURILocation, jSAbstractLocation);
    }

    public void setLine(Line line) {
        if (line == null) {
            throw new NullPointerException("Can not set line to null.  Try setLine(uri,lineNum) instead");
        }
        Line line2 = line;
        DataObject dataObject = (DataObject)line.getLookup().lookup(DataObject.class);
        this.setLocation(NbJSURIBreakpoint.createNbJSAbstactLocation(dataObject.getPrimaryFile().getPath(), line.getLineNumber() + 1));
        this.firePropertyChange("lineNumber", line2, line);
    }

    public int getLineNumber() {
        return this.getLocation().getLineNumber();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
        if (this.getFileObject() == null) {
            NbJSContextProviderWrapper.getBreakpointModel().fireChanges();
        }
    }

    public int hashCode() {
        int n = 100 * this.getLocation().getURI().toString().hashCode();
        return n += this.getLineNumber();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof NbJSURIBreakpoint)) {
            return false;
        }
        NbJSURIBreakpoint nbJSURIBreakpoint = (NbJSURIBreakpoint)((Object)object);
        String string = this.getLocation().getURI().toString();
        if (!nbJSURIBreakpoint.getLocation().getURI().toString().equals(string)) {
            return false;
        }
        return nbJSURIBreakpoint.getLineNumber() == this.getLineNumber();
    }
}

