/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.models;

import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEventListener;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class NbJSSessionsModel
implements TableModelFilter,
JSDebuggerEventListener {
    private final List<ModelListener> listeners;
    private Map<NbJSDebugger, Boolean> map = new WeakHashMap<NbJSDebugger, Boolean>();

    public NbJSSessionsModel() {
        this.listeners = new CopyOnWriteArrayList<ModelListener>();
    }

    public Object getValueAt(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        if (object instanceof Session && NbJSSessionsModel.isJSDebuggerSession((Session)object)) {
            if ("SessionState".equals(string)) {
                return this.getSessionState((Session)object);
            }
            if ("SessionLanguage".equals(string)) {
                return object;
            }
            if ("SessionHostName".equals(string)) {
                return ((Session)object).getLocationName();
            }
            throw new UnknownTypeException(object);
        }
        return tableModel.getValueAt(object, string);
    }

    public boolean isReadOnly(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        return tableModel.isReadOnly(object, string);
    }

    public void setValueAt(TableModel tableModel, Object object, String string, Object object2) throws UnknownTypeException {
        tableModel.setValueAt(object, string, object2);
    }

    private static boolean isJSDebuggerSession(Session session) {
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return false;
        }
        return debuggerEngine.lookupFirst(null, NbJSDebugger.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSessionState(Session session) {
        NbJSDebugger nbJSDebugger = (NbJSDebugger)session.getCurrentEngine().lookupFirst(null, NbJSDebugger.class);
        if (nbJSDebugger == null) {
            return NbJSSessionsModel.getMessage("MSG_Session.State.Starting");
        }
        NbJSSessionsModel nbJSSessionsModel = this;
        synchronized (nbJSSessionsModel) {
            if (!this.map.containsKey(nbJSDebugger) || !this.map.get(nbJSDebugger).booleanValue()) {
                nbJSDebugger.addJSDebuggerEventListener((JSDebuggerEventListener)WeakListeners.create(JSDebuggerEventListener.class, (EventListener)((Object)this), (Object)nbJSDebugger));
                this.map.put(nbJSDebugger, Boolean.TRUE);
            }
        }
        return nbJSDebugger.getState();
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(NbJSSessionsModel.class, (String)string);
    }

    public void fireChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public void fireTableValueChanges(Object object, Object object2, String string) {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TableValueChanged(object, object2, string));
        }
    }

    public void onDebuggerEvent(JSDebuggerEvent jSDebuggerEvent) {
        this.fireChanges();
    }
}

