/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.addr2line;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;

public final class RangeMap {
    private SortedMap<Range, Object> ranges = new TreeMap<Range, Object>(new RangeComparator());

    public void put(long l, long l2, Object object) {
        Range range;
        Range range2 = new Range(l, l2);
        SortedMap<Range, Object> sortedMap = this.ranges.tailMap(range2);
        if (!sortedMap.isEmpty() && (range = sortedMap.firstKey()).overlaps(range2)) {
            this.ranges.remove(range);
            this.ranges.put(range2.mergeWith(range), object);
            return;
        }
        this.ranges.put(range2, object);
    }

    public Object get(long l) {
        Range range = new Range(l, l);
        SortedMap<Range, Object> sortedMap = this.ranges.tailMap(range);
        if (sortedMap.isEmpty()) {
            return null;
        }
        Range range2 = sortedMap.firstKey();
        if (range2.contains(l)) {
            return sortedMap.get(range2);
        }
        return null;
    }

    public int size() {
        return this.ranges.size();
    }

    public String toString() {
        return this.ranges.toString();
    }

    static int ucomp(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        if (l < 0L) {
            if (l2 < 0L) {
                if (l < l2) {
                    return 1;
                }
                return -1;
            }
            return 1;
        }
        if (l2 >= 0L) {
            if (l < l2) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    private static class Range {
        final long begin;
        final long end;

        Range(long l, long l2) {
            if (RangeMap.ucomp(l, l2) > 0) {
                throw new IllegalArgumentException("begin is not less than end (unsigned)");
            }
            this.begin = l;
            this.end = l2;
        }

        boolean contains(long l) {
            return RangeMap.ucomp(this.begin, l) <= 0 && RangeMap.ucomp(this.end, l) >= 0;
        }

        boolean contains(Range range) {
            return RangeMap.ucomp(this.begin, range.begin) <= 0 && RangeMap.ucomp(this.end, range.end) >= 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Range)) {
                return false;
            }
            return this.equals((Range)object);
        }

        boolean equals(Range range) {
            return this.begin == range.begin && this.end == range.end;
        }

        public int hashCode() {
            long l = 3L * this.begin + 7L * this.end;
            return (int)(l >> 32) | (int)l;
        }

        boolean overlaps(Range range) {
            return RangeMap.ucomp(this.begin, range.begin) <= 0 && RangeMap.ucomp(this.end, range.begin) >= 0 || RangeMap.ucomp(this.end, range.begin) >= 0 && RangeMap.ucomp(this.end, range.end) <= 0 || RangeMap.ucomp(this.begin, range.end) <= 0 && RangeMap.ucomp(this.end, range.end) >= 0;
        }

        Range mergeWith(Range range) {
            long l;
            if (!this.overlaps(range)) {
                throw new IllegalArgumentException("ranges don't overlap this=" + this + " that=" + range);
            }
            long l2 = this.begin;
            if (RangeMap.ucomp(l2, range.begin) > 0) {
                l2 = range.begin;
            }
            if (RangeMap.ucomp(l = this.end, range.end) < 0) {
                l = range.end;
            }
            return new Range(l2, l);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(24);
            stringBuffer.append("(0x");
            String string = Long.toHexString(this.begin);
            int n = 16 - string.length();
            while (n-- > 0) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            stringBuffer.append(", 0x");
            string = Long.toHexString(this.end);
            n = 16 - string.length();
            while (n-- > 0) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RangeComparator
    implements Comparator<Range> {
        private RangeComparator() {
        }

        @Override
        public int compare(Range range, Range range2) {
            if (range.overlaps(range2)) {
                return 0;
            }
            if (RangeMap.ucomp(range.begin, range2.end) > 0) {
                return 1;
            }
            return -1;
        }
    }
}

