/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.gizmo.GizmoServiceInfo;
import org.netbeans.modules.cnd.gizmo.api.GizmoOptionsProvider;
import org.netbeans.modules.cnd.gizmo.spi.GizmoOptions;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationOptions;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GizmoConfigurationOptions
implements DLightConfigurationOptions {
    private static Logger log = DLightLogger.getLogger(GizmoConfigurationOptions.class);
    private String DLightCollectorString = "SunStudio";
    private List<String> DLightIndicatorDPStrings = Arrays.asList("SunStudio");
    private static final String SUNSTUDIO = "SunStudio";
    private static final String LL_MONITOR = "LLTool";
    private static final String DTRACE = "DTrace";
    private static final String PRSTAT_INDICATOR = "prstat";
    private static final String PROC_READER = "ProcReader";
    private Project currentProject;
    private boolean areCollectorsTurnedOn = false;
    private boolean profileOnRun = true;
    private GizmoOptions gizmoOptions = null;

    public void turnCollectorsState(boolean bl) {
        this.areCollectorsTurnedOn = bl;
    }

    public boolean profileOnRun() {
        return this.profileOnRun;
    }

    public Collection<String> getActiveToolNames() {
        if (this.gizmoOptions == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<String> collection = this.gizmoOptions.getNames();
        for (String string : collection) {
            if (!this.gizmoOptions.getValueByName(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void configure(Project project) {
        Object object2;
        this.areCollectorsTurnedOn = true;
        this.currentProject = project;
        Configuration configuration = this.getActiveConfiguration();
        this.gizmoOptions = GizmoOptionsProvider.getOptions(configuration);
        this.gizmoOptions.init(configuration);
        this.turnCollectorsState(true);
        this.profileOnRun = this.gizmoOptions.getProfileOnRunValue();
        String string = null;
        if (!(configuration instanceof MakeConfiguration)) {
            return;
        }
        string = ((MakeConfiguration)configuration).getDevelopmentHost().getHostKey();
        CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((ExecutionEnvironment)((MakeConfiguration)configuration).getDevelopmentHost().getExecutionEnvironment());
        List list = compilerSetManager.getCompilerSets();
        boolean bl = false;
        for (Object object2 : list) {
            if (!object2.isSunCompiler()) continue;
            bl = true;
            break;
        }
        Object object3 = this.gizmoOptions.getDataProviderValue();
        this.DLightCollectorString = DTRACE;
        this.DLightIndicatorDPStrings = Arrays.asList(PROC_READER, PRSTAT_INDICATOR, DTRACE);
        if (object3 == GizmoOptions.DataProvider.SUN_STUDIO) {
            this.DLightCollectorString = SUNSTUDIO;
            this.DLightIndicatorDPStrings = new ArrayList<String>();
            this.DLightIndicatorDPStrings.add(SUNSTUDIO);
            this.DLightIndicatorDPStrings.add(PRSTAT_INDICATOR);
            this.DLightIndicatorDPStrings.add(PROC_READER);
            if (!bl && ((String)(object2 = ((MakeConfiguration)this.getActiveConfiguration()).getDevelopmentHost().getBuildPlatformDisplayName())).indexOf("Linux") != -1) {
                this.setForLinux();
            }
        } else if (object3 == GizmoOptions.DataProvider.SIMPLE) {
            log.log(Level.FINEST, "Simple Data provider is used will try to set LL monitor + proc reader");
            if (!this.setForLinux()) {
                log.log(Level.FINEST, "Looks like it is not linux and not MacOS platform is " + ((MakeConfiguration)this.getActiveConfiguration()).getDevelopmentHost().getBuildPlatformDisplayName());
            }
        } else if (object3 == GizmoOptions.DataProvider.DTRACE && ((String)(object2 = ((MakeConfiguration)this.getActiveConfiguration()).getDevelopmentHost().getBuildPlatformDisplayName())).indexOf("Solaris") == -1) {
            this.setForLinux();
        }
    }

    private boolean setForLinux() {
        String string = ((MakeConfiguration)this.getActiveConfiguration()).getDevelopmentHost().getBuildPlatformDisplayName();
        if (string.indexOf("Linux") != -1 || !GizmoServiceInfo.isPlatformSupported(string)) {
            this.areCollectorsTurnedOn = false;
            this.DLightCollectorString = string.indexOf("Linux") != -1 ? SUNSTUDIO : "";
            this.DLightIndicatorDPStrings = Arrays.asList(PROC_READER, LL_MONITOR);
            return true;
        }
        return false;
    }

    private Configuration getActiveConfiguration() {
        return ConfigurationSupport.getProjectActiveConfiguration((Project)this.currentProject);
    }

    public boolean areCollectorsTurnedOn() {
        return this.areCollectorsTurnedOn;
    }

    public List<DataCollector<?>> getCollectors(DLightTool dLightTool) {
        List list = dLightTool.getCollectors();
        ArrayList arrayList = new ArrayList();
        for (DataCollector dataCollector : list) {
            if (!dataCollector.getName().equals(this.DLightCollectorString)) continue;
            arrayList.add(dataCollector);
        }
        return arrayList;
    }

    public List<IndicatorDataProvider<?>> getIndicatorDataProviders(DLightTool dLightTool) {
        List list = dLightTool.getIndicatorDataProviders();
        ArrayList arrayList = new ArrayList();
        for (IndicatorDataProvider indicatorDataProvider : list) {
            for (String string : this.DLightIndicatorDPStrings) {
                if (!indicatorDataProvider.getName().equals(string)) continue;
                arrayList.add(indicatorDataProvider);
            }
        }
        return arrayList;
    }

    public boolean validateToolsRequiredUserInteraction() {
        return false;
    }
}

