/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.util.DLightLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfSourceInfoProvider
implements SourceFileInfoProvider {
    private WeakHashMap<String, Map<String, SourceFileInfoProvider.SourceFileInfo>> cache = new WeakHashMap();

    public SourceFileInfoProvider.SourceFileInfo fileName(String string, long l, Map<String, String> map) {
        if (map == null) {
            return null;
        }
        String string2 = map.get("GizmoProjectExecutable");
        if (string2 != null) {
            Map<String, SourceFileInfoProvider.SourceFileInfo> map2 = this.getSourceInfo(string2, map);
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = map2.get(string);
            if (sourceFileInfo != null) {
                return sourceFileInfo;
            }
            int n = string.indexOf(40);
            if (0 <= n && (sourceFileInfo = map2.get(string.substring(0, n))) != null) {
                return sourceFileInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Map<String, SourceFileInfoProvider.SourceFileInfo> getSourceInfo(String string, Map<String, String> map) {
        Map<String, SourceFileInfoProvider.SourceFileInfo> map2 = this.cache.get(string);
        if (map2 == null) {
            map2 = new HashMap<String, SourceFileInfoProvider.SourceFileInfo>();
            try {
                Dwarf dwarf = new Dwarf(string);
                try {
                    for (CompilationUnit compilationUnit : dwarf.getCompilationUnits()) {
                        for (DwarfEntry dwarfEntry : compilationUnit.getDeclarations()) {
                            if (!dwarfEntry.getKind().equals((Object)TAG.DW_TAG_subprogram)) continue;
                            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = new SourceFileInfoProvider.SourceFileInfo(DwarfSourceInfoProvider.toAbsolutePath(map, dwarfEntry.getDeclarationFilePath()), dwarfEntry.getLine(), 0);
                            map2.put(dwarfEntry.getQualifiedName(), sourceFileInfo);
                        }
                    }
                }
                finally {
                    dwarf.dispose();
                }
            }
            catch (IOException iOException) {
                DLightLogger.instance.log(Level.INFO, null, iOException);
            }
            this.cache.put(string, map2.isEmpty() ? Collections.emptyMap() : map2);
        }
        return map2;
    }

    private static String toAbsolutePath(Map<String, String> map, String string) {
        String string2 = map.get("GizmoProjectFolder");
        if (string2 != null) {
            string = IpeUtils.toAbsolutePath((String)string2, (String)string);
        }
        return string;
    }
}

