/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.indicator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndicatorDataProvider<T extends IndicatorDataProviderConfiguration>
implements DLightTargetListener,
Validateable<DLightTarget>,
DataFilterListener {
    private final Collection<Indicator> listeners = new ArrayList<Indicator>();
    private ServiceInfoDataStorage serviceInfoDataStorage;

    private void addIndicatorDataProviderListener(Indicator indicator) {
        if (!this.listeners.contains(indicator)) {
            this.listeners.add(indicator);
        }
    }

    private void removeIndicatorDataProviderListener(Indicator indicator) {
        this.listeners.remove(indicator);
    }

    public final boolean subscribe(Indicator indicator) {
        List<DataTableMetadata.Column> list = IndicatorAccessor.getDefault().getMetadataColumns(indicator);
        for (DataTableMetadata dataTableMetadata : this.getDataTablesMetadata()) {
            List<DataTableMetadata.Column> list2 = dataTableMetadata.getColumns();
            for (DataTableMetadata.Column column : list2) {
                for (DataTableMetadata.Column column2 : list) {
                    if (!column2.equals(column)) continue;
                    this.addIndicatorDataProviderListener(indicator);
                    return true;
                }
            }
        }
        return false;
    }

    public final void unsubscribe(Indicator indicator) {
        this.removeIndicatorDataProviderListener(indicator);
    }

    protected final void resetIndicators() {
        for (Indicator indicator : this.listeners) {
            indicator.reset();
        }
    }

    protected final void notifyIndicators(List<DataRow> list) {
        for (Indicator indicator : this.listeners) {
            indicator.updated(list);
        }
    }

    public abstract Collection<DataTableMetadata> getDataTablesMetadata();

    public abstract String getName();

    public final void init(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoDataStorage = serviceInfoDataStorage;
    }

    protected final ServiceInfoDataStorage getServiceInfoDataStorage() {
        return this.serviceInfoDataStorage;
    }
}

