/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.impl.DLightToolAccessor;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ToolsConfiguration {
    private static final String KNOWN_TOOLS_SET = "KnownToolsConfigurationProviders";
    private final FileObject rootFolder;
    private boolean useRootFolder = false;
    private List<DLightTool> cachedList = null;

    static ToolsConfiguration create(FileObject fileObject) {
        return new ToolsConfiguration(fileObject, false);
    }

    static ToolsConfiguration createDefault(FileObject fileObject) {
        return new ToolsConfiguration(fileObject, true);
    }

    private ToolsConfiguration(FileObject fileObject, boolean bl) {
        this.rootFolder = fileObject;
        this.useRootFolder = bl;
    }

    final List<DLightTool> getToolsSet(boolean bl) {
        if (!bl || this.cachedList == null) {
            return this.getToolsSet();
        }
        return this.cachedList;
    }

    final List<DLightTool> getToolsSet() {
        FileObject fileObject;
        ArrayList<DLightTool> arrayList = new ArrayList<DLightTool>();
        FileObject fileObject2 = fileObject = this.useRootFolder ? this.rootFolder : this.rootFolder.getFileObject(KNOWN_TOOLS_SET);
        if (fileObject == null) {
            return arrayList;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            return arrayList;
        }
        for (FileObject fileObject3 : fileObjectArray) {
            Object object;
            Enumeration enumeration = fileObject3.getAttributes();
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject3);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Logger.getLogger(ToolsConfiguration.class.getName()).log(Level.SEVERE, null, dataObjectNotFoundException);
            }
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            if (instanceCookie == null) {
                object = "D-Light tool configuration " + fileObject3.getName() + " not found";
                Logger.getLogger(ToolsConfiguration.class.getName()).log(Level.SEVERE, (String)object, new Exception((String)object));
                continue;
            }
            try {
                object = instanceCookie.instanceClass();
                DLightToolConfigurationProvider dLightToolConfigurationProvider = (DLightToolConfigurationProvider)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
                arrayList.add(DLightToolAccessor.getDefault().newDLightTool(dLightToolConfigurationProvider.create()));
            }
            catch (InstantiationException instantiationException) {
                Exceptions.printStackTrace((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Exceptions.printStackTrace((Throwable)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Exceptions.printStackTrace((Throwable)noSuchMethodException);
            }
            catch (SecurityException securityException) {
                Exceptions.printStackTrace((Throwable)securityException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }
        if (this.cachedList == null) {
            this.cachedList = arrayList;
        }
        return arrayList;
    }
}

